/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Point;
import java.awt.geom.Point2D;
import org.jplot2d.element.Axis;
import org.jplot2d.element.PComponent;
import org.jplot2d.env.BatchToken;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseAxisWheelZoomBehavior;
import org.jplot2d.interaction.MouseWheelBehaviorHandler;
import org.jplot2d.notice.UINoticeType;

public class MouseAxisWheelZoomHandler
extends MouseWheelBehaviorHandler<MouseAxisWheelZoomBehavior> {
    public MouseAxisWheelZoomHandler(MouseAxisWheelZoomBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
    }

    @Override
    public boolean behaviorPerformed(int x, int y, int wheelRotation) {
        PComponent pcomp = (PComponent)this.handler.getValue("ACTIVE_COMPONENT");
        if (!(pcomp instanceof Axis)) {
            return false;
        }
        Axis axis = (Axis)pcomp;
        double scale = 1.0;
        if (wheelRotation > 0) {
            scale = 2.0;
        } else if (wheelRotation < 0) {
            scale = 0.5;
        }
        Point2D pp = axis.getPaperTransform().getDtoP(new Point(x, y));
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        BatchToken token = env.beginBatch("AxisWheelZoom");
        double npv = pp.getX() / axis.getLength();
        double start = npv * (1.0 - scale);
        double end = start + scale;
        axis.getTickManager().getAxisTransform().getLockGroup().zoomRange(start, end);
        env.endBatch(token, UINoticeType.getInstance());
        return true;
    }
}

