/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.LegendEx;
import org.jplot2d.element.impl.LegendItemImpl;
import org.jplot2d.element.impl.XYGraphEx;
import org.jplot2d.element.impl.XYLegendItemEx;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.MathLabel;
import org.jplot2d.tex.TeXMathUtils;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.SymbolShape;

public class XYLegendItemImpl
extends LegendItemImpl
implements XYLegendItemEx {
    private static final double LABEL_SPACE = 8.0;
    private static final double LINE_LENGTH = 24.0;
    private float symbolSize = Float.NaN;
    private MathElement textModel;
    private transient MathLabel label;

    @Override
    public XYGraphEx getParent() {
        return super.getParent();
    }

    @Override
    public void setLegend(LegendEx legend) {
        Font oldFont = this.getLegend() == null ? null : this.getLegend().getEffectiveFont();
        super.setLegend(legend);
        if (legend != null && !legend.getEffectiveFont().equals(oldFont)) {
            this.label = null;
            if (this.isVisible() && this.getLegend() != null) {
                this.getLegend().itemSizeChanged(this);
            }
        }
    }

    @Override
    public void legendEffectiveFontChanged() {
        this.label = null;
        if (this.isVisible() && this.getLegend() != null) {
            this.getLegend().itemSizeChanged(this);
        }
    }

    private MathLabel getLabel() {
        if (this.label == null && this.getLegend() != null && this.getLegend().getEffectiveFont().getSize2D() > 0.0f) {
            this.label = new MathLabel(this.textModel, this.getLegend().getEffectiveFont(), VAlign.MIDDLE, HAlign.LEFT);
        }
        return this.label;
    }

    @Override
    public Dimension2D getSize() {
        if (this.getLabel() == null) {
            return null;
        }
        Rectangle2D labelBounds = this.getLabel().getBounds();
        double width = labelBounds.getWidth();
        double height = labelBounds.getHeight();
        if (height < (double)this.getEffectiveSymbolSize()) {
            height = this.getEffectiveSymbolSize();
        }
        return new DoubleDimension2D(32.0 + width, height);
    }

    @Override
    public String getText() {
        return TeXMathUtils.toString(this.textModel);
    }

    @Override
    public void setText(String text) {
        boolean contributable = this.canContribute();
        this.textModel = TeXMathUtils.parseText(text);
        this.label = null;
        if (this.getLegend() != null) {
            if (this.canContribute() != contributable) {
                this.getLegend().itemContribitivityChanged(this);
            } else if (contributable) {
                this.getLegend().itemSizeChanged(this);
            }
        }
    }

    @Override
    public boolean canContribute() {
        return this.textModel != null && this.textModel != MathElement.EMPTY;
    }

    @Override
    public float getSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public void setSymbolSize(float size) {
        if (this.symbolSize != size) {
            this.symbolSize = size;
            this.symbolSizeChanged();
        }
    }

    @Override
    public void graphSymbolSizeChanged() {
        if (Float.isNaN(this.symbolSize)) {
            this.symbolSizeChanged();
        }
    }

    private void symbolSizeChanged() {
        if (this.isVisible() && this.getLegend() != null) {
            this.getLegend().itemSizeChanged(this);
        }
    }

    private float getEffectiveSymbolSize() {
        if (Float.isNaN(this.symbolSize)) {
            return this.getParent().getSymbolSize();
        }
        return this.symbolSize;
    }

    @Override
    public void draw(Graphics2D g) {
        float ay;
        Point2D loc = this.getLocation();
        XYGraphEx graph = this.getParent();
        float ax = (float)loc.getX();
        float bx = ax + 24.0f;
        float by = ay = (float)loc.getY();
        Color sc = graph.getEffectiveSymbolColor();
        if (graph.isLineVisible()) {
            g.setColor(graph.getEffectiveColor());
            g.setStroke(graph.getLineStroke());
            Path2D.Float gp = new Path2D.Float();
            gp.moveTo(ax, ay);
            gp.lineTo(bx, by);
            g.draw(gp);
            if (graph.isSymbolVisible()) {
                this.drawSymbol(g, ax, ay, sc);
                this.drawSymbol(g, bx, by, sc);
            }
        } else if (graph.isSymbolVisible()) {
            this.drawSymbol(g, bx, by, sc);
        }
        this.drawLabel(g);
    }

    private void drawSymbol(Graphics2D g, float x, float y, Color color) {
        XYGraphEx graph = this.getParent();
        float lw = graph.getLineStroke().getLineWidth() / 2.0f;
        g.setStroke(new BasicStroke(lw, 0, 0));
        g.setColor(color);
        float actSymbolSize = this.getEffectiveSymbolSize();
        AffineTransform maf = AffineTransform.getTranslateInstance(x, y);
        maf.scale(actSymbolSize, actSymbolSize);
        SymbolShape ss = graph.getSymbolShape();
        ss.draw(g, maf);
    }

    private void drawLabel(Graphics2D g) {
        AffineTransform oldTransform = g.getTransform();
        g.translate(this.getLocation().getX() + 24.0 + 8.0, this.getLocation().getY());
        g.scale(1.0, -1.0);
        g.setColor(Color.BLACK);
        this.getLabel().draw(g);
        g.setTransform(oldTransform);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        XYLegendItemImpl xyli = (XYLegendItemImpl)src;
        this.textModel = xyli.textModel;
    }
}

