/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.data.XYGraphData;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.XYGraphEx;
import org.jplot2d.transform.Transform1D;
import org.jplot2d.util.GraphicsUtil;
import org.jplot2d.util.LineHatchPaint;

public class XYGraphFiller {
    private LayerEx layer;
    private XYGraphEx graph;
    private XYGraphData graphData;
    private Rectangle2D clip;
    private Transform1D xW2D;
    private Transform1D yW2D;
    private int startx;
    private int starty;
    private int endx;
    private int endy;

    public static XYGraphFiller getInstance(XYGraphEx graph, Rectangle2D clip) {
        XYGraphFiller builder = new XYGraphFiller();
        builder.setLineData(graph);
        builder.setClip(clip);
        return builder;
    }

    private XYGraphFiller() {
    }

    private void setLineData(XYGraphEx dp) {
        this.graphData = dp.getData();
        this.layer = dp.getParent();
        this.graph = dp;
        this.calcTransformXY();
    }

    private void setClip(Rectangle2D clip) {
        this.clip = clip;
    }

    private void calcTransformXY() {
        this.xW2D = this.layer.getXAxisTransform().getNormalTransform().createTransform(this.layer.getPaperTransform().getXPtoD(0.0), this.layer.getPaperTransform().getXPtoD(this.layer.getSize().getWidth()));
        this.yW2D = this.layer.getYAxisTransform().getNormalTransform().createTransform(this.layer.getPaperTransform().getYPtoD(0.0), this.layer.getPaperTransform().getYPtoD(this.layer.getSize().getHeight()));
    }

    public void fill(Graphics2D g, Paint p) {
        double scale = this.layer.getPaperTransform().getScale();
        Path2D path = this.getFillShape();
        if (p instanceof LineHatchPaint) {
            LineHatchPaint lhp = (LineHatchPaint)p;
            Shape[] hatch = lhp.calcHatchShapes(path, this.clip, scale);
            g.setColor(lhp.getColor());
            g.setStroke(GraphicsUtil.scaleStroke(lhp.getStroke(), scale));
            for (Shape shape : hatch) {
                g.draw(shape);
            }
        } else {
            g.setPaint(p);
            g.fill(path);
        }
    }

    private Path2D getFillShape() {
        Path2D.Double path = new Path2D.Double();
        switch (this.graph.getChartType()) {
            case LINECHART: {
                this.fillPolygon(path);
                break;
            }
            case HISTOGRAM: {
                this.fillHistogram(path);
                break;
            }
            case HISTOGRAM_EDGE: {
                this.fillEdgeHistogram(path);
            }
        }
        this.closeLine(path);
        return path;
    }

    private void fillPolygon(Path2D path) {
        boolean hasPre = false;
        for (int i = 0; i < this.graphData.size(); ++i) {
            if (Double.isNaN(this.graphData.getX(i)) || Double.isNaN(this.graphData.getY(i))) continue;
            double x = this.xW2D.convert(this.graphData.getX(i));
            double y = this.yW2D.convert(this.graphData.getY(i));
            int ix = (int)(x + 0.5);
            int iy = (int)(y + 0.5);
            if (hasPre) {
                if (this.endx != ix || this.endy != iy) {
                    path.lineTo(ix, iy);
                }
            } else {
                path.moveTo(ix, iy);
                this.startx = ix;
                this.starty = iy;
                hasPre = true;
            }
            this.endx = ix;
            this.endy = iy;
        }
    }

    private void fillHistogram(Path2D path) {
        boolean hasPre = false;
        double preDotX = 0.0;
        for (int i = 0; i < this.graphData.size(); ++i) {
            if (Double.isNaN(this.graphData.getX(i)) || Double.isNaN(this.graphData.getY(i))) continue;
            double x = this.xW2D.convert(this.graphData.getX(i));
            double y = this.yW2D.convert(this.graphData.getY(i));
            int iy = (int)(y + 0.5);
            if (hasPre) {
                int imx = (int)(preDotX + x + 1.0) / 2;
                if (this.endx != imx || this.endy != iy) {
                    path.lineTo(imx, this.endy);
                    path.lineTo(imx, iy);
                    this.endx = imx;
                    this.endy = iy;
                }
            } else {
                int ix = (int)(x + 0.5);
                path.moveTo(ix, iy);
                this.startx = ix;
                this.starty = iy;
                hasPre = true;
                this.endx = ix;
                this.endy = iy;
            }
            preDotX = x;
        }
        if (hasPre) {
            path.lineTo(preDotX, this.endy);
        }
    }

    private void fillEdgeHistogram(Path2D path) {
        boolean hasPre = false;
        for (int i = 0; i < this.graphData.size(); ++i) {
            if (Double.isNaN(this.graphData.getX(i)) || Double.isNaN(this.graphData.getY(i))) continue;
            double x = this.xW2D.convert(this.graphData.getX(i));
            double y = this.yW2D.convert(this.graphData.getY(i));
            int ix = (int)(x + 0.5);
            int iy = (int)(y + 0.5);
            if (hasPre) {
                if (this.endx != ix || this.endy != iy) {
                    path.lineTo(ix, this.endy);
                    path.lineTo(ix, iy);
                }
            } else {
                path.moveTo(ix, iy);
                this.startx = ix;
                this.starty = iy;
                hasPre = true;
            }
            this.endx = ix;
            this.endy = iy;
        }
    }

    private void closeLine(Path2D path) {
        switch (this.graph.getFillClosureType()) {
            case SELF: {
                path.closePath();
                break;
            }
            case LEFT: {
                path.lineTo(-32767.0, this.endy);
                path.lineTo(-32767.0, this.starty);
                path.closePath();
                break;
            }
            case RIGHT: {
                path.lineTo(32767.0, this.endy);
                path.lineTo(32767.0, this.starty);
                path.closePath();
                break;
            }
            case TOP: {
                path.lineTo(this.endx, -32767.0);
                path.lineTo(this.startx, -32767.0);
                path.closePath();
                break;
            }
            case BOTTOM: {
                path.lineTo(this.endx, 32767.0);
                path.lineTo(this.startx, 32767.0);
                path.closePath();
            }
        }
    }
}

