/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.MultiBandImageData;
import org.jplot2d.element.RGBImageMapping;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.GraphImpl;
import org.jplot2d.element.impl.ImageBandTransformEx;
import org.jplot2d.element.impl.ImageZscaleCache;
import org.jplot2d.element.impl.IntermediateCacheEx;
import org.jplot2d.element.impl.RGBImageGraphEx;
import org.jplot2d.element.impl.RGBImageMappingEx;
import org.jplot2d.transform.NormalTransform;
import org.jplot2d.transform.PaperTransform;

public class RGBImageGraphImpl
extends GraphImpl
implements RGBImageGraphEx,
IntermediateCacheEx {
    private RGBImageMappingEx mapping;
    private MultiBandImageData data;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "RGBImageGraph" + this.getParent().indexOf(this);
        }
        return "RGBImageGraph@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public RGBImageMappingEx getMapping() {
        return this.mapping;
    }

    @Override
    public void setMapping(RGBImageMapping mapping) {
        if (this.mapping != null) {
            this.mapping.removeImageGraph(this);
        }
        this.mapping = (RGBImageMappingEx)mapping;
        if (this.mapping != null) {
            this.mapping.addImageGraph(this);
        }
    }

    @Override
    public MultiBandImageData getData() {
        return this.data;
    }

    @Override
    public void setData(MultiBandImageData data) {
        MultiBandImageData olddata = this.data;
        this.data = data;
        if (olddata == null || data == null || data.getDataBuffer()[0] != olddata.getDataBuffer()[0]) {
            this.mapping.getRedTransform().recalcLimits();
        }
        if (olddata == null || data == null || data.getDataBuffer()[1] != olddata.getDataBuffer()[1]) {
            this.mapping.getGreenTransform().recalcLimits();
        }
        if (olddata == null || data == null || data.getDataBuffer()[2] != olddata.getDataBuffer()[2]) {
            this.mapping.getBlueTransform().recalcLimits();
        }
        RGBImageGraphImpl.redraw(this);
    }

    @Override
    public void thisEffectiveColorChanged() {
    }

    @Override
    public void mappingChanged() {
        RGBImageGraphImpl.redraw(this);
    }

    @Override
    public Object createCacheHolder() {
        if (this.data == null) {
            return null;
        }
        ImageZscaleCache.Key[] cacheHolder = new ImageZscaleCache.Key[3];
        ImageBandTransformEx redTrans = this.mapping.getRedTransform();
        ImageBandTransformEx greenTrans = this.mapping.getGreenTransform();
        ImageBandTransformEx blueTrans = this.mapping.getBlueTransform();
        cacheHolder[0] = ImageZscaleCache.createCacheFor(this.data.getDataBuffer()[0], this.data.getWidth(), this.data.getHeight(), redTrans.getLimits(), redTrans.getIntensityTransform(), redTrans.getBias(), redTrans.getGain(), 8);
        cacheHolder[1] = ImageZscaleCache.createCacheFor(this.data.getDataBuffer()[0], this.data.getWidth(), this.data.getHeight(), greenTrans.getLimits(), greenTrans.getIntensityTransform(), greenTrans.getBias(), greenTrans.getGain(), 8);
        cacheHolder[2] = ImageZscaleCache.createCacheFor(this.data.getDataBuffer()[0], this.data.getWidth(), this.data.getHeight(), blueTrans.getLimits(), blueTrans.getIntensityTransform(), blueTrans.getBias(), blueTrans.getGain(), 8);
        return cacheHolder;
    }

    @Override
    public ComponentEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        RGBImageGraphImpl result = (RGBImageGraphImpl)super.copyStructure((Map)orig2copyMap);
        RGBImageMappingEx mappingCopy = (RGBImageMappingEx)orig2copyMap.get(this.mapping);
        if (mappingCopy == null) {
            mappingCopy = (RGBImageMappingEx)this.mapping.copyStructure(orig2copyMap);
        }
        result.mapping = mappingCopy;
        mappingCopy.addImageGraph(result);
        return result;
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        this.data = ((RGBImageGraphImpl)src).data;
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.data == null) {
            return;
        }
        ImageBandTransformEx redTrans = this.mapping.getRedTransform();
        ImageBandTransformEx greenTrans = this.mapping.getGreenTransform();
        ImageBandTransformEx blueTrans = this.mapping.getBlueTransform();
        double[] redLimits = this.mapping.getRedTransform().getLimits();
        double[] greenLimits = this.mapping.getGreenTransform().getLimits();
        double[] blueLimits = this.mapping.getBlueTransform().getLimits();
        if (redLimits == null && greenLimits == null && blueLimits == null) {
            return;
        }
        int width = this.data.getWidth();
        int height = this.data.getHeight();
        double xval = this.data.getXRange().getMin();
        double yval = this.data.getYRange().getMin();
        WritableRaster raster = null;
        ImageDataBuffer[] idbs = this.data.getDataBuffer();
        int bands = idbs.length;
        byte[][] result = new byte[bands][];
        result[0] = (byte[])ImageZscaleCache.getValue(idbs[0], width, height, redLimits, redTrans.getIntensityTransform(), redTrans.getBias(), redTrans.getGain(), 8);
        result[1] = (byte[])ImageZscaleCache.getValue(idbs[1], width, height, greenLimits, greenTrans.getIntensityTransform(), greenTrans.getBias(), greenTrans.getGain(), 8);
        result[2] = (byte[])ImageZscaleCache.getValue(idbs[2], width, height, blueLimits, blueTrans.getIntensityTransform(), blueTrans.getBias(), blueTrans.getGain(), 8);
        BandedSampleModel sm = new BandedSampleModel(0, width, height, bands);
        DataBufferByte dbuffer = new DataBufferByte(result, width * height);
        raster = Raster.createWritableRaster(sm, dbuffer, null);
        int[] bitsArray = new int[]{8, 8, 8};
        ComponentColorModel destCM = new ComponentColorModel(ColorSpace.getInstance(1000), bitsArray, false, true, 1, raster.getSampleModel().getDataType());
        BufferedImage image = new BufferedImage(destCM, raster, false, null);
        PaperTransform pxf = this.getPaperTransform();
        NormalTransform xntrans = this.getParent().getXAxisTransform().getNormalTransform();
        NormalTransform yntrans = this.getParent().getYAxisTransform().getNormalTransform();
        Dimension2D paperSize = this.getParent().getSize();
        double xorig = pxf.getXPtoD(xntrans.convToNR(xval) * paperSize.getWidth());
        double yorig = pxf.getYPtoD(yntrans.convToNR(yval) * paperSize.getHeight());
        double xscale = pxf.getScale() / xntrans.getScale() * paperSize.getWidth() * this.data.getXcdelt();
        double yscale = pxf.getScale() / yntrans.getScale() * paperSize.getHeight() * this.data.getYcdelt();
        AffineTransform at = new AffineTransform(xscale, 0.0, 0.0, -yscale, xorig, yorig);
        Graphics2D g = (Graphics2D)graphics.create();
        Shape clip = this.getPaperTransform().getPtoD(this.getBounds());
        g.setClip(clip);
        g.drawRenderedImage(image, at);
        g.dispose();
    }
}

