/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Font;
import java.awt.geom.Dimension2D;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jplot2d.axtick.RangeAdvisor;
import org.jplot2d.axtick.TickAlgorithm;
import org.jplot2d.axtick.TickCalculator;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.impl.AxisEx;
import org.jplot2d.element.impl.AxisImpl;
import org.jplot2d.element.impl.AxisTickManagerEx;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.ComponentImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.notice.Notice;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.TeXMathUtils;
import org.jplot2d.transform.AxisTickTransform;
import org.jplot2d.transform.NormalTransform;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.NumberArrayUtils;
import org.jplot2d.util.Range;

public class AxisTickManagerImpl
extends ElementImpl
implements AxisTickManagerEx,
Cloneable {
    public static final int DEFAULT_TICKS_NUMBER = 11;
    public static final int AUTO_TICKS_MIN = 4;
    private AxisTransformEx axisTransform;
    private List<AxisEx> axes = new ArrayList<AxisEx>();
    private boolean autoAdjustNumber = true;
    private int tickNumber = 11;
    private boolean autoInterval = true;
    private double interval;
    private double offset;
    private boolean autoValues = true;
    private Object fixedValues;
    private Object fixedMinorValues;
    private boolean autoMinorNumber = true;
    private int actualMinorNumber;
    private int minorNumber;
    private boolean autoLabelFormat = true;
    private Format labelTextFormat;
    private String labelFormat;
    private MathElement[] fixedLabels;
    private int labelInterval = 1;
    private Object values = new double[0];
    private Object minorValues = new double[0];
    private MathElement[] autoLabels;
    private MathElement[] labels = new MathElement[0];
    private TickAlgorithm tickAlgorithm;
    private TickCalculator tickCalculator;
    private boolean autoAdjustNumberChanged;
    private boolean autoIntervalChanged;
    private boolean autoValuesChanged;
    private boolean autoLabelFormatChanged;
    private boolean propNumberChanged;
    private boolean intervalChanged;
    private boolean _valuesChanged;
    private boolean minorNumberChanged;
    private boolean _minorValuesChanged;
    private boolean labelFormatChanged;
    private Map<AxisEx, AxisStatus> axisStatusMap = new HashMap<AxisEx, AxisStatus>();
    private boolean _labelMaxDensityChanged;
    private boolean _rangeChanged;
    private boolean _tickAlgorithmChanged;
    private boolean _axisCircularRangeChanged;
    private boolean _trfChanged;
    private Range range;
    private AxisTickTransform tickTransform;
    private NormalTransform axisNormalTransform;
    private Range circularRange;

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tick(");
        for (AxisEx axis : this.axes) {
            sb.append(axis.getShortId()).append(',');
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        return sb.toString();
    }

    @Override
    public String getFullId() {
        if (this.axisTransform != null) {
            int xidx = this.axisTransform.indexOfTickManager(this);
            return "Tick" + xidx + "." + this.axisTransform.getFullId();
        }
        return "AxisTickManager@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.axes.size() == 0) {
            return null;
        }
        try {
            method = AxisEx.class.getMethod("getTickManager", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public AxisEx getParent() {
        return (AxisImpl)this.parent;
    }

    @Override
    public ElementEx getPrim() {
        if (this.axes.size() == 0) {
            return null;
        }
        return this.axes.get(0);
    }

    @Override
    public void notify(Notice msg) {
        if (this.getPrim() != null) {
            this.getPrim().notify(msg);
        }
    }

    @Override
    public AxisTransformEx getAxisTransform() {
        return this.axisTransform;
    }

    @Override
    public void setAxisTransform(AxisTransform rangeManager) {
        if (this.axisTransform != null) {
            this.axisTransform.removeTickManager(this);
        }
        this.axisTransform = (AxisTransformEx)rangeManager;
        if (this.axisTransform != null) {
            this.axisTransform.addTickManager(this);
            this.updateTickAlgorithm();
        }
    }

    @Override
    public void transformTypeChanged() {
        this.updateTickAlgorithm();
    }

    private void updateTickAlgorithm() {
        TickAlgorithm ta = this.axisTransform.getType().getTickAlgorithm(this.axisTransform.getTransform(), this.getTickTransform());
        if (ta == null) {
            ta = this.axisTransform.getType().getTickAlgorithm(this.axisTransform.getTransform(), null);
        }
        this.setTickAlgorithm(ta);
    }

    @Override
    public AxisEx[] getAxes() {
        return this.axes.toArray(new AxisEx[this.axes.size()]);
    }

    @Override
    public void addAxis(AxisEx axis) {
        this.axes.add(axis);
        this.parent = this.axes.size() == 1 ? (ElementEx)this.axes.get(0) : null;
        this._labelMaxDensityChanged = true;
    }

    @Override
    public void removeAxis(AxisEx axis) {
        this.axes.remove(axis);
        this.parent = this.axes.size() == 1 ? (ElementEx)this.axes.get(0) : null;
        this.axisStatusMap.remove(axis);
        this._labelMaxDensityChanged = true;
    }

    @Override
    public AxisTickTransform getTickTransform() {
        return this.tickTransform;
    }

    @Override
    public void setTickTransform(AxisTickTransform transform) {
        this.tickTransform = transform;
        this._trfChanged = true;
        this.updateTickAlgorithm();
    }

    @Override
    public Range getRange() {
        Range range = this.getAxisTransform().getRange();
        if (this.tickTransform == null) {
            return range;
        }
        double start = this.tickTransform.transformUser2Tick(range.getStart());
        double end = this.tickTransform.transformUser2Tick(range.getEnd());
        return new Range.Double(start, end);
    }

    @Override
    public void setRange(Range range) {
        if (this.tickTransform == null) {
            this.getAxisTransform().setRange(range);
        } else {
            double ustart = this.tickTransform.transformTick2User(range.getStart());
            double uend = this.tickTransform.transformTick2User(range.getEnd());
            this.getAxisTransform().setRange(new Range.Double(ustart, uend));
        }
    }

    @Override
    public boolean isAutoAdjustTicks() {
        return this.autoAdjustNumber;
    }

    @Override
    public void setAutoAdjustTicks(boolean flag) {
        this.autoAdjustNumber = flag;
        this.autoAdjustNumberChanged = true;
    }

    @Override
    public int getTicks() {
        return this.tickNumber;
    }

    @Override
    public void setTicks(int tickNumber) {
        this.tickNumber = tickNumber;
        this.propNumberChanged = true;
    }

    @Override
    public boolean isAutoTickInterval() {
        return this.autoInterval;
    }

    @Override
    public void setAutoTickInterval(boolean autoInterval) {
        if (this.autoInterval != autoInterval) {
            this.autoInterval = autoInterval;
            this.autoIntervalChanged = true;
        }
    }

    @Override
    public double getTickInterval() {
        return this.interval;
    }

    @Override
    public double getTickOffset() {
        return this.offset;
    }

    @Override
    public void setTickInterval(double interval) {
        if (Double.isNaN(interval) || Double.isInfinite(interval)) {
            throw new IllegalArgumentException("tick interval can not be NaN or Infinit.");
        }
        if (this.interval != interval) {
            this.interval = interval;
            this.intervalChanged = true;
            this.setAutoTickInterval(false);
        }
    }

    @Override
    public void setTickOffset(double offset) {
        if (Double.isNaN(this.interval) || Double.isInfinite(this.interval)) {
            throw new IllegalArgumentException("tick offset can not be NaN or Infinit.");
        }
        if (this.offset != offset) {
            this.offset = offset;
            this.intervalChanged = true;
            this.setAutoTickInterval(false);
        }
    }

    @Override
    public boolean isAutoTickValues() {
        return this.autoValues;
    }

    @Override
    public void setAutoTickValues(boolean atv) {
        if (this.autoValues != atv) {
            this.autoValues = atv;
            this.autoValuesChanged = true;
        }
    }

    @Override
    public Object getFixedTickValues() {
        return this.fixedValues;
    }

    @Override
    public void setFixedTickValues(Object values) {
        this.fixedValues = values;
        this.setAutoTickValues(false);
    }

    @Override
    public Object getFixedMinorTickValues() {
        return this.fixedMinorValues;
    }

    @Override
    public void setFixedMinorTickValues(Object minorValues) {
        this.fixedMinorValues = minorValues;
    }

    @Override
    public boolean isAutoMinorTicks() {
        return this.autoMinorNumber;
    }

    @Override
    public void setAutoMinorTicks(boolean flag) {
        if (this.autoMinorNumber != flag) {
            this.autoMinorNumber = flag;
            this.minorNumberChanged = true;
        }
    }

    @Override
    public int getMinorTicks() {
        return this.minorNumber;
    }

    @Override
    public void setMinorTicks(int minors) {
        if (this.minorNumber != minors) {
            this.minorNumber = minors;
            this.minorNumberChanged = true;
            this.setAutoMinorTicks(false);
        }
    }

    @Override
    public int getActualMinorTicks() {
        return this.actualMinorNumber;
    }

    @Override
    public boolean isAutoLabelFormat() {
        return this.autoLabelFormat;
    }

    @Override
    public void setAutoLabelFormat(boolean alf) {
        if (this.autoLabelFormat != alf) {
            this.autoLabelFormat = alf;
            this.autoLabelFormatChanged = true;
        }
    }

    @Override
    public Format getLabelTextFormat() {
        return this.labelTextFormat;
    }

    @Override
    public void setLabelTextFormat(Format format) {
        this.labelTextFormat = format;
        this.labelFormatChanged = true;
        this.setAutoLabelFormat(false);
    }

    @Override
    public String getLabelFormat() {
        return this.labelFormat;
    }

    @Override
    public void setLabelFormat(String format) {
        if (!this.tickCalculator.isValidFormat(format)) {
            throw new IllegalArgumentException("The label format is invalid");
        }
        this.labelFormat = format;
        this.labelFormatChanged = true;
        this.setAutoLabelFormat(false);
    }

    @Override
    public String[] getFixedLabelStrings() {
        if (this.fixedLabels == null) {
            return new String[0];
        }
        String[] result = new String[this.fixedLabels.length];
        for (int i = 0; i < this.fixedLabels.length; ++i) {
            result[i] = TeXMathUtils.toString(this.fixedLabels[i]);
        }
        return result;
    }

    @Override
    public void setFixedLabelStrings(String[] labels) {
        MathElement[] mes = new MathElement[labels.length];
        for (int i = 0; i < mes.length; ++i) {
            mes[i] = TeXMathUtils.parseText(labels[i]);
        }
        this.fixedLabels = mes;
    }

    @Override
    public int getLabelInterval() {
        return this.labelInterval;
    }

    @Override
    public void setLabelInterval(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Label interval cannot be 0 or negative.");
        }
        this.labelInterval = n;
    }

    @Override
    public Object getTickValues() {
        return this.values;
    }

    @Override
    public Object getMinorTickValues() {
        return this.minorValues;
    }

    @Override
    public MathElement[] getLabelModels() {
        return this.labels;
    }

    @Override
    public TickAlgorithm getTickAlgorithm() {
        return this.tickAlgorithm;
    }

    @Override
    public void setTickAlgorithm(TickAlgorithm algorithm) {
        if (this.tickAlgorithm != algorithm) {
            this.tickAlgorithm = algorithm;
            this.tickCalculator = this.tickAlgorithm.createCalculator();
            this._tickAlgorithmChanged = true;
        }
    }

    @Override
    public String[] getLabelStrings() {
        String[] result = new String[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            result[i] = TeXMathUtils.toString(this.labels[i]);
        }
        return result;
    }

    @Override
    public void calcTicks() {
        MathElement[] fixedLabelsInRange;
        Object mvalues;
        Object values;
        AxisTransformEx va = this.getAxisTransform();
        if (!this.getRange().equals(this.range)) {
            this._rangeChanged = true;
            this.range = this.getRange();
        }
        if (this._tickAlgorithmChanged || this._rangeChanged) {
            this.tickCalculator.setRange(this.range);
        }
        if (!va.getNormalTransform().equals(this.axisNormalTransform)) {
            this._trfChanged = true;
            this.axisNormalTransform = va.getNormalTransform();
        }
        if (va.getType().getCircularRange() != this.circularRange) {
            this._axisCircularRangeChanged = true;
            this.circularRange = va.getType().getCircularRange();
        }
        for (AxisEx axis : this.axes) {
            AxisStatus axisStatus = this.axisStatusMap.get(axis);
            if (axisStatus == null) {
                axisStatus = new AxisStatus(axis.getLength(), this.isLabelSameOrientation(axis), axis.getEffectiveFont());
                this.axisStatusMap.put(axis, axisStatus);
                continue;
            }
            boolean labelSameOrientation = this.isLabelSameOrientation(axis);
            boolean newStatus = false;
            if (axis.getLength() != axisStatus.getAxisLength()) {
                this._labelMaxDensityChanged = true;
                newStatus = true;
            }
            if (labelSameOrientation != axisStatus.isLabelSameOrientation()) {
                this._labelMaxDensityChanged = true;
                newStatus = true;
            }
            if (!axis.getEffectiveFont().equals(axisStatus.getLabelFont())) {
                this._labelMaxDensityChanged = true;
                newStatus = true;
            }
            if (!newStatus) continue;
            axisStatus = new AxisStatus(axis.getLength(), labelSameOrientation, axis.getEffectiveFont());
            this.axisStatusMap.put(axis, axisStatus);
        }
        if (this.autoValues && this.autoInterval && this.autoAdjustNumber) {
            this.calcAutoTicks();
            return;
        }
        int[] valueIdxes = null;
        if (this.autoValues) {
            if (this.autoInterval) {
                if (this.autoValuesChanged || this.autoIntervalChanged || this.autoAdjustNumberChanged || this.propNumberChanged || this.minorNumberChanged || this._tickAlgorithmChanged || this._axisCircularRangeChanged || this._rangeChanged) {
                    this.tickCalculator.calcValuesByTickNumber(this.tickNumber, this.autoMinorNumber ? -1 : this.minorNumber);
                    this.interval = this.tickCalculator.getInterval();
                    this.actualMinorNumber = this.tickCalculator.getMinorNumber();
                }
            } else if (this.autoValuesChanged || this.intervalChanged || this.minorNumberChanged || this._tickAlgorithmChanged || this._axisCircularRangeChanged || this._rangeChanged) {
                this.tickCalculator.calcValuesByTickInterval(this.interval, this.offset, this.autoMinorNumber ? -1 : this.minorNumber);
                this.actualMinorNumber = this.tickCalculator.getMinorNumber();
            }
            values = this.tickCalculator.getValues();
            mvalues = this.tickCalculator.getMinorValues();
        } else {
            if (this.fixedValues != null) {
                valueIdxes = this.tickCalculator.getInRangeValuesIdx(this.fixedValues);
                values = NumberArrayUtils.subArray(this.fixedValues, valueIdxes);
            } else {
                values = new double[]{};
            }
            if (this.fixedMinorValues != null) {
                int[] mvalueIdxes = this.tickCalculator.getInRangeValuesIdx(this.fixedMinorValues);
                mvalues = NumberArrayUtils.subArray(this.fixedMinorValues, mvalueIdxes);
            } else {
                mvalues = new double[]{};
            }
        }
        if (!NumberArrayUtils.equals(this.values, values)) {
            this.values = values;
            this._valuesChanged = true;
        }
        if (!NumberArrayUtils.equals(this.minorValues, mvalues)) {
            this.minorValues = mvalues;
            this._minorValuesChanged = true;
        }
        this.autoAdjustNumberChanged = false;
        this.autoIntervalChanged = false;
        this.minorNumberChanged = false;
        this.propNumberChanged = false;
        this.intervalChanged = false;
        this._tickAlgorithmChanged = false;
        this._rangeChanged = false;
        this.autoValuesChanged = false;
        if (this.autoLabelFormat && (this._valuesChanged || this.autoLabelFormatChanged)) {
            Format atf = this.tickCalculator.calcLabelTextFormat(this.getCanonicalValues(values));
            String alf = this.tickCalculator.calcLabelFormatString(this.getCanonicalValues(values));
            this.changeLabelFormat(atf, alf);
        }
        this.autoLabelFormatChanged = false;
        if (this._valuesChanged || this.labelFormatChanged) {
            this.autoLabels = this.calcAutoLabels(this.getCanonicalValues(values), this.labelTextFormat, this.labelFormat);
        }
        this.labelFormatChanged = false;
        if (this.autoValues || this.fixedLabels == null) {
            fixedLabelsInRange = this.fixedLabels;
        } else {
            ArrayList<MathElement> ul = new ArrayList<MathElement>();
            for (int i : valueIdxes) {
                if (i >= this.fixedLabels.length) continue;
                ul.add(this.fixedLabels[i]);
            }
            fixedLabelsInRange = ul.toArray(new MathElement[ul.size()]);
        }
        Object[] labels = AxisTickManagerImpl.calcLabels(fixedLabelsInRange, this.autoLabels, this.labelInterval);
        boolean labelsChanged = false;
        if (!Arrays.equals(this.labels, labels)) {
            this.labels = labels;
            labelsChanged = true;
        }
        if (this._valuesChanged || labelsChanged || this._labelMaxDensityChanged || this._axisCircularRangeChanged || this._trfChanged) {
            this.shrinkLabelFonts();
        }
        this._axisCircularRangeChanged = false;
        this._trfChanged = false;
        this._labelMaxDensityChanged = false;
        boolean tickChanged = false;
        if (labelsChanged || this._labelMaxDensityChanged) {
            tickChanged = true;
            this._labelMaxDensityChanged = false;
        }
        if (this._valuesChanged || this._minorValuesChanged) {
            tickChanged = true;
            this._trfChanged = false;
            this._minorValuesChanged = false;
            this._valuesChanged = false;
        }
        if (tickChanged) {
            for (AxisEx axis : this.axes) {
                axis.invalidateThickness();
                ComponentImpl.redraw(axis);
            }
        }
    }

    private void calcAutoTicks() {
        MathElement[] autoLabels;
        Object[] labels;
        Object values;
        double density;
        if (!(this.autoValuesChanged || this.autoIntervalChanged || this.autoAdjustNumberChanged || this.propNumberChanged || this.minorNumberChanged || this.autoLabelFormatChanged || this.labelFormatChanged || this._labelMaxDensityChanged || this._tickAlgorithmChanged || this._trfChanged || this._rangeChanged)) {
            return;
        }
        this.autoAdjustNumberChanged = false;
        this.autoIntervalChanged = false;
        this.autoValuesChanged = false;
        this.minorNumberChanged = false;
        this.propNumberChanged = false;
        this.labelFormatChanged = false;
        this.autoLabelFormatChanged = false;
        this._labelMaxDensityChanged = false;
        this._trfChanged = false;
        this._tickAlgorithmChanged = false;
        this._rangeChanged = false;
        int tickNumber = this.tickNumber;
        Format labelTextFormat = this.labelTextFormat;
        String labelFormat = this.labelFormat;
        do {
            this.tickCalculator.calcValuesByTickNumber(tickNumber, this.autoMinorNumber ? -1 : this.minorNumber);
            values = this.tickCalculator.getValues();
            if (!this.autoLabelFormat) continue;
            labelTextFormat = this.tickCalculator.calcLabelTextFormat(this.getCanonicalValues(values));
            labelFormat = this.tickCalculator.calcLabelFormatString(this.getCanonicalValues(values));
        } while (!((density = this.getMaxLabelsDensity(this.axisNormalTransform, values, (MathElement[])(labels = AxisTickManagerImpl.calcLabels(this.fixedLabels, autoLabels = this.calcAutoLabels(this.getCanonicalValues(values), labelTextFormat, labelFormat), this.labelInterval)))) <= 1.0) && (tickNumber = Math.min(tickNumber, Array.getLength(values)) - 1) >= 4);
        if (!NumberArrayUtils.equals(this.values, values)) {
            this.values = values;
            this._valuesChanged = true;
        }
        if (!NumberArrayUtils.equals(this.minorValues, this.tickCalculator.getMinorValues())) {
            this.minorValues = this.tickCalculator.getMinorValues();
            this.actualMinorNumber = this.tickCalculator.getMinorNumber();
            this._minorValuesChanged = true;
        }
        boolean labelsChanged = false;
        if (!Arrays.equals(this.labels, labels)) {
            this.labels = labels;
            labelsChanged = true;
        }
        this.interval = this.tickCalculator.getInterval();
        this.changeLabelFormat(labelTextFormat, labelFormat);
        this.autoLabels = autoLabels;
        if (tickNumber < 4) {
            this.shrinkLabelFonts();
        } else {
            for (AxisEx axis : this.axes) {
                axis.setActualFont(axis.getEffectiveFont());
            }
        }
        boolean tickChanged = false;
        if (labelsChanged || this._labelMaxDensityChanged) {
            tickChanged = true;
            this._labelMaxDensityChanged = false;
        }
        if (this._valuesChanged || this._minorValuesChanged) {
            tickChanged = true;
            this._trfChanged = false;
            this._minorValuesChanged = false;
            this._valuesChanged = false;
        }
        if (tickChanged) {
            for (AxisEx axis : this.axes) {
                axis.invalidateThickness();
                ComponentImpl.redraw(axis);
            }
        }
    }

    private boolean isLabelSameOrientation(AxisEx axis) {
        return axis.getOrientation() == axis.getLabelOrientation();
    }

    private static MathElement[] calcLabels(MathElement[] fixedLabels, MathElement[] autoLabels, int labelInterval) {
        int fixedLabelsLength = fixedLabels == null ? 0 : fixedLabels.length;
        int autoLabelsLength = autoLabels == null ? 0 : autoLabels.length;
        int length = (int)Math.floor((double)(autoLabelsLength - 1) / (double)labelInterval) + 1;
        MathElement[] result = new MathElement[length];
        int j = 0;
        for (int i = 0; i < autoLabelsLength; i += labelInterval) {
            result[j] = i < fixedLabelsLength && fixedLabels[i] != null ? fixedLabels[i] : autoLabels[i];
            ++j;
        }
        return result;
    }

    private MathElement[] calcAutoLabels(Object values, Format textFormat, String format) {
        if (textFormat == null) {
            return this.tickCalculator.formatValues(format, values);
        }
        return this.tickCalculator.formatValues(textFormat, values);
    }

    private void changeLabelFormat(Format textFormat, String format) {
        if (!(this.labelTextFormat == textFormat || this.labelTextFormat != null && this.labelTextFormat.equals(textFormat))) {
            this.labelTextFormat = textFormat;
            this.labelFormatChanged = true;
        }
        if (!(this.labelFormat == format || this.labelFormat != null && this.labelFormat.equals(format))) {
            this.labelFormat = format;
            this.labelFormatChanged = true;
        }
    }

    private void shrinkLabelFonts() {
        for (AxisEx axis : this.axes) {
            AxisStatus axisStatus = this.axisStatusMap.get(axis);
            Font sf = this.shrinkLabelFont(axisStatus);
            axis.setActualFont(sf);
        }
    }

    private Font shrinkLabelFont(AxisStatus axisStatus) {
        Font font = axisStatus.getLabelFont();
        double density = this.getLabelsDensity(this.axisNormalTransform, axisStatus.getAxisLength(), this.values, this.labels, font, axisStatus.isLabelSameOrientation());
        if (Double.isInfinite(density)) {
            return font;
        }
        double oldDensity = density;
        int count = 0;
        while (density > 1.0) {
            font = font.deriveFont((float)((double)font.getSize2D() / (density > 1.1 ? density : 1.1)));
            density = this.getLabelsDensity(this.axisNormalTransform, axisStatus.getAxisLength(), this.values, this.labels, font, axisStatus.isLabelSameOrientation());
            if (oldDensity / density >= 1.1) {
                oldDensity = density;
                count = 0;
                continue;
            }
            if (count++ <= 10) continue;
            break;
        }
        return font;
    }

    private double getMaxLabelsDensity(NormalTransform nxf, Object tickValues, MathElement[] labels) {
        double maxDensity = 0.0;
        for (AxisEx axis : this.axes) {
            double density = this.getLabelsDensity(nxf, axis.getLength(), tickValues, labels, axis.getEffectiveFont(), this.isLabelSameOrientation(axis));
            if (!(maxDensity < density)) continue;
            maxDensity = density;
        }
        return maxDensity;
    }

    private double getLabelsDensity(NormalTransform nxf, double axisLength, Object tickValues, MathElement[] labels, Font labelFont, boolean labelSameOrientation) {
        if (Array.getLength(tickValues) == 0) {
            return 0.0;
        }
        Dimension2D[] labelsSize = AxisImpl.getLabelsPaperSize(labels, labelFont);
        double blankWidth = labelsSize[0].getHeight() / 2.0;
        double maxDensity = 0.0;
        double ticA = this.transTickToPaper(nxf, axisLength, Array.getDouble(tickValues, 0));
        if (labelSameOrientation) {
            for (int i = 1; i < labelsSize.length; ++i) {
                double ticB = this.transTickToPaper(nxf, axisLength, Array.getDouble(tickValues, i * this.labelInterval));
                double deltaD = Math.abs(ticB - ticA);
                double desity = (labelsSize[i - 1].getWidth() / 2.0 + labelsSize[i].getWidth() / 2.0 + blankWidth) / deltaD;
                if (maxDensity < desity) {
                    maxDensity = desity;
                }
                ticA = ticB;
            }
        } else {
            for (int i = 1; i < labelsSize.length; ++i) {
                double ticB = this.transTickToPaper(nxf, axisLength, Array.getDouble(tickValues, i * this.labelInterval));
                double deltaD = Math.abs(ticB - ticA);
                double desity = (labelsSize[i - 1].getHeight() / 2.0 + labelsSize[i].getHeight() / 2.0 + blankWidth) / deltaD;
                if (maxDensity < desity) {
                    maxDensity = desity;
                }
                ticA = ticB;
            }
        }
        return maxDensity;
    }

    private double transTickToPaper(NormalTransform nxf, double axisLength, double tickValue) {
        double uv = this.tickTransform != null ? this.tickTransform.transformTick2User(tickValue) : tickValue;
        return nxf.convToNR(uv) * axisLength;
    }

    private Object getCanonicalValues(Object values) {
        if (values instanceof double[]) {
            double[] result = new double[Array.getLength(values)];
            double[] array = (double[])values;
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.getCanonicalValue(array[i]);
            }
            return result;
        }
        if (values instanceof long[]) {
            long[] result = new long[Array.getLength(values)];
            long[] array = (long[])values;
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.getCanonicalValue(array[i]);
            }
            return result;
        }
        return null;
    }

    private double getCanonicalValue(double d) {
        if (this.circularRange == null) {
            return d;
        }
        double uv = this.tickTransform == null ? d : this.tickTransform.transformTick2User(d);
        double canon = uv % this.circularRange.getSpan() + this.circularRange.getMin();
        if (this.tickTransform == null) {
            return canon;
        }
        return this.tickTransform.transformUser2Tick(canon);
    }

    private long getCanonicalValue(long d) {
        if (this.circularRange == null) {
            return d;
        }
        double uv = this.tickTransform == null ? (double)d : this.tickTransform.transformTick2User(d);
        double canon = uv % this.circularRange.getSpan() + this.circularRange.getMin();
        if (this.tickTransform == null) {
            return (long)canon;
        }
        return (long)this.tickTransform.transformUser2Tick(canon);
    }

    @Override
    public Range expandRangeToTick(TransformType txfType, Range range) {
        RangeAdvisor rav = (RangeAdvisor)((Object)this.tickCalculator);
        rav.setRange(range);
        if (this.autoValues) {
            if (this.autoInterval) {
                if (this.autoAdjustNumber) {
                    this.expandRangeToAutoAdjustedTick(txfType, range);
                } else {
                    rav.expandRangeByTickNumber(this.tickNumber);
                }
            } else {
                rav.expandRangeByTickInterval(this.interval);
            }
        }
        return rav.getRange();
    }

    private Range expandRangeToAutoAdjustedTick(TransformType txfType, Range range) {
        Range r;
        Object values;
        double maxDensity;
        RangeAdvisor rav = (RangeAdvisor)((Object)this.tickCalculator);
        int tickNumber = this.tickNumber;
        do {
            String labelFormat;
            Format labelTextFormat;
            rav.setRange(range);
            rav.expandRangeByTickNumber(tickNumber);
            r = rav.getRange();
            this.tickCalculator.calcValuesByTickInterval(rav.getInterval(), 0.0, 0);
            values = this.tickCalculator.getValues();
            if (this.autoLabelFormat) {
                labelTextFormat = this.tickCalculator.calcLabelTextFormat(this.getCanonicalValues(values));
                labelFormat = this.tickCalculator.calcLabelFormatString(this.getCanonicalValues(values));
            } else {
                labelTextFormat = this.labelTextFormat;
                labelFormat = this.labelFormat;
            }
            MathElement[] autoLabels = this.calcAutoLabels(this.getCanonicalValues(values), labelTextFormat, labelFormat);
            MathElement[] labels = AxisTickManagerImpl.calcLabels(null, autoLabels, this.labelInterval);
            NormalTransform trf = txfType.createNormalTransform(r);
            maxDensity = this.getMaxLabelsDensity(trf, values, labels);
        } while (maxDensity > 1.0 && (tickNumber = Math.min(tickNumber, Array.getLength(values)) - 1) >= 4);
        return r;
    }

    @Override
    public AxisTickManagerImpl copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        AxisTransformEx axisTransformCopy;
        AxisTickManagerImpl result = null;
        try {
            result = (AxisTickManagerImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        result.axes = new ArrayList<AxisEx>();
        result.axisStatusMap = new HashMap<AxisEx, AxisStatus>();
        if (orig2copyMap != null) {
            orig2copyMap.put(this, result);
        }
        if ((axisTransformCopy = (AxisTransformEx)orig2copyMap.get(this.axisTransform)) == null) {
            axisTransformCopy = (AxisTransformEx)this.axisTransform.copyStructure(orig2copyMap);
        }
        result.axisTransform = axisTransformCopy;
        axisTransformCopy.addTickManager(result);
        return result;
    }

    private static class AxisStatus {
        private double axisLength;
        private boolean labelSameOrientation;
        private Font labelFont;

        public AxisStatus(double length, boolean labelSameOrientation, Font font) {
            this.axisLength = length;
            this.labelSameOrientation = labelSameOrientation;
            this.labelFont = font;
        }

        public double getAxisLength() {
            return this.axisLength;
        }

        public boolean isLabelSameOrientation() {
            return this.labelSameOrientation;
        }

        public Font getLabelFont() {
            return this.labelFont;
        }
    }
}

