/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.util.Locale;
import org.jplot2d.axtick.AbstractLinearTickCalculator;
import org.jplot2d.axtick.ArcDmsFormat;
import org.jplot2d.axtick.ArcDmsInterval;

public class ArcDmsTickCalculator
extends AbstractLinearTickCalculator {
    protected ArcDmsInterval[] calcCandidateInterval(double rough) {
        ArcDmsInterval itvB;
        ArcDmsInterval itvA;
        if (rough < ArcDmsInterval.Unit.SECOND.angle) {
            int expn;
            double scale;
            double coeff;
            if ((coeff = (rough *= 3600.0) / (scale = Math.pow(10.0, expn = (int)Math.floor(Math.log10(rough))))) < 2.0) {
                itvA = new ArcDmsInterval(1, expn);
                itvB = new ArcDmsInterval(2, expn);
            } else if (coeff < 5.0) {
                itvA = new ArcDmsInterval(2, expn);
                itvB = new ArcDmsInterval(5, expn);
            } else {
                itvA = new ArcDmsInterval(5, expn);
                itvB = new ArcDmsInterval(1, expn + 1);
            }
        } else if (rough < ArcDmsInterval.Unit.SECOND.angle * 2.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 1);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 2);
        } else if (rough < ArcDmsInterval.Unit.SECOND.angle * 5.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 2);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 5);
        } else if (rough < ArcDmsInterval.Unit.SECOND.angle * 10.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 5);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 10);
        } else if (rough < ArcDmsInterval.Unit.SECOND.angle * 15.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 10);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 15);
        } else if (rough < ArcDmsInterval.Unit.SECOND.angle * 30.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 15);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 30);
        } else if (rough < ArcDmsInterval.Unit.MINUTE.angle) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.SECOND, 30);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 1);
        } else if (rough < ArcDmsInterval.Unit.MINUTE.angle * 2.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 1);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 2);
        } else if (rough < ArcDmsInterval.Unit.MINUTE.angle * 5.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 2);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 5);
        } else if (rough < ArcDmsInterval.Unit.MINUTE.angle * 10.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 5);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 10);
        } else if (rough < ArcDmsInterval.Unit.MINUTE.angle * 15.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 10);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 15);
        } else if (rough < ArcDmsInterval.Unit.MINUTE.angle * 30.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 15);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 30);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.MINUTE, 30);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 1);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 2.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 1);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 2);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 5.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 2);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 5);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 10.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 5);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 10);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 15.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 10);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 15);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 30.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 15);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 30);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 45.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 30);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 45);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 60.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 45);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 60);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 90.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 60);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 90);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 180.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 90);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 180);
        } else if (rough < ArcDmsInterval.Unit.DEGREE.angle * 360.0) {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 180);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 360);
        } else {
            itvA = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 360);
            itvB = new ArcDmsInterval(ArcDmsInterval.Unit.DEGREE, 360);
        }
        return new ArcDmsInterval[]{itvA, itvB};
    }

    @Override
    public void calcValuesByTickNumber(int tickNumber, int minorTickNumber) {
        ArcDmsInterval intv = (ArcDmsInterval)this.calcInterval(tickNumber);
        this.minorNumber = minorTickNumber == -1 ? (intv.getCoefficient() == 1 && (intv.getUnit() == ArcDmsInterval.Unit.MINUTE || intv.getUnit() == ArcDmsInterval.Unit.DEGREE) ? 0 : this.calcMinorNumber(intv.getCoefficient(), 3)) : minorTickNumber;
        this.calcValues(this.interval, 0.0, this.minorNumber);
    }

    @Override
    protected int calcMinorNumber(double interval) {
        double degrees;
        double minutes;
        double secs;
        double s1dcoef;
        int mag;
        double coefficient;
        double s1dcoef2;
        int s1dInterval = interval < ArcDmsInterval.Unit.SECOND.angle ? (Math.abs((s1dcoef2 = (double)Math.round(coefficient = interval / Math.pow(10.0, mag = (int)Math.floor(Math.log10(interval))))) / coefficient - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef2) : (interval < ArcDmsInterval.Unit.MINUTE.angle ? (Math.abs((s1dcoef = (double)Math.round(secs = interval / ArcDmsInterval.Unit.SECOND.angle)) / secs - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef) : (interval < ArcDmsInterval.Unit.DEGREE.angle ? (Math.abs((s1dcoef = (double)Math.round(minutes = interval / ArcDmsInterval.Unit.MINUTE.angle)) / minutes - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef) : (Math.abs((s1dcoef = (double)Math.round(degrees = interval / ArcDmsInterval.Unit.DEGREE.angle)) / degrees - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef)));
        if (s1dInterval == 0) {
            return 0;
        }
        return this.calcMinorNumber(s1dInterval, 3);
    }

    @Override
    public ArcDmsFormat calcLabelTextFormat(Object values) {
        if (values instanceof long[]) {
            return new ArcDmsFormat(0);
        }
        if (values instanceof double[]) {
            return new ArcDmsFormat(this.calcSigFraDigits((double[])values));
        }
        return null;
    }

    private int calcSigFraDigits(double[] values) {
        int maxFractionDigits = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0) continue;
            double v = Math.abs(values[i]) * 3600.0;
            int mag = (int)Math.floor(Math.log10(v));
            double scale = Math.pow(10.0, mag);
            double coefficient = v / scale;
            String s = String.format((Locale)null, "%.14f", coefficient);
            int pp1 = ArcDmsTickCalculator.lastNon0Idx(s);
            if (maxFractionDigits >= pp1 - mag - 1) continue;
            maxFractionDigits = pp1 - mag - 1;
        }
        return maxFractionDigits;
    }

    private static int lastNon0Idx(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '0') continue;
            return i;
        }
        return -1;
    }

    @Override
    public String calcLabelFormatString(Object values) {
        return "";
    }

    @Override
    public String getLabelFormate() {
        return "";
    }
}

