/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Formatter;

public class ArcDmsFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private int fraDigits;

    public ArcDmsFormat(int fraDigits) {
        this.fraDigits = fraDigits;
    }

    @Override
    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number instanceof Number) {
            return this.format(((Number)number).doubleValue(), toAppendTo, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    private StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        boolean negative = false;
        if (number < 0.0) {
            number = -number;
            negative = true;
        }
        int degree = (int)number;
        number -= (double)degree;
        int minute = (int)(number *= 60.0);
        number -= (double)minute;
        int second = (int)(number *= 60.0);
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format("%." + this.fraDigits + "f\u2033", number -= (double)second);
        if (sb.charAt(0) == '1' && ++second == 60) {
            second = 0;
            if (++minute == 60) {
                minute = 0;
                ++degree;
            }
        }
        if (negative) {
            result.append('-');
        }
        Formatter foramtter = new Formatter(result);
        foramtter.format("%02d\u00b0%02d\u2032%02d", degree, minute, second);
        if (this.fraDigits > 0) {
            result.append(sb, 1, sb.length());
        } else {
            result.append('\u2033');
        }
        return result;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArcDmsFormat) {
            return this.fraDigits == ((ArcDmsFormat)obj).fraDigits;
        }
        return false;
    }
}

