/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.web.example;

import java.util.Calendar;
import org.jfin.common.Iso4217Currency;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Frequency;
import org.jfin.date.Period;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.holiday.HolidayCalendar;

public class FloatPeriod
extends Period {
    private double notional;
    private Iso4217Currency currency;
    private String index;
    private BusinessDayConvention businessDayConvention;
    private DaycountCalculator daycountCalculator;
    private HolidayCalendar paymentHolidayCalendar;
    private HolidayCalendar fixingHolidayCalendar;
    private Frequency frequency;
    private int fixingOffset;

    @Override
    public FloatPeriod clone() {
        FloatPeriod period = new FloatPeriod();
        period.setStartCalendar(this.getStartCalendar());
        period.setEndCalendar(this.getEndCalendar());
        period.setReferenceStartCalendar(this.getReferenceStartCalendar());
        period.setReferenceEndCalendar(this.getReferenceEndCalendar());
        period.notional = this.notional;
        period.currency = this.currency;
        period.index = this.index;
        period.businessDayConvention = this.businessDayConvention;
        period.daycountCalculator = this.daycountCalculator;
        period.paymentHolidayCalendar = this.paymentHolidayCalendar;
        period.fixingHolidayCalendar = this.fixingHolidayCalendar;
        period.frequency = this.frequency;
        period.fixingOffset = this.fixingOffset;
        return period;
    }

    public BusinessDayConvention getBusinessDayConvention() {
        return this.businessDayConvention;
    }

    public void setBusinessDayConvention(BusinessDayConvention businessDayConvention) {
        this.businessDayConvention = businessDayConvention;
    }

    public Iso4217Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Iso4217Currency currency) {
        this.currency = currency;
    }

    public DaycountCalculator getDaycountCalculator() {
        return this.daycountCalculator;
    }

    public void setDaycountCalculator(DaycountCalculator daycountCalculator) {
        this.daycountCalculator = daycountCalculator;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public HolidayCalendar getPaymentHolidayCalendar() {
        return this.paymentHolidayCalendar;
    }

    public void setPaymentHolidayCalendar(HolidayCalendar holidayCalendar) {
        this.paymentHolidayCalendar = holidayCalendar;
    }

    public double getNotional() {
        return this.notional;
    }

    public void setNotional(double notional) {
        this.notional = notional;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public int getFixingOffset() {
        return this.fixingOffset;
    }

    public void setFixingOffset(int fixingOffset) {
        this.fixingOffset = fixingOffset;
    }

    public HolidayCalendar getFixingHolidayCalendar() {
        return this.fixingHolidayCalendar;
    }

    public void setFixingHolidayCalendar(HolidayCalendar fixingHolidayCalendar) {
        this.fixingHolidayCalendar = fixingHolidayCalendar;
    }

    public Calendar getAdjustedStartCalendar() {
        return this.fixingHolidayCalendar.adjust(this.getStartCalendar(), this.getBusinessDayConvention());
    }

    public Calendar getAdjustedEndCalendar() {
        return this.fixingHolidayCalendar.adjust(this.getEndCalendar(), this.getBusinessDayConvention());
    }

    public double getDaycountFraction() {
        return this.daycountCalculator.calculateDaycountFraction(this.getAdjustedStartCalendar(), this.getAdjustedEndCalendar());
    }

    public String getPaymentDescription() {
        return this.getIndex() + ":" + this.getCurrency().name() + ":" + this.getFrequency().getTenorDescriptor();
    }

    public Calendar getFixingDate() {
        return this.fixingHolidayCalendar.advanceBusinessDays(this.getAdjustedStartCalendar(), this.getFixingOffset());
    }

    public Calendar getPaymentDate() {
        return this.getAdjustedStartCalendar();
    }
}

