/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class ISDADateFormat {
    public static String format(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.get(1) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(5);
    }

    public static String formatFixedLength(Calendar calendar) {
        return ISDADateFormat.formatFixedLength(calendar, "/");
    }

    public static String formatCompact(Calendar calendar) {
        return ISDADateFormat.formatFixedLength(calendar, "");
    }

    public static String formatFixedLength(Calendar calendar, String delimeter) {
        if (calendar == null) {
            return null;
        }
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return calendar.get(1) + delimeter + (month < 10 ? "0" : "") + month + delimeter + (day < 10 ? "0" : "") + day;
    }

    public static Calendar parse(String in) throws ParseException {
        GregorianCalendar ret = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        Date d1 = df.parse(in);
        ret = new GregorianCalendar();
        ret.set(1, d1.getYear() + 1900);
        ret.set(2, d1.getMonth());
        ret.set(5, d1.getDate());
        return ret;
    }
}

