/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.daycount.defaultimpl;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountCalculatorFactory;

public class ISDAMarketConventionsDocTest
extends TestCase {
    private double notional = 10000.0;
    private double fixedRate = 0.1;
    private NumberFormat nf = null;
    private DaycountCalculator isdaActAct = DaycountCalculatorFactory.newInstance().getISDAActualActual();
    private DaycountCalculator afbActAct = DaycountCalculatorFactory.newInstance().getAFBActualActual();
    private DaycountCalculator ismaActAct = DaycountCalculatorFactory.newInstance().getISMAActualActual();

    protected void setUp() throws Exception {
        super.setUp();
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
    }

    public void testPage3() {
        GregorianCalendar date1 = new GregorianCalendar(2003, 10, 1);
        GregorianCalendar date2 = new GregorianCalendar(2004, 4, 1);
        ISDAMarketConventionsDocTest.assertEquals((String)"497.72", (String)this.getAmount(this.isdaActAct, date1, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"500.00", (String)this.getAmount(this.ismaActAct, date1, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"497.27", (String)this.getAmount(this.afbActAct, date1, date2));
    }

    public void testPage4_5() {
        GregorianCalendar notionalStartDate = new GregorianCalendar(1998, 6, 1);
        GregorianCalendar date1 = new GregorianCalendar(1999, 1, 1);
        GregorianCalendar date2 = new GregorianCalendar(1999, 6, 1);
        GregorianCalendar date3 = new GregorianCalendar(2000, 6, 1);
        ISDAMarketConventionsDocTest.assertEquals((String)"410.96", (String)this.getAmount(this.isdaActAct, date1, date2, notionalStartDate, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"410.96", (String)this.getAmount(this.ismaActAct, date1, date2, notionalStartDate, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"410.96", (String)this.getAmount(this.afbActAct, date1, date2, notionalStartDate, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"1,001.38", (String)this.getAmount(this.isdaActAct, date2, date3));
        ISDAMarketConventionsDocTest.assertEquals((String)"1,000.00", (String)this.getAmount(this.ismaActAct, date2, date3));
        ISDAMarketConventionsDocTest.assertEquals((String)"1,000.00", (String)this.getAmount(this.afbActAct, date2, date3));
    }

    public void testPage6() {
        GregorianCalendar notionalStartDate = new GregorianCalendar(2002, 6, 15);
        GregorianCalendar notionalEndDate = new GregorianCalendar(2003, 0, 15);
        GregorianCalendar date1 = new GregorianCalendar(2002, 7, 15);
        GregorianCalendar date2 = new GregorianCalendar(2003, 6, 15);
        GregorianCalendar date3 = new GregorianCalendar(2004, 0, 15);
        ISDAMarketConventionsDocTest.assertEquals((String)"915.07", (String)this.getAmount(this.isdaActAct, date1, date2, notionalStartDate, notionalEndDate));
        ISDAMarketConventionsDocTest.assertEquals((String)"915.76", (String)this.getAmount(this.ismaActAct, date1, date2, notionalStartDate, notionalEndDate));
        ISDAMarketConventionsDocTest.assertEquals((String)"915.07", (String)this.getAmount(this.afbActAct, date1, date2, notionalStartDate, notionalEndDate));
        ISDAMarketConventionsDocTest.assertEquals((String)"504.00", (String)this.getAmount(this.isdaActAct, date2, date3));
        ISDAMarketConventionsDocTest.assertEquals((String)"500.00", (String)this.getAmount(this.ismaActAct, date2, date3));
        ISDAMarketConventionsDocTest.assertEquals((String)"504.11", (String)this.getAmount(this.afbActAct, date2, date3));
    }

    public void testPage7() {
        GregorianCalendar date1 = new GregorianCalendar(1999, 6, 30);
        GregorianCalendar date2 = new GregorianCalendar(2000, 0, 30);
        GregorianCalendar date3 = new GregorianCalendar(2000, 5, 30);
        GregorianCalendar notionalEndDate = new GregorianCalendar(2000, 6, 30);
        ISDAMarketConventionsDocTest.assertEquals((String)"503.89", (String)this.getAmount(this.isdaActAct, date1, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"500.00", (String)this.getAmount(this.ismaActAct, date1, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"504.11", (String)this.getAmount(this.afbActAct, date1, date2));
        ISDAMarketConventionsDocTest.assertEquals((String)"415.30", (String)this.getAmount(this.isdaActAct, date2, date3, date2, notionalEndDate));
        ISDAMarketConventionsDocTest.assertEquals((String)"417.58", (String)this.getAmount(this.ismaActAct, date2, date3, date2, notionalEndDate));
        ISDAMarketConventionsDocTest.assertEquals((String)"415.30", (String)this.getAmount(this.afbActAct, date2, date3, date2, notionalEndDate));
    }

    public void testPage8_9() {
        GregorianCalendar date1 = new GregorianCalendar(1999, 10, 30);
        GregorianCalendar date2 = new GregorianCalendar(2000, 3, 30);
        GregorianCalendar notionalStartDate = new GregorianCalendar(2000, 1, 29);
        GregorianCalendar notionalEndDate = new GregorianCalendar(2000, 4, 31);
        ISDAMarketConventionsDocTest.assertEquals((String)"415.54", (String)this.getAmount(this.isdaActAct, date1, date2, notionalStartDate, notionalEndDate));
        ISDAMarketConventionsDocTest.assertEquals((String)"415.76", (String)this.getAmount(this.ismaActAct, date1, date2, notionalStartDate, notionalEndDate));
        ISDAMarketConventionsDocTest.assertEquals((String)"415.30", (String)this.getAmount(this.afbActAct, date1, date2, notionalStartDate, notionalEndDate));
    }

    public String getAmount(DaycountCalculator calculator, Calendar date1, Calendar date2) {
        return this.getAmount(calculator, date1, date2, null, null);
    }

    public String getAmount(DaycountCalculator calculator, Calendar date1, Calendar date2, Calendar period1, Calendar period2) {
        double daycount = calculator.calculateDaycountFraction(date1, date2, period1, period2);
        double amount = this.notional * this.fixedRate * daycount;
        return this.nf.format(amount);
    }
}

