/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.daycount;

import junit.framework.TestCase;
import org.jfin.date.daycount.DaycountCalculatorFactory;
import org.jfin.date.daycount.DaycountException;
import org.jfin.date.daycount.defaultimpl.AFBActualActual;
import org.jfin.date.daycount.defaultimpl.Actual360;
import org.jfin.date.daycount.defaultimpl.Actual365Fixed;
import org.jfin.date.daycount.defaultimpl.Actual366;
import org.jfin.date.daycount.defaultimpl.DaycountCalculatorFactoryImpl;
import org.jfin.date.daycount.defaultimpl.EU30360;
import org.jfin.date.daycount.defaultimpl.ISDAActualActual;
import org.jfin.date.daycount.defaultimpl.ISMAActualActual;
import org.jfin.date.daycount.defaultimpl.IT30360;
import org.jfin.date.daycount.defaultimpl.US30360;

public class DaycountCalculatorFactoryTest
extends TestCase {
    public void testGetDefaultDaycountCalculator() throws DaycountException {
        DaycountCalculatorFactoryTest.assertTrue((DaycountCalculatorFactory.newInstance().getActual360() != null ? 1 : 0) != 0);
        DaycountCalculatorFactoryTest.assertTrue((DaycountCalculatorFactory.newInstance().getISDAActualActual() != null ? 1 : 0) != 0);
    }

    public void testGetSpecificDaycountCalculatorFactory() {
        System.setProperty("jfin.DaycountCalculatorFactory", "org.jfin.date.daycount.defaultimpl.DaycountCalculatorFactoryImpl");
        DaycountCalculatorFactoryTest.assertTrue((boolean)(DaycountCalculatorFactory.newInstance() instanceof DaycountCalculatorFactoryImpl));
        System.clearProperty("jfin.DaycountCalculatorFactory");
    }

    public void testDaycountCalculatorFactoryNotFound() {
        System.setProperty("jfin.DaycountCalculatorFactory", "does.not.exist");
        try {
            DaycountCalculatorFactory.newInstance();
        }
        catch (DaycountException e) {
            System.clearProperty("jfin.DaycountCalculatorFactory");
            return;
        }
        System.clearProperty("jfin.DaycountCalculatorFactory");
        DaycountCalculatorFactoryTest.fail((String)"Found daycount calculator, even though a non existant one was specified in the jfin.DaycountCalculatorFactory property");
    }

    public void testDaycountCalculatorFactoryWrongClass() {
        System.setProperty("jfin.DaycountCalculatorFactory", "org.jfin.date.test.daycount.BadDaycountCalculatorFactory1");
        try {
            DaycountCalculatorFactory.newInstance();
        }
        catch (DaycountException e) {
            System.clearProperty("jfin.DaycountCalculatorFactory");
            return;
        }
        System.clearProperty("jfin.DaycountCalculatorFactory");
        DaycountCalculatorFactoryTest.fail((String)"Found daycount calculator factory, even though it is not an instance of DaycountCalculatorFactory");
    }

    public void testDaycountCalculatorFactoryNoDefaultConstructor() {
        System.setProperty("jfin.DaycountCalculatorFactory", "org.jfin.date.test.daycount.BadDaycountCalculatorFactory2");
        try {
            DaycountCalculatorFactory.newInstance();
        }
        catch (DaycountException e) {
            System.clearProperty("jfin.DaycountCalculatorFactory");
            return;
        }
        System.clearProperty("jfin.DaycountCalculatorFactory");
        DaycountCalculatorFactoryTest.fail((String)"Found daycount calculator factory, even though it does not have a default constructor");
    }

    public void testDaycountCalculatorFactoryPrivateConstructor() {
        System.setProperty("jfin.DaycountCalculatorFactory", "org.jfin.date.test.daycount.BadDaycountCalculatorFactory3");
        try {
            DaycountCalculatorFactory.newInstance();
        }
        catch (DaycountException e) {
            System.clearProperty("jfin.DaycountCalculatorFactory");
            return;
        }
        System.clearProperty("jfin.DaycountCalculatorFactory");
        DaycountCalculatorFactoryTest.fail((String)"Found daycount calculator factory, even though its default constructor is private");
    }

    public void testGetDaycountByName() {
        DaycountCalculatorFactory defaultFactory = DaycountCalculatorFactory.newInstance();
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("ISDAActualActual") instanceof ISDAActualActual));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("ISMAActualActual") instanceof ISMAActualActual));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("AFBActualActual") instanceof AFBActualActual));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("US30360") instanceof US30360));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("EU30360") instanceof EU30360));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("IT30360") instanceof IT30360));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("Actual360") instanceof Actual360));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("Actual365Fixed") instanceof Actual365Fixed));
        DaycountCalculatorFactoryTest.assertTrue((boolean)(defaultFactory.getDaycountCalculator("Actual366") instanceof Actual366));
    }

    public void testUnknownDaycountCalculator() {
        DaycountCalculatorFactory defaultFactory = DaycountCalculatorFactory.newInstance();
        try {
            defaultFactory.getDaycountCalculator("DOES NOT EXIST");
        }
        catch (DaycountException e) {
            return;
        }
        DaycountCalculatorFactoryTest.fail((String)"Failed to throw daycount exception for unknown daycount calculator.");
    }
}

