/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.accrual;

import java.text.ParseException;
import java.util.Calendar;
import junit.framework.TestCase;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.accrual.AccrualException;
import org.jfin.date.accrual.impl.FixedAccrualPeriod;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.util.ISDADateFormat;

public class AccrualPeriodTest
extends TestCase {
    public void testCantGetAdjustedPaymentCalendar1() {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        try {
            Calendar cal = accrualPeriod.getAdjustedPaymentCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        AccrualPeriodTest.fail((String)"Didn't return an exception trying to modify a null payment calendar with FOLLOWING");
    }

    public void testCantGetAdjustedPaymentCalendar2() {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        try {
            Calendar cal = accrualPeriod.getAdjustedPaymentCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        AccrualPeriodTest.fail((String)"Didn't return an exception trying to modify a null payment calendar with null");
    }

    public void testCantGetAdjustedPaymentCalendar3() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        accrualPeriod.setPaymentCalendar(ISDADateFormat.parse("2007/10/10"));
        try {
            Calendar cal = accrualPeriod.getAdjustedPaymentCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        AccrualPeriodTest.fail((String)"Didn't return an exception trying to modify a 2007/10/10 payment calendar with FOLLOWING and no holiday calendar");
    }

    public void testGetUnadjustedPaymentCalendar() throws ParseException, AccrualException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.UNADJUSTED);
        accrualPeriod.setPaymentCalendar(ISDADateFormat.parse("2007/10/10"));
        AccrualPeriodTest.assertEquals((String)"2007/10/10", (String)ISDADateFormat.format(accrualPeriod.getAdjustedPaymentCalendar()));
    }

    public void testGetAdjustedPaymentCalendar() throws ParseException, AccrualException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        accrualPeriod.setPaymentCalendar(ISDADateFormat.parse("2007/11/10"));
        HolidayCalendar holidayCalendar = HolidayCalendarFactory.newInstance().getHolidayCalendar("WE");
        accrualPeriod.setPaymentHolidayCalendar(holidayCalendar);
        AccrualPeriodTest.assertEquals((String)"2007/11/12", (String)ISDADateFormat.format(accrualPeriod.getAdjustedPaymentCalendar()));
    }
}

