/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.jfin.date.Frequency;
import org.jfin.date.Period;
import org.jfin.date.ScheduleException;
import org.jfin.date.ScheduleGenerator;
import org.jfin.date.StubType;
import org.jfin.date.Tenor;
import org.jfin.date.test.TestPeriod;
import org.jfin.date.util.ISDADateFormat;

public class ScheduleGeneratorTest
extends TestCase {
    public void testLongFirst() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_FIRST;
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testLongLast() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_LAST;
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testShortFirst() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_FIRST;
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testShortLast() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_LAST;
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testExceedMaxPeriodsStubTypeShortLast() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_LAST;
        try {
            ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType, 4);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGeneratorTest.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testExceedMaxPeriodsStubTypeShortFirst() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_FIRST;
        try {
            ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType, 4);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGeneratorTest.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testExceedMaxPeriodsStubTypeLongLast() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_LAST;
        try {
            ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType, 4);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGeneratorTest.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testExceedMaxPeriodsStubTypeLongFirst() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_FIRST;
        try {
            ScheduleGenerator.generateSchedule(effectiveDate, maturityDate, frequency, stubType, 4);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGeneratorTest.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testScheduleWithMaturityString() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.NONE;
        String maturity = "5Y";
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturity, frequency, stubType).size());
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturity, frequency, stubType, 5).size());
    }

    public void testScheduleWithMaturityStringAndPrototype() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.NONE;
        String maturity = "5Y";
        TestPeriod prototype = new TestPeriod();
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturity, frequency, stubType, (Period)prototype).size());
        ScheduleGeneratorTest.assertEquals((int)5, (int)ScheduleGenerator.generateSchedule(effectiveDate, maturity, frequency, stubType, (Period)prototype, 5).size());
        ScheduleGeneratorTest.assertTrue((boolean)(ScheduleGenerator.generateSchedule(effectiveDate, maturity, frequency, stubType, (Period)prototype).get(0) instanceof TestPeriod));
    }

    public void testMonthlySchedule() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/3/31");
        Calendar endDate = ISDADateFormat.parse("2012/3/31");
        List<Period> schedule = ScheduleGenerator.generateSchedule(startDate, endDate, Frequency.MONTHLY, StubType.SHORT_LAST);
        for (Period period : schedule) {
            Calendar periodEndDate = period.getEndCalendar();
            ScheduleGeneratorTest.assertTrue((String)("End date " + ISDADateFormat.format(periodEndDate) + " should be the end of the month."), (periodEndDate.get(5) == periodEndDate.getActualMaximum(5) ? 1 : 0) != 0);
        }
    }

    public void testTenorScheduleGeneration() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/1/1");
        Tenor tenor = new Tenor("2Y");
        List<Period> periods = ScheduleGenerator.generateSchedule(startDate, tenor, Frequency.QUARTERLY, StubType.NONE);
        ScheduleGeneratorTest.assertEquals((int)8, (int)periods.size());
    }

    public void testMaturityAndPrototypeScheduleGeneration() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/1/1");
        Tenor tenor = new Tenor("2Y");
        TestPeriod prototype = new TestPeriod();
        prototype.setPrototypeField(10);
        List<Period> periods = ScheduleGenerator.generateSchedule(startDate, tenor, Frequency.QUARTERLY, StubType.NONE, (Period)prototype);
        ScheduleGeneratorTest.assertEquals((int)8, (int)periods.size());
        for (Period period : periods) {
            ScheduleGeneratorTest.assertTrue((boolean)(period instanceof TestPeriod));
            TestPeriod testPeriod = (TestPeriod)period;
            ScheduleGeneratorTest.assertEquals((int)10, (int)testPeriod.getPrototypeField());
        }
    }

    public void testPrototypeScheduleGeneration() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/1/1");
        Calendar endDate = ISDADateFormat.parse("2007/1/1");
        TestPeriod prototype = new TestPeriod();
        prototype.setPrototypeField(10);
        List<Period> periods = ScheduleGenerator.generateSchedule(startDate, endDate, Frequency.QUARTERLY, StubType.NONE, (Period)prototype);
        ScheduleGeneratorTest.assertEquals((int)4, (int)periods.size());
        for (Period period : periods) {
            ScheduleGeneratorTest.assertTrue((boolean)(period instanceof TestPeriod));
            TestPeriod testPeriod = (TestPeriod)period;
            ScheduleGeneratorTest.assertEquals((int)10, (int)testPeriod.getPrototypeField());
        }
    }

    public void testCustomFrequency() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/1/1");
        Calendar endDate = ISDADateFormat.parse("2007/1/1");
        List<Period> periods = ScheduleGenerator.generateSchedule(startDate, endDate, 2, 2, StubType.NONE);
        ScheduleGeneratorTest.assertEquals((int)6, (int)periods.size());
    }

    public void testCustomFrequencyWithPrototype() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/1/1");
        Calendar endDate = ISDADateFormat.parse("2007/1/1");
        TestPeriod prototype = new TestPeriod();
        prototype.setPrototypeField(10);
        List<Period> periods = ScheduleGenerator.generateSchedule(startDate, endDate, 2, 2, StubType.NONE, prototype);
        ScheduleGeneratorTest.assertEquals((int)6, (int)periods.size());
        for (Period period : periods) {
            ScheduleGeneratorTest.assertTrue((boolean)(period instanceof TestPeriod));
            TestPeriod testPeriod = (TestPeriod)period;
            ScheduleGeneratorTest.assertEquals((int)10, (int)testPeriod.getPrototypeField());
        }
    }

    public void testCalendarUnitDescriptor() {
        ScheduleGeneratorTest.assertEquals((String)"DAY", (String)ScheduleGenerator.getCalendarUnitDescriptor(5));
        ScheduleGeneratorTest.assertEquals((String)"DAY", (String)ScheduleGenerator.getCalendarUnitDescriptor(7));
        ScheduleGeneratorTest.assertEquals((String)"DAY", (String)ScheduleGenerator.getCalendarUnitDescriptor(6));
        ScheduleGeneratorTest.assertEquals((String)"MONTH", (String)ScheduleGenerator.getCalendarUnitDescriptor(2));
        ScheduleGeneratorTest.assertEquals((String)"YEAR", (String)ScheduleGenerator.getCalendarUnitDescriptor(1));
        ScheduleGeneratorTest.assertEquals((String)"UNKNOWN", (String)ScheduleGenerator.getCalendarUnitDescriptor(-1));
    }
}

