/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test;

import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.jfin.date.Frequency;
import org.jfin.date.Period;
import org.jfin.date.ScheduleException;
import org.jfin.date.ScheduleGenerator;
import org.jfin.date.StubType;
import org.jfin.date.TypedScheduleGenerator;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountCalculatorFactory;
import org.jfin.date.util.ISDADateFormat;

public class ScheduleGenerator2SanityCheckTest
extends TestCase {
    private TypedScheduleGenerator<Period> scheduleGenerator2;

    protected void setUp() throws Exception {
        this.scheduleGenerator2 = new TypedScheduleGenerator<Period>(new Period());
    }

    public void testScheduleGenerationNoStub() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 0, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.NONE;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        DaycountCalculator calculator = DaycountCalculatorFactory.newInstance().getISMAActualActual();
        for (Period period : periods) {
            ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(period) == 0.25 ? 1 : 0) != 0);
        }
    }

    public void testScheduleGenerationNoStub2() throws ParseException {
        Calendar start = ISDADateFormat.parse("2006/3/23");
        Calendar end = ISDADateFormat.parse("2011/3/23");
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.NONE;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule(start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        DaycountCalculator calculator = DaycountCalculatorFactory.newInstance().getISMAActualActual();
        for (Period period : periods) {
            ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(period) == 0.25 ? 1 : 0) != 0);
        }
    }

    public void testScheduleGenerationShortFirstStub() throws ScheduleException {
        Iterator<Period> it;
        Period shortFirstPeriod;
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.SHORT_FIRST;
        List<Period> periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        List<Period> periods2 = ScheduleGenerator.generateSchedule((Calendar)start, end, frequency, stubType);
        DaycountCalculator calculator = DaycountCalculatorFactory.newInstance().getISMAActualActual();
        ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(shortFirstPeriod = (it = periods.iterator()).next()) < 0.25 ? 1 : 0) != 0);
        while (it.hasNext()) {
            Period period = it.next();
            ScheduleGenerator2SanityCheckTest.assertEquals((Object)0.25, (Object)calculator.calculateDaycountFraction(period));
        }
    }

    public void testScheduleGenerationShortLastStub() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.SHORT_LAST;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        DaycountCalculator calculator = DaycountCalculatorFactory.newInstance().getISMAActualActual();
        Iterator<Period> it = periods.iterator();
        while (it.hasNext()) {
            Period period = it.next();
            if (it.hasNext()) {
                ScheduleGenerator2SanityCheckTest.assertEquals((Object)0.25, (Object)calculator.calculateDaycountFraction(period));
                continue;
            }
            ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(period) < 0.25 ? 1 : 0) != 0);
        }
    }

    public void testScheduleGenerationInvalidStub() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.NONE;
        try {
            this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGenerator2SanityCheckTest.fail((String)"Incorrectly generated a schedule with stub type 'NONE' when it could not fit exactly within the start and end dates");
    }

    public void testScheduleGenerationLongFirstStub() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.LONG_FIRST;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        DaycountCalculator calculator = DaycountCalculatorFactory.newInstance().getISMAActualActual();
        Iterator<Period> it = periods.iterator();
        Period longFirstPeriod = it.next();
        ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(longFirstPeriod) > 0.25 ? 1 : 0) != 0);
        while (it.hasNext()) {
            Period period = it.next();
            ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(period) == 0.25 ? 1 : 0) != 0);
        }
    }

    public void testScheduleGenerationLongLastStub() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.LONG_LAST;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        DaycountCalculator calculator = DaycountCalculatorFactory.newInstance().getISMAActualActual();
        Iterator<Period> it = periods.iterator();
        while (it.hasNext()) {
            Period period = it.next();
            if (it.hasNext()) {
                ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(period) == 0.25 ? 1 : 0) != 0);
                continue;
            }
            ScheduleGenerator2SanityCheckTest.assertTrue((calculator.calculateDaycountFraction(period) > 0.25 ? 1 : 0) != 0);
        }
    }

    public void testScheduleGenerationShortFirstStubNotional() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.SHORT_FIRST;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        Period firstPeriod = periods.get(0);
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2005/2/1", (String)ISDADateFormat.format(firstPeriod.getReferenceEndCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2004/11/1", (String)ISDADateFormat.format(firstPeriod.getReferenceStartCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2005/2/1", (String)ISDADateFormat.format(firstPeriod.getEndCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2005/1/1", (String)ISDADateFormat.format(firstPeriod.getStartCalendar()));
    }

    public void testScheduleGenerationLongFirstStubNotional() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.LONG_FIRST;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        Period firstPeriod = periods.get(0);
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2005/2/1", (String)ISDADateFormat.format(firstPeriod.getReferenceEndCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2004/11/1", (String)ISDADateFormat.format(firstPeriod.getReferenceStartCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2005/1/1", (String)ISDADateFormat.format(firstPeriod.getStartCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2005/5/1", (String)ISDADateFormat.format(firstPeriod.getEndCalendar()));
    }

    public void testScheduleGenerationShortLastStubNotional() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.SHORT_LAST;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        Period lastPeriod = periods.get(periods.size() - 1);
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2010/4/1", (String)ISDADateFormat.format(lastPeriod.getReferenceEndCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2010/1/1", (String)ISDADateFormat.format(lastPeriod.getReferenceStartCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2010/2/1", (String)ISDADateFormat.format(lastPeriod.getEndCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2010/1/1", (String)ISDADateFormat.format(lastPeriod.getStartCalendar()));
    }

    public void testScheduleGenerationShortLongStubNotional() {
        GregorianCalendar start = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar end = new GregorianCalendar(2010, 1, 1);
        Frequency frequency = Frequency.QUARTERLY;
        StubType stubType = StubType.LONG_LAST;
        List<Period> periods = null;
        try {
            periods = this.scheduleGenerator2.generateSchedule((Calendar)start, end, frequency, stubType);
        }
        catch (ScheduleException e) {
            ScheduleGenerator2SanityCheckTest.fail((String)e.getMessage());
        }
        Period lastPeriod = periods.get(periods.size() - 1);
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2010/4/1", (String)ISDADateFormat.format(lastPeriod.getReferenceEndCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2010/1/1", (String)ISDADateFormat.format(lastPeriod.getReferenceStartCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2010/2/1", (String)ISDADateFormat.format(lastPeriod.getEndCalendar()));
        ScheduleGenerator2SanityCheckTest.assertEquals((String)"2009/10/1", (String)ISDADateFormat.format(lastPeriod.getStartCalendar()));
    }
}

