/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test;

import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.jfin.date.Period;

public class PeriodTest
extends TestCase {
    public void testDefaultConstructor() {
        Period period = new Period();
        PeriodTest.assertNull((Object)period.getStartCalendar());
        PeriodTest.assertNull((Object)period.getEndCalendar());
        PeriodTest.assertNull((Object)period.getReferenceStartCalendar());
        PeriodTest.assertNull((Object)period.getReferenceEndCalendar());
    }

    public void testSetters() {
        GregorianCalendar calendar1 = new GregorianCalendar();
        GregorianCalendar calendar2 = new GregorianCalendar();
        Period period = new Period(calendar1, calendar1);
        PeriodTest.assertEquals((Object)calendar1, (Object)period.getStartCalendar());
        PeriodTest.assertEquals((Object)calendar1, (Object)period.getEndCalendar());
        PeriodTest.assertNull((Object)period.getReferenceStartCalendar());
        PeriodTest.assertNull((Object)period.getReferenceEndCalendar());
        period.setStartCalendar(calendar2);
        PeriodTest.assertEquals((Object)calendar2, (Object)period.getStartCalendar());
        period.setEndCalendar(calendar2);
        PeriodTest.assertEquals((Object)calendar2, (Object)period.getEndCalendar());
        period.setReferenceStartCalendar(calendar1);
        PeriodTest.assertEquals((Object)calendar1, (Object)period.getReferenceStartCalendar());
        period.setReferenceEndCalendar(calendar1);
        PeriodTest.assertEquals((Object)calendar1, (Object)period.getReferenceEndCalendar());
        period.setReferenceStartCalendar(calendar2);
        PeriodTest.assertEquals((Object)calendar2, (Object)period.getReferenceStartCalendar());
        period.setReferenceEndCalendar(calendar2);
        PeriodTest.assertEquals((Object)calendar2, (Object)period.getReferenceEndCalendar());
    }

    public void testToString() {
        GregorianCalendar calendar1 = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar calendar2 = new GregorianCalendar(2006, 11, 30);
        Period period = new Period(calendar1, calendar2);
        PeriodTest.assertEquals((String)period.toString(), (String)"2005/1/1 - 2006/12/30");
    }

    public void testComparator() {
        GregorianCalendar calendar1 = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar calendar2 = new GregorianCalendar(2006, 11, 30);
        Period period1 = new Period(calendar1, calendar1);
        Period period2 = new Period(calendar2, calendar2);
        PeriodTest.assertTrue((period1.compareTo(period1) == 0 ? 1 : 0) != 0);
        PeriodTest.assertTrue((period1.compareTo(period2) < 0 ? 1 : 0) != 0);
        PeriodTest.assertTrue((period2.compareTo(period1) > 0 ? 1 : 0) != 0);
        PeriodTest.assertTrue((period1.compareTo(calendar1) == 0 ? 1 : 0) != 0);
        PeriodTest.assertTrue((period1.compareTo(calendar2) < 0 ? 1 : 0) != 0);
        PeriodTest.assertTrue((period2.compareTo(calendar1) > 0 ? 1 : 0) != 0);
    }

    public void testComparatorMidpoint() {
        GregorianCalendar calendar1 = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar calendar2 = new GregorianCalendar(2005, 2, 1);
        Period period1 = new Period(calendar1, calendar2);
        GregorianCalendar calendar3 = new GregorianCalendar(2005, 3, 1);
        Period period2 = new Period(calendar1, calendar3);
        PeriodTest.assertTrue((period1.compareTo(period2) < 0 ? 1 : 0) != 0);
        PeriodTest.assertTrue((period2.compareTo(period1) > 0 ? 1 : 0) != 0);
        PeriodTest.assertTrue((period2.compareTo(calendar2) < 0 ? 1 : 0) != 0);
    }

    public void testComparatorFailure() {
        GregorianCalendar calendar1 = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar calendar2 = new GregorianCalendar(2006, 11, 30);
        Period period = new Period(calendar1, calendar2);
        try {
            period.compareTo("NO COMPARISON");
        }
        catch (RuntimeException e) {
            return;
        }
        PeriodTest.fail((String)"Failed to throw an exception when comparing a Period to a String");
    }

    public void testConstructorWithReferencePeriod() {
        GregorianCalendar calendar1 = new GregorianCalendar(2005, 0, 1);
        GregorianCalendar calendar2 = new GregorianCalendar(2005, 2, 30);
        GregorianCalendar calendar3 = new GregorianCalendar(2005, 1, 1);
        GregorianCalendar calendar4 = new GregorianCalendar(2005, 3, 30);
        Period period = new Period(calendar1, calendar2, calendar3, calendar4);
        PeriodTest.assertEquals((String)"2005/1/1 - 2005/3/30[2005/2/1 - 2005/4/30]", (String)period.toString());
    }
}

