/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test;

import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Frequency;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;

public class FrequencyTest
extends TestCase {
    public void testFrequency() {
        Frequency monthly = Frequency.MONTHLY;
        Frequency quarterly = Frequency.QUARTERLY;
        Frequency semiAnnually = Frequency.SEMI_ANNUALLY;
        Frequency annually = Frequency.ANNUALLY;
        GregorianCalendar referenceCalendar = new GregorianCalendar(2005, 0, 1);
        BusinessDayConvention unadjusted = BusinessDayConvention.UNADJUSTED;
        HolidayCalendar we = HolidayCalendarFactory.newInstance().getHolidayCalendar("WE");
        Calendar monthlyCal = we.advance(referenceCalendar, monthly.getPeriodAmount(), monthly.getPeriodUnit(), unadjusted);
        Calendar quarterlyCal = we.advance(referenceCalendar, quarterly.getPeriodAmount(), quarterly.getPeriodUnit(), unadjusted);
        Calendar semiAnnuallyCal = we.advance(referenceCalendar, semiAnnually.getPeriodAmount(), semiAnnually.getPeriodUnit(), unadjusted);
        Calendar annuallyCal = we.advance(referenceCalendar, annually.getPeriodAmount(), annually.getPeriodUnit(), unadjusted);
        FrequencyTest.assertEquals((String)monthly.getTenorDescriptor(), (String)"1M");
        FrequencyTest.assertEquals((Object)monthlyCal, (Object)new GregorianCalendar(2005, 1, 1));
        FrequencyTest.assertEquals((String)quarterly.getTenorDescriptor(), (String)"3M");
        FrequencyTest.assertEquals((Object)quarterlyCal, (Object)new GregorianCalendar(2005, 3, 1));
        FrequencyTest.assertEquals((String)semiAnnually.getTenorDescriptor(), (String)"6M");
        FrequencyTest.assertEquals((Object)semiAnnuallyCal, (Object)new GregorianCalendar(2005, 6, 1));
        FrequencyTest.assertEquals((String)annually.getTenorDescriptor(), (String)"1Y");
        FrequencyTest.assertEquals((Object)annuallyCal, (Object)new GregorianCalendar(2006, 0, 1));
    }
}

