/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday.financialcalendarimpl;

import java.util.TreeMap;
import java.util.logging.Logger;
import org.jfin.common.Iso3166Country;
import org.jfin.common.Iso4217Currency;

public class InfoFileEntry {
    private String code;
    private String center;
    private String country;
    private Iso4217Currency currency;
    private String type;
    private Iso3166Country isoCountry;
    private String define1;
    private String define2;
    private TreeMap<String, String> countryMappings;
    private static Logger logger = Logger.getLogger("org.jfin.date.holiday.financialcalendarimpl.InfoFileEntry");

    public InfoFileEntry() {
        this.initialiseCountryMapping();
    }

    public InfoFileEntry(String lineToParse) {
        this();
        this.parse(lineToParse);
    }

    public InfoFileEntry(String code, String center, String country, Iso4217Currency currency, String type, Iso3166Country isoCountry, String define1, String define2) {
        this.code = code;
        this.center = center;
        this.country = country;
        this.currency = currency;
        this.type = type;
        this.isoCountry = isoCountry;
        this.define1 = define1;
        this.define2 = define2;
    }

    public void parse(String line) {
        String[] parts = line.split(",");
        if (parts.length > 0) {
            this.setCode(parts[0]);
        }
        if (parts.length > 1) {
            this.setCenter(parts[1]);
        }
        if (parts.length > 2) {
            this.setCountry(parts[2]);
        }
        if (parts.length > 3 && parts[3].length() > 0) {
            try {
                this.setCurrency(Iso4217Currency.valueOf(parts[3]));
            }
            catch (Exception e) {
                logger.warning("Couldn't find currency \"" + parts[3] + "\"");
            }
        }
        if (parts.length > 4) {
            this.setType(parts[4]);
        }
        if (parts.length > 5 && parts[5].length() > 0) {
            try {
                this.setIsoCountry(Iso3166Country.valueOf(this.getCountryMapping(parts[5])));
            }
            catch (Exception e) {
                logger.warning("Couldn't find country \"" + parts[5] + "\"");
            }
        }
        if (parts.length > 6) {
            this.setDefine1(parts[6]);
        }
        if (parts.length > 7) {
            this.setDefine2(parts[7]);
        }
    }

    public String getCenter() {
        return this.center;
    }

    public void setCenter(String center) {
        this.center = center;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Iso4217Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Iso4217Currency currency) {
        this.currency = currency;
    }

    public String getDefine1() {
        return this.define1;
    }

    public void setDefine1(String define1) {
        this.define1 = define1;
    }

    public String getDefine2() {
        return this.define2;
    }

    public void setDefine2(String define2) {
        this.define2 = define2;
    }

    public Iso3166Country getIsoCountry() {
        return this.isoCountry;
    }

    public void setIsoCountry(Iso3166Country isoCountry) {
        this.isoCountry = isoCountry;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return (this.code == null ? "" : this.code) + "," + (this.center == null ? "" : this.center) + "," + (this.country == null ? "" : this.country) + "," + (this.currency == null ? "" : this.currency) + "," + (this.type == null ? "" : this.type) + "," + (this.isoCountry == null ? "" : this.isoCountry) + "," + (this.define1 == null ? "" : this.define1) + "," + (this.define2 == null ? "" : this.define2);
    }

    public void initialiseCountryMapping() {
        this.countryMappings = new TreeMap();
        this.countryMappings.put("IM", "GB");
        this.countryMappings.put("JE", "GB");
    }

    public String getCountryMapping(String country) {
        if (country == null) {
            return null;
        }
        if (this.countryMappings.get(country) == null) {
            return country;
        }
        return this.countryMappings.get(country);
    }

    public void getCurrencyMapping() {
    }
}

