/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;
import org.jfin.date.holiday.HolidayCalendar;

public abstract class DaycountCalculatorFactory {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.DaycountCalculatorFactory");
    public static String daycountCalculatorFactoryClassNameParameter = "jfin.DaycountCalculatorFactory";
    public static String defaultDaycountCalculatorFactoryClassName = "org.jfin.date.daycount.defaultimpl.DaycountCalculatorFactoryImpl";

    public static DaycountCalculatorFactory newInstance() {
        String daycountCalculatorFactoryClassName = System.getProperty(daycountCalculatorFactoryClassNameParameter);
        if (daycountCalculatorFactoryClassName == null) {
            logger.info("No system property " + daycountCalculatorFactoryClassNameParameter + " provided, using " + defaultDaycountCalculatorFactoryClassName);
            daycountCalculatorFactoryClassName = defaultDaycountCalculatorFactoryClassName;
        } else {
            logger.info("Found system property " + daycountCalculatorFactoryClassNameParameter + ": " + defaultDaycountCalculatorFactoryClassName);
        }
        return DaycountCalculatorFactory.newInstance(daycountCalculatorFactoryClassName);
    }

    public static DaycountCalculatorFactory newInstance(String daycountCalculatorFactoryClassName) {
        logger.fine("Constructing new instance of day count calculator factory.");
        DaycountCalculatorFactory factory = null;
        try {
            logger.fine("Attempting to instantiate " + daycountCalculatorFactoryClassName);
            Class<?> daycountCalculatorFactoryClass = Class.forName(daycountCalculatorFactoryClassName);
            factory = (DaycountCalculatorFactory)daycountCalculatorFactoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Cannot create a DaycountCalculatorFactory with class " + daycountCalculatorFactoryClassName + ". Check that this class exists within the classpath.", e);
            throw new DaycountException(e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "Cannot create a DaycountCalculatorFactory with class " + daycountCalculatorFactoryClassName + ". Check that this class implements a default constructor.", e);
            throw new DaycountException(e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Cannot create a DaycountCalculatorFactory with class " + daycountCalculatorFactoryClassName + ". Check that this class implements a public default constructor.", e);
            throw new DaycountException(e);
        }
        catch (ClassCastException e) {
            logger.log(Level.SEVERE, "Cannot create a DaycountCalculatorFactory with class " + daycountCalculatorFactoryClassName + ". Check that this class extends DaycountCalculatorFactory.", e);
            throw new DaycountException(e);
        }
        return factory;
    }

    public abstract DaycountCalculator getISDAActualActual();

    public abstract DaycountCalculator getISMAActualActual();

    public abstract DaycountCalculator getAFBActualActual();

    public abstract DaycountCalculator getUS30360();

    public abstract DaycountCalculator getEU30360();

    public abstract DaycountCalculator getIT30360();

    public abstract DaycountCalculator getActual360();

    public abstract DaycountCalculator getActual365Fixed();

    public abstract DaycountCalculator getActual366();

    public abstract DaycountCalculator getBusiness252(HolidayCalendar var1);

    public DaycountCalculator getDaycountCalculator(String name) {
        if (name.equals("ISDAActualActual")) {
            return this.getISDAActualActual();
        }
        if (name.equals("ISMAActualActual")) {
            return this.getISMAActualActual();
        }
        if (name.equals("AFBActualActual")) {
            return this.getAFBActualActual();
        }
        if (name.equals("US30360")) {
            return this.getUS30360();
        }
        if (name.equals("EU30360")) {
            return this.getEU30360();
        }
        if (name.equals("IT30360")) {
            return this.getIT30360();
        }
        if (name.equals("Actual360")) {
            return this.getActual360();
        }
        if (name.equals("Actual365Fixed")) {
            return this.getActual365Fixed();
        }
        if (name.equals("Actual366")) {
            return this.getActual366();
        }
        throw new DaycountException("Unknown day count calculator \"" + name + "\"");
    }

    public abstract String[] getAvailableDaycountCalculators();
}

