/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.common;

import org.jfin.common.Iso3166Country;

public enum Iso4217Currency {
    AFN("Afghani", new Iso3166Country[]{Iso3166Country.AF}),
    ARA("Austral", new Iso3166Country[]{Iso3166Country.AR}),
    THB("Baht", new Iso3166Country[]{Iso3166Country.TH}),
    PAB("Balboa", new Iso3166Country[]{Iso3166Country.PA}),
    ETB("Birr", new Iso3166Country[]{Iso3166Country.ER, Iso3166Country.ET}),
    VEB("Bolivar", new Iso3166Country[]{Iso3166Country.VE}),
    BOB("Boliviano", new Iso3166Country[]{Iso3166Country.BO}),
    GHC("Cedi", new Iso3166Country[]{Iso3166Country.GH}),
    CRC("Col\u00c3\u0082\u00c2\u0097n (Costa Rican)", new Iso3166Country[]{Iso3166Country.CR}),
    SVC("Col\u00c3\u0082\u00c2\u0097n (El Salvadorian)", new Iso3166Country[]{Iso3166Country.SV}),
    BAM("Convertible Mark", new Iso3166Country[]{Iso3166Country.BA}),
    NIO("C\u00c3\u0082\u00c2\u0097rdoba", new Iso3166Country[]{Iso3166Country.NI}),
    BRL("Brazilian Real", new Iso3166Country[]{Iso3166Country.BR}),
    BRR("Cruzeiro Real", new Iso3166Country[]{Iso3166Country.BR}, BRL),
    GMD("Dalasi", new Iso3166Country[]{Iso3166Country.GM}),
    DZD("Dinar (Algerian)", new Iso3166Country[]{Iso3166Country.DZ}),
    BHD("Dinar (Bahraini)", new Iso3166Country[]{Iso3166Country.BH}),
    HRD("Dinar (Croatian)", new Iso3166Country[]{Iso3166Country.HR}),
    IQD("Dinar (Iraqi)", new Iso3166Country[]{Iso3166Country.IQ}),
    JOD("Dinar (Jordanian)", new Iso3166Country[]{Iso3166Country.JO}),
    KWD("Dinar (Kuwaiti)", new Iso3166Country[]{Iso3166Country.KW}),
    LYD("Dinar (Libyan)", new Iso3166Country[]{Iso3166Country.LY}),
    MKD("Dinar (Macedonian)", new Iso3166Country[]{Iso3166Country.MK}),
    CSD("Dinar (Serbian)", new Iso3166Country[]{Iso3166Country.CS}),
    YER("Riyal (Yemeni)", new Iso3166Country[]{Iso3166Country.YE}),
    YDD("Dinar (South Yemeni)", YER),
    SDD("Dinar (Sudanese)", new Iso3166Country[]{Iso3166Country.SD}),
    TND("Dinar (Tunisian)", new Iso3166Country[]{Iso3166Country.TN}),
    MAD("Dirham (Moroccan)", new Iso3166Country[]{Iso3166Country.MA, Iso3166Country.EH}),
    AED("Dirham (UAE)", new Iso3166Country[]{Iso3166Country.AE}),
    STD("Dobra", new Iso3166Country[]{Iso3166Country.ST}),
    AUD("Dollar (Australian)", new Iso3166Country[]{Iso3166Country.AU, Iso3166Country.CX, Iso3166Country.CC, Iso3166Country.HM, Iso3166Country.KI, Iso3166Country.NR, Iso3166Country.NF, Iso3166Country.TV}),
    BSD("Dollar (Bahamian)", new Iso3166Country[]{Iso3166Country.BS}),
    BBD("Dollar (Barbados)", new Iso3166Country[]{Iso3166Country.BB}),
    BZD("Dollar (Belize)", new Iso3166Country[]{Iso3166Country.BZ}),
    BMD("Dollar (Bermudian)", new Iso3166Country[]{Iso3166Country.BM}),
    BND("Dollar (Brunei)", new Iso3166Country[]{Iso3166Country.BN}),
    CAD("Dollar (Canadian)", new Iso3166Country[]{Iso3166Country.CA}),
    KYD("Dollar (Cayman Islands)", new Iso3166Country[]{Iso3166Country.KY}),
    XCD("Dollar (East Caribbean)", new Iso3166Country[]{Iso3166Country.AI, Iso3166Country.AG, Iso3166Country.VG, Iso3166Country.DM, Iso3166Country.GD, Iso3166Country.MS, Iso3166Country.KN, Iso3166Country.LC, Iso3166Country.VC}),
    FJD("Dollar (Fiji)", new Iso3166Country[]{Iso3166Country.FJ}),
    GYD("Dollar (Guyana)", new Iso3166Country[]{Iso3166Country.GY}),
    HKD("Dollar (Hong Kong)", new Iso3166Country[]{Iso3166Country.HK}),
    JMD("Dollar (Jamaican)", new Iso3166Country[]{Iso3166Country.JM}),
    LRD("Dollar (Liberian)", new Iso3166Country[]{Iso3166Country.LR}),
    MYR("Dollar (Malaysian)", new Iso3166Country[]{Iso3166Country.MY}, "Synonym Ringgit"),
    NAD("Dollar (Namibian)", new Iso3166Country[]{Iso3166Country.NA}),
    NZD("Dollar (New Zealand)", new Iso3166Country[]{Iso3166Country.CK, Iso3166Country.NZ, Iso3166Country.NU, Iso3166Country.PN, Iso3166Country.TK}),
    SGD("Dollar (Singapore)", new Iso3166Country[]{Iso3166Country.SG}),
    SBD("Dollar (Solomon Islands)", new Iso3166Country[]{Iso3166Country.SB}),
    TWD("Dollar (Taiwan, New)", new Iso3166Country[]{Iso3166Country.TW}),
    TTD("Dollar (Trinidad and Tobago)", new Iso3166Country[]{Iso3166Country.TT}),
    ZWD("Dollar (Zimbabwe)", new Iso3166Country[]{Iso3166Country.ZW}),
    VND("D\u00c3\u0082\u00c2\u0099ng", new Iso3166Country[]{Iso3166Country.VN}),
    GRD("Drachma", new Iso3166Country[]{Iso3166Country.GR}),
    AMD("Dram", new Iso3166Country[]{Iso3166Country.AM}),
    EUR("Euro", new Iso3166Country[]{Iso3166Country.AT, Iso3166Country.BE, Iso3166Country.FI, Iso3166Country.FR, Iso3166Country.DE, Iso3166Country.GR, Iso3166Country.IE, Iso3166Country.IT, Iso3166Country.LU, Iso3166Country.NL, Iso3166Country.PT, Iso3166Country.ES, Iso3166Country.MC, Iso3166Country.VA, Iso3166Country.CS, Iso3166Country.SM, Iso3166Country.SI}),
    XEU("ECU", EUR),
    GQE("Ekwele", new Iso3166Country[]{Iso3166Country.GQ}),
    CVE("Escudo (Caboverdiano)", new Iso3166Country[]{Iso3166Country.CV}),
    PTE("Escudo (Portuguese)", new Iso3166Country[]{Iso3166Country.PT}, EUR),
    TPE("Escudo (Timorian)", "TODO: Confirm country"),
    FLORIN("Florin", EUR, "TODO: Find old ISO 4217 Code for Florin"),
    HUF("Forint", new Iso3166Country[]{Iso3166Country.HU}),
    BEF("Franc (Belgian)", new Iso3166Country[]{Iso3166Country.BE}, EUR, "Synonym Frank"),
    BEC("Franc (Belgian, Convertible)", new Iso3166Country[]{Iso3166Country.BE}, EUR),
    BEL("Franc (Belgian, Financial)", new Iso3166Country[]{Iso3166Country.BE}, EUR),
    BIF("Franc (Burundi)", new Iso3166Country[]{Iso3166Country.BI}),
    KMF("Franc (Comorian)", new Iso3166Country[]{Iso3166Country.KM}),
    XAF("Franc (de la Communaut\u00c3\u0082\u00c2\u008e financi\u00c3\u0082\u00c2\u008fre africaine [Central African Franc])", new Iso3166Country[]{Iso3166Country.BJ, Iso3166Country.BF, Iso3166Country.CM, Iso3166Country.CF, Iso3166Country.TD, Iso3166Country.CG, Iso3166Country.CI, Iso3166Country.GQ, Iso3166Country.GA, Iso3166Country.GW, Iso3166Country.ML, Iso3166Country.NE, Iso3166Country.SN, Iso3166Country.TG}),
    XPF("Franc (des Comptoirs fran\u00c3\u0082\u00c2\u008dais du Pacifique [Pacific Franc])", new Iso3166Country[]{Iso3166Country.PF, Iso3166Country.NC, Iso3166Country.WF}),
    DJF("Franc (Djibouti)", new Iso3166Country[]{Iso3166Country.DJ}),
    FRF("Franc (French)", new Iso3166Country[]{Iso3166Country.AD, Iso3166Country.FR, Iso3166Country.GF, Iso3166Country.TF, Iso3166Country.GP, Iso3166Country.MQ, Iso3166Country.YT, Iso3166Country.MC, Iso3166Country.RE, Iso3166Country.PM}, EUR),
    GNS("Syli (Guinea)", new Iso3166Country[]{Iso3166Country.GN}),
    GNF("Franc (Guinea)", new Iso3166Country[]{Iso3166Country.GN}, "// TODO: Check which is valid, GNS or GNF, or if codes are true synonyms"),
    LUF("Franc (Luxembourg)", new Iso3166Country[]{Iso3166Country.LU}, EUR),
    MGA("Ariary (Malagasy)", new Iso3166Country[]{Iso3166Country.MG}),
    MGF("Franc (Malagasy)", new Iso3166Country[]{Iso3166Country.MG}, MGA),
    MLF("Franc (Malian)", new Iso3166Country[]{Iso3166Country.ML}),
    RWF("Franc (Rwanda)", new Iso3166Country[]{Iso3166Country.RW}),
    CHF("Franc (Swiss)", new Iso3166Country[]{Iso3166Country.LI, Iso3166Country.CH}),
    XOF("Franc (West African)", new Iso3166Country[]{Iso3166Country.NE, Iso3166Country.SN}),
    HTG("Gourde", new Iso3166Country[]{Iso3166Country.HT}),
    PYG("Guarani", new Iso3166Country[]{Iso3166Country.PY}),
    AWG("Guilder (Aruban)", new Iso3166Country[]{Iso3166Country.AW}),
    NLG("Guilder (Dutch)", new Iso3166Country[]{Iso3166Country.NL}, EUR, "Synonym Gulden"),
    ANG("Guilder (Netherlands Antilles)", new Iso3166Country[]{Iso3166Country.AN}),
    SRD("Dollar (Surinam)", new Iso3166Country[]{Iso3166Country.SR}),
    SRG("Guilder (Surinam)", new Iso3166Country[]{Iso3166Country.SR}, SRD),
    UAH("Hryvna", new Iso3166Country[]{Iso3166Country.UA}),
    PEI("Inti", new Iso3166Country[]{Iso3166Country.PE}),
    UAK("Karbovanet", new Iso3166Country[]{Iso3166Country.UA}),
    PGK("Kina", new Iso3166Country[]{Iso3166Country.PG}),
    LAK("Kip", new Iso3166Country[]{Iso3166Country.LA}),
    CZK("Koruna (Czech)", new Iso3166Country[]{Iso3166Country.CZ}),
    CSK("Koruna (Czech)", new Iso3166Country[]{Iso3166Country.CZ}, CZK, "Misuse"),
    SKK("Koruna (Slovak)", new Iso3166Country[]{Iso3166Country.SK}),
    ISK("Kr\u00c3\u0082\u00c2\u0097na (Icelandic)", new Iso3166Country[]{Iso3166Country.IS}),
    SEK("Krona (Swedish)", new Iso3166Country[]{Iso3166Country.SE}),
    DKK("Krone (Danish)", new Iso3166Country[]{Iso3166Country.DK, Iso3166Country.FO, Iso3166Country.GL}),
    NOK("Krone (Norwegian)", new Iso3166Country[]{Iso3166Country.AQ, Iso3166Country.BV, Iso3166Country.NO, Iso3166Country.SJ}),
    EEK("Kroon", new Iso3166Country[]{Iso3166Country.EE}),
    HRK("Kuna", new Iso3166Country[]{Iso3166Country.HR}),
    MWK("Kwacha (Malawian)", new Iso3166Country[]{Iso3166Country.MW}),
    ZMK("Kwacha (Zambian)", new Iso3166Country[]{Iso3166Country.ZM}),
    MMK("Kyat", new Iso3166Country[]{Iso3166Country.MM}, "Formerly BUK"),
    GEL("Lari", new Iso3166Country[]{Iso3166Country.GE}),
    LVL("Lats", new Iso3166Country[]{Iso3166Country.LA}),
    ALL("Lek", new Iso3166Country[]{Iso3166Country.AL}),
    HNL("Lempira", new Iso3166Country[]{Iso3166Country.HN}),
    SLL("Leone", new Iso3166Country[]{Iso3166Country.SL}),
    MDL("Leu (Moldavian)", new Iso3166Country[]{Iso3166Country.MD}),
    RON("Leu (New Romanian)", new Iso3166Country[]{Iso3166Country.RO}),
    ROL("Leu (Romanian)", new Iso3166Country[]{Iso3166Country.RO}, RON),
    BGN("Lev", new Iso3166Country[]{Iso3166Country.BG}),
    BGL("Lev", new Iso3166Country[]{Iso3166Country.BG}, BGN),
    SZL("Lilangeni", new Iso3166Country[]{Iso3166Country.SZ}),
    ITL("Lira (Italian)", new Iso3166Country[]{Iso3166Country.VA, Iso3166Country.IT, Iso3166Country.SM}, EUR),
    MTL("Lira (Maltese)", new Iso3166Country[]{Iso3166Country.MT}),
    TRY("Lira (New Turkish)", new Iso3166Country[]{Iso3166Country.TR}),
    TRL("Lira (Turkish)", new Iso3166Country[]{Iso3166Country.TR}, TRY),
    LTL("Litas", new Iso3166Country[]{Iso3166Country.LT}),
    LSL("Loti", new Iso3166Country[]{Iso3166Country.LS}),
    LSM("Maloti", new Iso3166Country[]{Iso3166Country.LS}),
    AZN("Manat (Azerbaijani)", new Iso3166Country[]{Iso3166Country.AZ}),
    AZM("Manat (Azerbaijani)", new Iso3166Country[]{Iso3166Country.AZ}, "TODO: Check is true synonym"),
    TMM("Manat (Turkmenistani)", new Iso3166Country[]{Iso3166Country.TM}),
    DEM("Mark (Deutsche)", new Iso3166Country[]{Iso3166Country.DE}, EUR, "Formerly DDM in east germany"),
    FIM("Markka", new Iso3166Country[]{Iso3166Country.FI}, EUR),
    MZM("Metical", new Iso3166Country[]{Iso3166Country.MZ}),
    NGN("Naira", new Iso3166Country[]{Iso3166Country.NG}),
    ERN("Nakfa", new Iso3166Country[]{Iso3166Country.ER}),
    AOA("Kwanza", new Iso3166Country[]{Iso3166Country.AO}, "Replaced AOK"),
    MXN("New Peso (Mexican)", new Iso3166Country[]{Iso3166Country.MX}, "Replaced MXP"),
    MXV("Mexican Unidad de Inversion", new Iso3166Country[]{Iso3166Country.MX}, "UDI Funds Code"),
    UYU("New Peso (Uruguayan)", new Iso3166Country[]{Iso3166Country.UY}, "Replaced UYP"),
    PEN("New Sol", new Iso3166Country[]{Iso3166Country.PE}, "Replaced PES"),
    PLN("New Zloty", new Iso3166Country[]{Iso3166Country.PL}, "Replaced PLZ"),
    BTN("Ngultrum", new Iso3166Country[]{Iso3166Country.BT}),
    ARS("Nuevo Peso", new Iso3166Country[]{Iso3166Country.AR}, "Replaced ARP"),
    MRO("Ouguiya", new Iso3166Country[]{Iso3166Country.MR, Iso3166Country.EH}),
    TOP("Pa'anga", new Iso3166Country[]{Iso3166Country.TO}),
    MOP("Pataca", new Iso3166Country[]{Iso3166Country.MO}),
    ADP("Peseta (Andorran)", new Iso3166Country[]{Iso3166Country.AD}, EUR),
    ESP("Peseta (Spanish)", new Iso3166Country[]{Iso3166Country.AD, Iso3166Country.ES, Iso3166Country.EH}, EUR),
    BOP("Peso (Bolivian)", new Iso3166Country[]{Iso3166Country.BO}),
    BOV("Mvdol (Bolivian)", new Iso3166Country[]{Iso3166Country.BO}, "Funds code"),
    CLP("Peso (Chilean)", new Iso3166Country[]{Iso3166Country.CL}),
    COP("Peso (Colombian)", new Iso3166Country[]{Iso3166Country.CO}),
    COU("Unidad de Valor Real", new Iso3166Country[]{Iso3166Country.CO}, "TODO: Verify the correct/legacy Columbian currency"),
    CUP("Peso (Cuban)", new Iso3166Country[]{Iso3166Country.CU}),
    DOP("Peso (Dominican Republic)", new Iso3166Country[]{Iso3166Country.DO}),
    GWP("Peso (Guinea-Bissau)", new Iso3166Country[]{Iso3166Country.GW}),
    PHP("Peso (Philippines)", new Iso3166Country[]{Iso3166Country.PH}),
    CYP("Pound (Cypriot)", new Iso3166Country[]{Iso3166Country.CY}),
    EGP("Pound (Egytian)", new Iso3166Country[]{Iso3166Country.EG}),
    FKP("Pound (Falkland)", new Iso3166Country[]{Iso3166Country.FK}),
    GIP("Pound (Gibraltar)", new Iso3166Country[]{Iso3166Country.GI}),
    LBP("Pound (Lebanese)", new Iso3166Country[]{Iso3166Country.LB}),
    SHP("Pound (St Helena)", new Iso3166Country[]{Iso3166Country.SH}),
    GBP("Pound (Sterling)", new Iso3166Country[]{Iso3166Country.IO, Iso3166Country.VG, Iso3166Country.GS, Iso3166Country.GB}),
    SDP("Pound (Sudanese)", new Iso3166Country[]{Iso3166Country.SD}),
    SYP("Pound (Syrian)", new Iso3166Country[]{Iso3166Country.SY}),
    BWP("Pula", new Iso3166Country[]{Iso3166Country.BW}),
    IEP("Punt", new Iso3166Country[]{Iso3166Country.IE}, EUR),
    GTQ("Quetzal", new Iso3166Country[]{Iso3166Country.GT}),
    ZAR("Rand", new Iso3166Country[]{Iso3166Country.LS, Iso3166Country.NA, Iso3166Country.ZA}),
    ZAL("Rand (financial)", new Iso3166Country[]{Iso3166Country.ZA}),
    IRR("Rial (Iranian)", new Iso3166Country[]{Iso3166Country.IR}),
    OMR("Rial (Omani)", new Iso3166Country[]{Iso3166Country.OM}),
    KHR("Riel", new Iso3166Country[]{Iso3166Country.KH}),
    QAR("Riyal (Qatari)", new Iso3166Country[]{Iso3166Country.QA}),
    SAR("Riyal (Saudi)", new Iso3166Country[]{Iso3166Country.SA}),
    BYR("Rouble (Belarussian)", new Iso3166Country[]{Iso3166Country.BY}),
    RUB("Rouble (Russian Federation)", new Iso3166Country[]{Iso3166Country.RU}, "Formerly RUR"),
    TJR("Rouble (Tajik)", new Iso3166Country[]{Iso3166Country.TJ}),
    TJS("Somoni", new Iso3166Country[]{Iso3166Country.TJ}, "TODO: Check which is correct, TJR/TJS"),
    MVR("Rufiyaa", new Iso3166Country[]{Iso3166Country.MV}),
    INR("Rupee (Indian)", new Iso3166Country[]{Iso3166Country.BT, Iso3166Country.IN}),
    MUR("Rupee (Mauritius)", new Iso3166Country[]{Iso3166Country.MU}),
    NPR("Rupee (Nepalese)", new Iso3166Country[]{Iso3166Country.NP}),
    PKR("Rupee (Pakistani)", new Iso3166Country[]{Iso3166Country.PK}),
    SCR("Rupee (Seychelles)", new Iso3166Country[]{Iso3166Country.IO, Iso3166Country.SC}),
    LKR("Rupee (Sri Lankan)", new Iso3166Country[]{Iso3166Country.LK}),
    IDR("Rupiah", new Iso3166Country[]{Iso3166Country.ID}),
    ATS("Schilling", new Iso3166Country[]{Iso3166Country.AT}, EUR),
    ILS("Shekel", new Iso3166Country[]{Iso3166Country.IL}),
    KES("Shilling (Kenyan)", new Iso3166Country[]{Iso3166Country.KE}),
    SOS("Shilling (Somali)", new Iso3166Country[]{Iso3166Country.SO}),
    TZS("Shilling (Tanzanian)", new Iso3166Country[]{Iso3166Country.TZ}),
    UGX("Shilling (Ugandan)", new Iso3166Country[]{Iso3166Country.UG}),
    UGS("Shilling (Ugandan)", new Iso3166Country[]{Iso3166Country.UG}, UGX),
    KGS("Som (Kyrgyzstani)", new Iso3166Country[]{Iso3166Country.KG}),
    UZS("Som (Uzbekistani)", new Iso3166Country[]{Iso3166Country.UZ}),
    USD("US Dollar", new Iso3166Country[]{Iso3166Country.AS, Iso3166Country.VG, Iso3166Country.EC, Iso3166Country.FM, Iso3166Country.GU, Iso3166Country.MH, Iso3166Country.PW, Iso3166Country.PA, Iso3166Country.PR, Iso3166Country.TC, Iso3166Country.US, Iso3166Country.UM, Iso3166Country.VI}),
    ECS("Sucre", new Iso3166Country[]{Iso3166Country.EC}, USD),
    BDT("Taka", new Iso3166Country[]{Iso3166Country.BD}),
    WST("Tala", new Iso3166Country[]{Iso3166Country.WS}),
    KZT("Tenge", new Iso3166Country[]{Iso3166Country.KZ}),
    SIT("Tolar", new Iso3166Country[]{Iso3166Country.SI}, EUR),
    MNT("Tugrik", new Iso3166Country[]{Iso3166Country.MN}),
    CLF("Unidades de Fomento", new Iso3166Country[]{Iso3166Country.CL}),
    VUV("Vatu", new Iso3166Country[]{Iso3166Country.VU}),
    KPW("Won (North Korean)", new Iso3166Country[]{Iso3166Country.KP}),
    KRW("Won (South Korean)", new Iso3166Country[]{Iso3166Country.KR}),
    JPY("Yen", new Iso3166Country[]{Iso3166Country.JP}),
    CNY("Yuan Renminbi", new Iso3166Country[]{Iso3166Country.CN}),
    CDF("Franc (Congolaise)", new Iso3166Country[]{Iso3166Country.CD}),
    CDZ("Za\u00c3\u0082\u00c2\u0095re (New)", new Iso3166Country[]{Iso3166Country.CD}, CDF, "Formerly ZRZ"),
    XPD("Palladium (one Troy ounce)"),
    XPT("Platinum (one Troy ounce)"),
    XAG("Silver (one Troy ounce)"),
    XAU("Gold (one Troy ounce)"),
    XBA("European Composite Unit (EURCO) (Bonds market unit)"),
    XBB("European Monetary Unit (E.M.U.-6) (Bonds market unit)"),
    XBC("European Unit of Account 9 (E.U.A.-9) (Bonds market unit)"),
    XBD("European Unit of Account 17 (E.U.A.-17) (Bonds market unit)"),
    XDR("Special Drawing Rights (International Monetary Fund)"),
    XFO("Gold-franc (Special settlement currency)"),
    XFU("UIC franc (Special settlement currency)");

    private String fullName;
    private Iso4217Currency replacement;
    private Iso3166Country[] countries;
    private String notes;

    private Iso4217Currency(String fullName) {
        this.fullName = fullName;
    }

    private Iso4217Currency(String fullName, String notes) {
        this.fullName = fullName;
        this.notes = notes;
    }

    private Iso4217Currency(String fullName, Iso3166Country[] countries) {
        this.fullName = fullName;
        this.countries = countries;
    }

    private Iso4217Currency(String fullName, Iso3166Country[] countries, String notes) {
        this.fullName = fullName;
        this.countries = countries;
        this.notes = notes;
    }

    private Iso4217Currency(String fullName, Iso3166Country[] countries, Iso4217Currency replacement) {
        this.fullName = fullName;
        this.countries = countries;
        this.replacement = replacement;
    }

    private Iso4217Currency(String fullName, Iso3166Country[] countries, Iso4217Currency replacement, String notes) {
        this.fullName = fullName;
        this.countries = countries;
        this.replacement = replacement;
        this.notes = notes;
    }

    private Iso4217Currency(String fullName, Iso4217Currency replacement) {
        this.fullName = fullName;
        this.replacement = replacement;
    }

    private Iso4217Currency(String fullName, Iso4217Currency replacement, String notes) {
        this.fullName = fullName;
        this.replacement = replacement;
        this.notes = notes;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Iso3166Country[] getCountries() {
        return this.countries;
    }

    public Iso4217Currency getReplacement() {
        return this.replacement;
    }

    public boolean hasBeenReplaced() {
        return this.getReplacement() != null;
    }

    public String getNotes() {
        return this.notes;
    }
}

