/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.util;

import org.joda.time.Days;
import org.joda.time.LocalDate;

public class DateUtils {
    public static int daysBetween(LocalDate start, LocalDate end) {
        return Days.daysBetween(start, end).getDays();
    }

    public static boolean isLeapYear(LocalDate date) {
        int year = date.getYear();
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static boolean isLastDayOfMonth(LocalDate date) {
        return date.getDayOfMonth() == DateUtils.getDaysInMonth(date);
    }

    public static int getDaysInYear(LocalDate date) {
        if (DateUtils.isLeapYear(date)) {
            return 366;
        }
        return 365;
    }

    public static int getDaysInMonth(LocalDate date) {
        switch (date.getMonthOfYear()) {
            case 2: {
                if (DateUtils.isLeapYear(date)) {
                    return 29;
                }
                return 28;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
        }
        return 30;
    }
}

