/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.schedule.impl;

import com.mbc.jfin.schedule.Schedule;
import com.mbc.jfin.schedule.ScheduleException;
import com.mbc.jfin.schedule.SchedulePeriod;
import com.mbc.jfin.schedule.impl.AbstractBaseScheduleGenerator;
import com.mbc.jfin.schedule.impl.ScheduleTooLongException;
import com.mbc.jfin.schedule.impl.ScheduleWontFitException;
import java.util.ArrayList;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePeriod;

public class NoStubScheduleGenerator
extends AbstractBaseScheduleGenerator {
    public NoStubScheduleGenerator() {
        super(-1);
    }

    public NoStubScheduleGenerator(int maxPeriods) {
        super(maxPeriods);
    }

    @Override
    public Schedule generate(LocalDate start, LocalDate end, ReadablePeriod frequency) throws ScheduleException {
        ArrayList<SchedulePeriod> schedulePeriods = new ArrayList<SchedulePeriod>();
        LocalDate holdDate = start;
        int periodCount = 1;
        while (holdDate.isBefore(end)) {
            LocalDate nextDate = start.plus(this.multiplyPeriod(frequency, periodCount));
            if (nextDate.isAfter(end)) {
                throw new ScheduleWontFitException(start, end, frequency);
            }
            SchedulePeriod schedulePeriod = new SchedulePeriod(holdDate, nextDate);
            schedulePeriods.add(schedulePeriod);
            holdDate = nextDate;
            if (this.maxPeriods <= 0 || ++periodCount <= this.maxPeriods) continue;
            throw new ScheduleTooLongException(this.maxPeriods);
        }
        return new Schedule(schedulePeriods);
    }
}

