/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.holiday.impl.financialcalendar;

import com.mbc.jfin.holiday.impl.financialcalendar.InfoFileEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class InfoFile {
    private Map<String, InfoFileEntry> entries = new TreeMap<String, InfoFileEntry>();

    public InfoFile(String fileName) throws IOException {
        this(new File(fileName));
    }

    public InfoFile(File f) throws IOException {
        this(new FileReader(f));
    }

    public InfoFile(Reader reader) throws IOException {
        this.load(reader);
    }

    public void load(Reader rawReader) throws IOException {
        BufferedReader reader = new BufferedReader(rawReader);
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            InfoFileEntry infoFileEntry = new InfoFileEntry(line);
            this.entries.put(infoFileEntry.getCode(), infoFileEntry);
        }
    }

    public InfoFileEntry getEntryByCode(String code) {
        return this.entries.get(code);
    }

    public String[] getAvailableCodes() {
        ArrayList<String> codes = new ArrayList<String>(this.entries.keySet());
        Collections.sort(codes);
        String[] codesArray = new String[codes.size()];
        for (int i = 0; i < codes.size(); ++i) {
            codesArray[i] = (String)codes.get(i);
        }
        return codesArray;
    }
}

