/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.holiday.impl.financialcalendar;

import com.mbc.jfin.holiday.impl.financialcalendar.InfoFile;
import com.mbc.jfin.holiday.impl.financialcalendar.InfoFileEntry;

public class HolidayFileEntry {
    private String date;
    private InfoFileEntry info;
    private String description;

    public HolidayFileEntry(String lineToParse, InfoFile infoFile) {
        this.parse(lineToParse, infoFile);
    }

    public HolidayFileEntry(String date, InfoFileEntry info, String description) {
        this.date = date;
        this.info = info;
        this.description = description;
    }

    public void parse(String line, InfoFile infoFile) {
        String[] parts = line.split(",");
        if (parts.length > 0) {
            this.date = parts[0];
        }
        if (parts.length > 1) {
            this.info = infoFile.getEntryByCode(parts[1]);
        }
        if (parts.length > 2) {
            this.description = parts[2];
        }
    }

    public String getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public InfoFileEntry getInfo() {
        return this.info;
    }

    public static String getReference(String date, String infoCode) {
        return date + ":" + infoCode;
    }

    public String getReference() {
        return HolidayFileEntry.getReference(this.getDate(), this.getInfo().getCode());
    }
}

