/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.holiday.impl;

import com.mbc.jfin.holiday.BusinessDayConvention;
import com.mbc.jfin.holiday.DateAdjustmentService;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.holiday.impl.DefaultDateAdjustmentServiceImpl;
import com.mbc.jfin.holiday.impl.WeekendHolidayCalendar;
import junit.framework.TestCase;
import org.joda.time.LocalDate;

public class DefaultDateAdjustmentServiceImplTest
extends TestCase {
    DateAdjustmentService service;
    HolidayCalendar weekendCalendar;
    HolidayCalendar holidayCalendar;

    protected void setUp() throws Exception {
        this.service = new DefaultDateAdjustmentServiceImpl();
        this.weekendCalendar = new WeekendHolidayCalendar();
        this.holidayCalendar = new HolidayCalendar(){

            @Override
            public boolean isHoliday(LocalDate date) {
                return date.getDayOfWeek() == 6 || date.getDayOfWeek() == 7;
            }

            @Override
            public boolean isWeekend(LocalDate date) {
                return false;
            }
        };
    }

    public void testFollowing() {
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 29), (Object)this.service.adjust(new LocalDate(2005, 12, 29), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 1, 2), (Object)this.service.adjust(new LocalDate(2005, 12, 31), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 1, 2), (Object)this.service.adjust(new LocalDate(2006, 1, 1), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 28), (Object)this.service.adjust(new LocalDate(2008, 2, 28), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 2, 29), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 3, 3), (Object)this.service.adjust(new LocalDate(2008, 3, 1), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 13), (Object)this.service.adjust(new LocalDate(2006, 2, 11), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 13), (Object)this.service.adjust(new LocalDate(2006, 2, 12), BusinessDayConvention.FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 29), (Object)this.service.adjust(new LocalDate(2005, 12, 29), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 1, 2), (Object)this.service.adjust(new LocalDate(2005, 12, 31), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 1, 2), (Object)this.service.adjust(new LocalDate(2006, 1, 1), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 28), (Object)this.service.adjust(new LocalDate(2008, 2, 28), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 2, 29), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 3, 3), (Object)this.service.adjust(new LocalDate(2008, 3, 1), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 13), (Object)this.service.adjust(new LocalDate(2006, 2, 11), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 13), (Object)this.service.adjust(new LocalDate(2006, 2, 12), BusinessDayConvention.FOLLOWING, this.holidayCalendar));
    }

    public void testModFollowing() {
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 29), (Object)this.service.adjust(new LocalDate(2005, 12, 29), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 30), (Object)this.service.adjust(new LocalDate(2005, 12, 31), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 1, 2), (Object)this.service.adjust(new LocalDate(2006, 1, 1), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 28), (Object)this.service.adjust(new LocalDate(2008, 2, 28), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 2, 29), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 3, 3), (Object)this.service.adjust(new LocalDate(2008, 3, 1), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 13), (Object)this.service.adjust(new LocalDate(2006, 2, 11), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 13), (Object)this.service.adjust(new LocalDate(2006, 2, 12), BusinessDayConvention.MODIFIED_FOLLOWING, this.weekendCalendar));
    }

    public void testPreceding() {
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 29), (Object)this.service.adjust(new LocalDate(2005, 12, 29), BusinessDayConvention.PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 30), (Object)this.service.adjust(new LocalDate(2005, 12, 31), BusinessDayConvention.PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 30), (Object)this.service.adjust(new LocalDate(2006, 1, 1), BusinessDayConvention.PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 28), (Object)this.service.adjust(new LocalDate(2008, 2, 28), BusinessDayConvention.PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 2, 29), BusinessDayConvention.PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 3, 1), BusinessDayConvention.PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 10), (Object)this.service.adjust(new LocalDate(2006, 2, 11), BusinessDayConvention.PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 10), (Object)this.service.adjust(new LocalDate(2006, 2, 12), BusinessDayConvention.PRECEDING, this.weekendCalendar));
    }

    public void testModPreceding() {
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 29), (Object)this.service.adjust(new LocalDate(2005, 12, 29), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 30), (Object)this.service.adjust(new LocalDate(2005, 12, 31), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 1, 2), (Object)this.service.adjust(new LocalDate(2006, 1, 1), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 28), (Object)this.service.adjust(new LocalDate(2008, 2, 28), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 2, 29), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 3, 3), (Object)this.service.adjust(new LocalDate(2008, 3, 1), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 10), (Object)this.service.adjust(new LocalDate(2006, 2, 11), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 10), (Object)this.service.adjust(new LocalDate(2006, 2, 12), BusinessDayConvention.MODIFIED_PRECEDING, this.weekendCalendar));
    }

    public void testMonthEndReference() {
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 30), (Object)this.service.adjust(new LocalDate(2005, 12, 29), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2005, 12, 30), (Object)this.service.adjust(new LocalDate(2005, 12, 31), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 1, 31), (Object)this.service.adjust(new LocalDate(2006, 1, 1), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 2, 28), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 2, 29), (Object)this.service.adjust(new LocalDate(2008, 2, 29), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2008, 3, 31), (Object)this.service.adjust(new LocalDate(2008, 3, 1), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 28), (Object)this.service.adjust(new LocalDate(2006, 2, 11), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
        DefaultDateAdjustmentServiceImplTest.assertEquals((Object)new LocalDate(2006, 2, 28), (Object)this.service.adjust(new LocalDate(2006, 2, 12), BusinessDayConvention.MONTH_END_REFERENCE, this.weekendCalendar));
    }
}

