/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.holiday.impl;

import com.mbc.jfin.holiday.BusinessDayConvention;
import com.mbc.jfin.holiday.DateAdjustmentService;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.util.DateUtils;
import org.joda.time.Days;
import org.joda.time.LocalDate;

public class DefaultDateAdjustmentServiceImpl
implements DateAdjustmentService {
    @Override
    public LocalDate adjust(LocalDate calendar, BusinessDayConvention businessDayConvention, HolidayCalendar holidayCalendar) {
        switch (businessDayConvention) {
            case UNADJUSTED: {
                return calendar;
            }
            case FOLLOWING: {
                return this.following(calendar, holidayCalendar);
            }
            case MODIFIED_FOLLOWING: {
                return this.modFollowing(calendar, holidayCalendar);
            }
            case PRECEDING: {
                return this.preceding(calendar, holidayCalendar);
            }
            case MODIFIED_PRECEDING: {
                return this.modPreceding(calendar, holidayCalendar);
            }
            case MONTH_END_REFERENCE: {
                return this.monthEndReference(calendar, holidayCalendar);
            }
        }
        throw new UnsupportedBusinessDayConventionException(businessDayConvention);
    }

    private LocalDate monthEndReference(LocalDate calendar, HolidayCalendar holidayCalendar) {
        LocalDate d1 = new LocalDate(calendar.getYear(), calendar.getMonthOfYear(), DateUtils.getDaysInMonth(calendar));
        return this.preceding(d1, holidayCalendar);
    }

    public LocalDate following(LocalDate calendar, HolidayCalendar holidayCalendar) {
        LocalDate d1 = calendar;
        while (holidayCalendar.isHoliday(d1) || holidayCalendar.isWeekend(d1)) {
            d1 = d1.plus(Days.ONE);
        }
        return d1;
    }

    public LocalDate modFollowing(LocalDate calendar, HolidayCalendar holidayCalendar) {
        LocalDate d1 = calendar;
        while (holidayCalendar.isHoliday(d1) || holidayCalendar.isWeekend(d1)) {
            d1 = d1.plus(Days.ONE);
        }
        if (d1.getMonthOfYear() != calendar.getMonthOfYear()) {
            return this.preceding(calendar, holidayCalendar);
        }
        return d1;
    }

    public LocalDate preceding(LocalDate calendar, HolidayCalendar holidayCalendar) {
        LocalDate d1 = calendar;
        while (holidayCalendar.isHoliday(d1) || holidayCalendar.isWeekend(d1)) {
            d1 = d1.minus(Days.ONE);
        }
        return d1;
    }

    public LocalDate modPreceding(LocalDate calendar, HolidayCalendar holidayCalendar) {
        LocalDate d1 = calendar;
        while (holidayCalendar.isHoliday(d1) || holidayCalendar.isWeekend(d1)) {
            d1 = d1.minus(Days.ONE);
        }
        if (d1.getMonthOfYear() != calendar.getMonthOfYear()) {
            return this.following(calendar, holidayCalendar);
        }
        return d1;
    }

    private class UnsupportedBusinessDayConventionException
    extends RuntimeException {
        public UnsupportedBusinessDayConventionException(BusinessDayConvention businessDayConvention) {
            super("Unsupported business day convention: " + (Object)((Object)businessDayConvention));
        }
    }
}

