/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount.impl.calculator;

import com.mbc.jfin.daycount.impl.DaycountCalculator;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.schedule.SchedulePeriod;
import com.mbc.jfin.util.DateUtils;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

public class ISDAActualActualDaycountCalculator
implements DaycountCalculator {
    @Override
    public double calculateDaycountFraction(SchedulePeriod period, HolidayCalendar calendar) {
        if (period.getStart().equals(period.getEnd())) {
            return 0.0;
        }
        double fraction = 0.0;
        List<SchedulePeriod> subPeriods = this.getPeriods(period);
        int[] numerators = this.getNumerators(subPeriods);
        int[] denominators = this.getDenominators(subPeriods);
        for (int i = 0; i < numerators.length; ++i) {
            fraction += (double)numerators[i] / (double)denominators[i];
        }
        return fraction;
    }

    public List<SchedulePeriod> getPeriods(SchedulePeriod period) {
        LocalDate hold = period.getStart();
        LocalDate end = period.getEnd();
        ArrayList<SchedulePeriod> periods = new ArrayList<SchedulePeriod>();
        while (hold.getYear() < end.getYear()) {
            LocalDate holdEnd = new LocalDate(hold.getYear() + 1, 1, 1);
            periods.add(new SchedulePeriod(hold, holdEnd));
            hold = holdEnd;
        }
        periods.add(new SchedulePeriod(hold, end));
        return periods;
    }

    public int[] getNumerators(List<SchedulePeriod> subPeriods) {
        int[] numerators = new int[subPeriods.size()];
        for (int i = 0; i < subPeriods.size(); ++i) {
            SchedulePeriod period = subPeriods.get(i);
            numerators[i] = DateUtils.daysBetween(period.getStart(), period.getEnd());
        }
        return numerators;
    }

    public int[] getDenominators(List<SchedulePeriod> subPeriods) {
        int[] denominators = new int[subPeriods.size()];
        for (int i = 0; i < subPeriods.size(); ++i) {
            SchedulePeriod period = subPeriods.get(i);
            denominators[i] = DateUtils.getDaysInYear(period.getStart());
        }
        return denominators;
    }
}

