/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount;

import com.mbc.jfin.daycount.DaycountConvention;
import com.mbc.jfin.daycount.DaycountException;
import com.mbc.jfin.daycount.DaycountService;
import com.mbc.jfin.daycount.impl.DefaultDaycountServiceImpl;
import com.mbc.jfin.schedule.SchedulePeriod;
import junit.framework.TestCase;
import org.joda.time.LocalDate;

public class ISDAMarketConventionsDocTest
extends TestCase {
    private double notional = 10000.0;
    private double fixedRate = 0.1;
    private DaycountService daycountService;

    protected void setUp() throws Exception {
        super.setUp();
        this.daycountService = new DefaultDaycountServiceImpl();
    }

    public void testPage3() throws DaycountException {
        SchedulePeriod period = new SchedulePeriod(new LocalDate(2003, 11, 1), new LocalDate(2004, 5, 1));
        ISDAMarketConventionsDocTest.assertEquals((double)497.72, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, period), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)500.0, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, period), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)497.27, (double)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, period), (double)0.01);
    }

    public void testPage4_5() throws DaycountException {
        LocalDate notionalStartDate = new LocalDate(1998, 7, 1);
        LocalDate date1 = new LocalDate(1999, 2, 1);
        LocalDate date2 = new LocalDate(1999, 7, 1);
        LocalDate date3 = new LocalDate(2000, 7, 1);
        ISDAMarketConventionsDocTest.assertEquals((double)410.96, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, date2)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)410.96, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, date2)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)410.96, (double)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, date2)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)1001.38, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)1000.0, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((Object)1000.0, (Object)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3)));
    }

    public void testPage6() throws DaycountException {
        LocalDate notionalStartDate = new LocalDate(2002, 7, 15);
        LocalDate notionalEndDate = new LocalDate(2003, 1, 15);
        LocalDate date1 = new LocalDate(2002, 8, 15);
        LocalDate date2 = new LocalDate(2003, 7, 15);
        LocalDate date3 = new LocalDate(2004, 1, 15);
        ISDAMarketConventionsDocTest.assertEquals((double)915.07, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, notionalEndDate)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)915.76, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, notionalEndDate)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)915.07, (double)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, notionalEndDate)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)504.0, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)500.0, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)504.11, (double)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3)), (double)0.01);
    }

    public void testPage7() throws DaycountException {
        LocalDate date1 = new LocalDate(1999, 7, 30);
        LocalDate date2 = new LocalDate(2000, 1, 30);
        LocalDate date3 = new LocalDate(2000, 6, 30);
        LocalDate notionalEndDate = new LocalDate(2000, 7, 30);
        ISDAMarketConventionsDocTest.assertEquals((double)503.89, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)500.0, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)504.11, (double)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)415.3, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3, date2, notionalEndDate)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)417.58, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3, date2, notionalEndDate)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)415.3, (double)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, new SchedulePeriod(date2, date3, date2, notionalEndDate)), (double)0.01);
    }

    public void testPage8_9() throws DaycountException {
        LocalDate date1 = new LocalDate(1999, 11, 30);
        LocalDate date2 = new LocalDate(2000, 4, 30);
        LocalDate notionalStartDate = new LocalDate(2000, 2, 29);
        LocalDate notionalEndDate = new LocalDate(2000, 5, 31);
        ISDAMarketConventionsDocTest.assertEquals((double)415.54, (double)this.getAmount(DaycountConvention.ISDA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, notionalEndDate)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)415.76, (double)this.getAmount(DaycountConvention.ISMA_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, notionalEndDate)), (double)0.01);
        ISDAMarketConventionsDocTest.assertEquals((double)415.3, (double)this.getAmount(DaycountConvention.AFB_ACTUAL_ACTUAL, new SchedulePeriod(date1, date2, notionalStartDate, notionalEndDate)), (double)0.01);
    }

    public double getAmount(DaycountConvention convention, SchedulePeriod period) throws DaycountException {
        double daycount = this.daycountService.calculateDaycountFraction(period, convention, null);
        return this.notional * this.fixedRate * daycount;
    }
}

