/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.List;
import org.jfin.date.Frequency;
import org.jfin.date.Period;
import org.jfin.date.ScheduleException;
import org.jfin.date.ScheduleGenerator;
import org.jfin.date.StubType;

public class ScheduleService {
    public String[] getStubTypeNames() {
        StubType[] stubTypes = StubType.values();
        String[] names = new String[stubTypes.length];
        for (int i = 0; i < stubTypes.length; ++i) {
            names[i] = stubTypes[i].name();
        }
        return names;
    }

    public String[] getFrequencyNames() {
        Frequency[] frequencies = Frequency.values();
        String[] names = new String[frequencies.length];
        for (int i = 0; i < frequencies.length; ++i) {
            names[i] = frequencies[i].name();
        }
        return names;
    }

    public Calendar[][] getSchedule(Calendar startDate, Calendar endDate, String frequencyName, String stubTypeName) throws ScheduleException {
        Frequency frequency = Frequency.valueOf(frequencyName);
        StubType stubType = StubType.valueOf(stubTypeName);
        List<Period> schedule = ScheduleGenerator.generateSchedule(startDate, endDate, frequency, stubType);
        Calendar[][] calendars = new Calendar[schedule.size()][4];
        for (int i = 0; i < schedule.size(); ++i) {
            Period period = schedule.get(i);
            calendars[i][0] = period.getStartCalendar();
            calendars[i][1] = period.getEndCalendar();
            calendars[i][2] = period.getReferenceStartCalendar();
            calendars[i][3] = period.getReferenceEndCalendar();
        }
        return calendars;
    }
}

