/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.RandOut;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.awt.Color;
import java.util.Random;

public class VNRuleString {
    public static int getMaxNeighbor() {
        return 5;
    }

    public static int getMaxRuleEntry(String RuleString) {
        int statePerCell = VNRuleString.getStatePerCell(RuleString);
        int noOfNeighbors = VNRuleString.getMaxNeighbor();
        return MyMath.ipow(statePerCell, noOfNeighbors);
    }

    public static int getStatePerCell(String RuleString) {
        if (RuleString == null) {
            System.out.println("VNRuleString: null Rule String");
        }
        String RuleHeader = MyString.stripFront(RuleString, ';');
        int spc = 0;
        try {
            spc = Integer.parseInt(RuleHeader);
        }
        catch (NumberFormatException e) {
            System.out.println("VNRuleString: Invalid state per cell");
        }
        if (spc < 2) {
            System.out.println("VNRuleString: Invalid state per cell");
        }
        return spc;
    }

    public static byte[] getRuleArray(String RuleContent, int statePerCell) {
        int maxRuleEntry = MyMath.ipow(statePerCell, VNRuleString.getMaxNeighbor());
        byte[] ruleArray = new byte[maxRuleEntry];
        int lf = 10;
        int cr = 13;
        Random rand = new Random();
        for (int i = 0; i < maxRuleEntry; ++i) {
            ruleArray[i] = 0;
        }
        do {
            String command;
            if ((command = MyString.stripFront(RuleContent, ';')).regionMatches(true, 0, "%", 0, 1)) {
                if (command.indexOf(lf, 0) == -1 && command.indexOf(cr, 0) == -1) continue;
                System.out.println("VNRuleString: Warning: ';' may be missing.");
                continue;
            }
            double rnd = rand.nextDouble();
            ruleArray = VNRuleString.interpret(command, ruleArray, statePerCell, rnd);
        } while ((RuleContent = MyString.stripBack(RuleContent, ';')) != null);
        return ruleArray;
    }

    public static byte[] getRuleArray(String RuleString) {
        int statePerCell = VNRuleString.getStatePerCell(RuleString);
        String RuleContent = MyString.stripBack(RuleString, ';');
        return VNRuleString.getRuleArray(RuleContent, statePerCell);
    }

    private static Color[] interpretColorCommand(String command, Color[] stateColor) {
        String arg0 = new String();
        String arg1 = new String();
        String arg2 = new String();
        String arg3 = new String();
        String arg4 = new String();
        MyString cmd = new MyString(command, ' ');
        cmd.getArgument();
        if (cmd.wordNumber == 0) {
            return stateColor;
        }
        arg0 = cmd.arg0;
        arg1 = cmd.arg1;
        arg2 = cmd.arg2;
        arg3 = cmd.arg3;
        arg4 = cmd.arg4;
        if (arg0.regionMatches(true, 0, "color", 0, 5)) {
            int i = 0;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            try {
                i = Integer.parseInt(arg1);
                r = new Float(arg2).floatValue();
                g = new Float(arg3).floatValue();
                b = new Float(arg4).floatValue();
            }
            catch (NumberFormatException e) {
                System.out.println("Rule description error." + command);
                return stateColor;
            }
            stateColor[i] = new Color(r, g, b);
        }
        return stateColor;
    }

    private static byte[] interpret(String command, byte[] ruleArray, int statePerCell, double rnd) {
        int home = -1;
        String arg0 = new String();
        String arg1 = new String();
        String arg2 = new String();
        String arg3 = new String();
        String arg4 = new String();
        String arg5 = new String();
        String arg6 = new String();
        MyString cmd = new MyString(command, ' ');
        cmd.getArgument();
        if (cmd.wordNumber == 0) {
            return ruleArray;
        }
        arg0 = cmd.arg0;
        try {
            home = Integer.parseInt(arg0);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (home >= 0) {
            try {
                int north = Integer.parseInt(cmd.arg1);
                int east = Integer.parseInt(cmd.arg2);
                int south = Integer.parseInt(cmd.arg3);
                int west = Integer.parseInt(cmd.arg4);
                int next = Integer.parseInt(cmd.arg5);
                ruleArray = VNRuleString.setRuleArray(home, north, east, south, west, next, statePerCell, ruleArray);
                if (cmd.wordNumber > 6) {
                    System.out.println("Warning: Too many arguments");
                }
                return ruleArray;
            }
            catch (NumberFormatException e) {
                arg0 = cmd.arg1;
                arg1 = cmd.arg2;
                arg2 = cmd.arg3;
                arg3 = cmd.arg4;
                arg4 = cmd.arg5;
                arg5 = cmd.arg6;
            }
        } else {
            arg0 = cmd.arg0;
            arg1 = cmd.arg1;
            arg2 = cmd.arg2;
            arg3 = cmd.arg3;
            arg4 = cmd.arg4;
            arg5 = cmd.arg5;
            arg6 = cmd.arg6;
        }
        if (arg0.regionMatches(true, 0, "any", 0, 3)) {
            if (home < 0) {
                System.out.println("Rule description error." + command);
                return ruleArray;
            }
            try {
                int next = Integer.parseInt(arg1);
                for (int n = 0; n < statePerCell; ++n) {
                    for (int e = 0; e < statePerCell; ++e) {
                        for (int s = 0; s < statePerCell; ++s) {
                            for (int w = 0; w < statePerCell; ++w) {
                                VNRuleString.setRuleArray(home, n, e, s, w, next, statePerCell, ruleArray);
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Rule description error: " + command);
                return ruleArray;
            }
        }
        if (!arg0.regionMatches(true, 0, "color", 0, 5)) {
            if (arg0.regionMatches(true, 0, "etotal", 0, 6)) {
                if (home < 0) {
                    System.out.println("Rule description error." + command);
                    return ruleArray;
                }
                int one = 0;
                int two = 0;
                int next = 0;
                try {
                    one = Integer.parseInt(arg1);
                    two = Integer.parseInt(arg2);
                }
                catch (NumberFormatException e) {
                    System.out.println("Rule description error." + command);
                    return ruleArray;
                }
                try {
                    next = Integer.parseInt(arg3);
                }
                catch (NumberFormatException e) {
                    if (!arg3.regionMatches(true, 0, "arb", 0, 3)) {
                        System.out.println("Rule description error: " + command);
                        return ruleArray;
                    }
                    next = RandOut.make(arg3, statePerCell, rnd);
                }
                for (int n = 0; n < statePerCell; ++n) {
                    for (int e = 0; e < statePerCell; ++e) {
                        for (int s = 0; s < statePerCell; ++s) {
                            for (int w = 0; w < statePerCell; ++w) {
                                int one0 = 0;
                                int two0 = 0;
                                if (n == 1) {
                                    ++one0;
                                }
                                if (e == 1) {
                                    ++one0;
                                }
                                if (s == 1) {
                                    ++one0;
                                }
                                if (w == 1) {
                                    ++one0;
                                }
                                if (n == 2) {
                                    ++two0;
                                }
                                if (e == 2) {
                                    ++two0;
                                }
                                if (s == 2) {
                                    ++two0;
                                }
                                if (w == 2) {
                                    ++two0;
                                }
                                if (one != one0 || two != two0) continue;
                                ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, next, statePerCell, ruleArray);
                            }
                        }
                    }
                }
            } else if (arg0.regionMatches(true, 0, "noOuter", 0, 7)) {
                int c = 0;
                try {
                    c = Integer.parseInt(arg1);
                }
                catch (NumberFormatException e) {
                    System.out.println("Rule description error: " + command);
                    return ruleArray;
                }
                for (int n = 0; n < statePerCell; ++n) {
                    for (int e = 0; e < statePerCell; ++e) {
                        for (int s = 0; s < statePerCell; ++s) {
                            for (int w = 0; w < statePerCell; ++w) {
                                if (n == c || e == c || s == c || w == c) continue;
                                ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, arg2, statePerCell, ruleArray);
                            }
                        }
                    }
                }
            } else if (arg0.regionMatches(true, 0, "mixAll", 0, 6)) {
                if (statePerCell > 4) {
                    System.out.println("Unable to use: " + command);
                    return ruleArray;
                }
                boolean mixed = true;
                for (int n = 0; n < statePerCell; ++n) {
                    for (int e = 0; e < statePerCell; ++e) {
                        for (int s = 0; s < statePerCell; ++s) {
                            for (int w = 0; w < statePerCell; ++w) {
                                for (int i = 0; i < statePerCell; ++i) {
                                    if (n == i || e == i || s == i || w == i) continue;
                                    mixed = false;
                                }
                                if (mixed) {
                                    ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, arg1, statePerCell, ruleArray);
                                }
                                mixed = true;
                            }
                        }
                    }
                }
            } else if (arg0.regionMatches(true, 0, "mix2", 0, 4)) {
                int c1 = 0;
                int c2 = 0;
                try {
                    c1 = Integer.parseInt(arg1);
                    c2 = Integer.parseInt(arg2);
                }
                catch (NumberFormatException e) {
                    System.out.println("Rule description error: " + command);
                    return ruleArray;
                }
                boolean isValid = true;
                for (int n = 0; n < statePerCell; ++n) {
                    for (int e = 0; e < statePerCell; ++e) {
                        for (int s = 0; s < statePerCell; ++s) {
                            for (int w = 0; w < statePerCell; ++w) {
                                if (n != c1 && n != c2) {
                                    isValid = false;
                                }
                                if (e != c1 && e != c2) {
                                    isValid = false;
                                }
                                if (s != c1 && s != c2) {
                                    isValid = false;
                                }
                                if (w != c1 && w != c2) {
                                    isValid = false;
                                }
                                if (n == c1 && e == c1 && s == c1 && w == c1) {
                                    isValid = false;
                                }
                                if (n == c2 && e == c2 && s == c2 && w == c2) {
                                    isValid = false;
                                }
                                if (isValid) {
                                    ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, arg3, statePerCell, ruleArray);
                                }
                                isValid = true;
                            }
                        }
                    }
                }
            } else if (arg0.regionMatches(true, 0, "mix3", 0, 4)) {
                int c1 = 0;
                int c2 = 0;
                int c3 = 0;
                try {
                    c1 = Integer.parseInt(arg1);
                    c2 = Integer.parseInt(arg2);
                    c3 = Integer.parseInt(arg3);
                }
                catch (NumberFormatException e) {
                    System.out.println("Rule description error: " + command);
                    return ruleArray;
                }
                boolean isValid = true;
                boolean[] exist = new boolean[]{false, false, false};
                for (int n = 0; n < statePerCell; ++n) {
                    for (int e = 0; e < statePerCell; ++e) {
                        for (int s = 0; s < statePerCell; ++s) {
                            for (int w = 0; w < statePerCell; ++w) {
                                if (n != c1 && n != c2 && n != c3) {
                                    isValid = false;
                                }
                                if (e != c1 && e != c2 && e != c3) {
                                    isValid = false;
                                }
                                if (s != c1 && s != c2 && s != c3) {
                                    isValid = false;
                                }
                                if (w != c1 && w != c2 && w != c3) {
                                    isValid = false;
                                }
                                if (n == c1 || e == c1 || s == c1 || w == c1) {
                                    exist[0] = true;
                                }
                                if (n == c2 || e == c2 || s == c2 || w == c2) {
                                    exist[1] = true;
                                }
                                if (n == c3 || e == c3 || s == c3 || w == c3) {
                                    exist[2] = true;
                                }
                                if (exist[0] && exist[1] && exist[2] && isValid) {
                                    ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, arg4, statePerCell, ruleArray);
                                }
                                for (int i = 0; i < 3; ++i) {
                                    exist[i] = false;
                                }
                                isValid = true;
                            }
                        }
                    }
                }
            } else if (arg0.regionMatches(true, 0, "oneOuter", 0, 8)) {
                int nei = 0;
                try {
                    nei = Integer.parseInt(arg1);
                }
                catch (NumberFormatException e) {
                    System.out.println("Rule description error." + command);
                    return ruleArray;
                }
                for (int n = 0; n < statePerCell; ++n) {
                    for (int e = 0; e < statePerCell; ++e) {
                        for (int s = 0; s < statePerCell; ++s) {
                            for (int w = 0; w < statePerCell; ++w) {
                                if (n != nei && e != nei && s != nei && w != nei) continue;
                                ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, arg2, statePerCell, ruleArray);
                            }
                        }
                    }
                }
            } else {
                if (arg0.regionMatches(true, 0, "outerTot", 0, 8)) {
                    if (home < 0) {
                        System.out.println("Rule description error. Negative home. " + command);
                        return ruleArray;
                    }
                    int nei = 0;
                    try {
                        nei = Integer.parseInt(arg1);
                        if (nei > (statePerCell - 1) * 4) {
                            System.out.println("Rule description error." + command);
                            return ruleArray;
                        }
                        for (int n = 0; n < statePerCell; ++n) {
                            for (int e = 0; e < statePerCell; ++e) {
                                for (int s = 0; s < statePerCell; ++s) {
                                    for (int w = 0; w < statePerCell; ++w) {
                                        if (n + e + s + w != nei) continue;
                                        ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, arg2, statePerCell, ruleArray);
                                    }
                                }
                            }
                        }
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("Rule description error." + command);
                        return ruleArray;
                    }
                }
                if (arg0.regionMatches(true, 0, "randomize", 0, 9)) {
                    if (home < 0) {
                        System.out.println("Rule description error." + command);
                        return ruleArray;
                    }
                    for (int n = 0; n < statePerCell; ++n) {
                        for (int e = 0; e < statePerCell; ++e) {
                            for (int s = 0; s < statePerCell; ++s) {
                                for (int w = 0; w < statePerCell; ++w) {
                                    ruleArray = VNRuleString.setRuleArray(home, n, e, s, w, "rand", statePerCell, ruleArray);
                                }
                            }
                        }
                    }
                } else {
                    if (arg0.regionMatches(true, 0, "rot", 0, 3)) {
                        if (home < 0) {
                            System.out.println("Rule description error." + command);
                            return ruleArray;
                        }
                        if (cmd.wordNumber != 7) {
                            System.out.println("Rule description error: " + command);
                            return ruleArray;
                        }
                        try {
                            int next;
                            int north = Integer.parseInt(arg1);
                            int east = Integer.parseInt(arg2);
                            int south = Integer.parseInt(arg3);
                            int west = Integer.parseInt(arg4);
                            try {
                                next = Integer.parseInt(arg5);
                            }
                            catch (NumberFormatException e) {
                                if (!arg5.regionMatches(true, 0, "arb", 0, 3)) {
                                    System.out.println("Rule description error: " + command);
                                    return ruleArray;
                                }
                                next = RandOut.make(arg5, statePerCell, rnd);
                            }
                            ruleArray = VNRuleString.setRuleArray(home, north, east, south, west, next, statePerCell, ruleArray);
                            ruleArray = VNRuleString.setRuleArray(home, west, north, east, south, next, statePerCell, ruleArray);
                            ruleArray = VNRuleString.setRuleArray(home, south, west, north, east, next, statePerCell, ruleArray);
                            ruleArray = VNRuleString.setRuleArray(home, east, south, west, north, next, statePerCell, ruleArray);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Rule description error: " + command);
                            return ruleArray;
                        }
                    }
                    if (cmd.wordNumber != 0) {
                        System.out.println("Unknown command: " + command);
                        return ruleArray;
                    }
                }
            }
        }
        return ruleArray;
    }

    private static byte[] setRuleArray(int home, int north, int east, int south, int west, int next, int statePerCell, byte[] ruleArray) {
        int sum = 0;
        sum += home * MyMath.ipow(statePerCell, 4);
        sum += north * MyMath.ipow(statePerCell, 3);
        sum += east * MyMath.ipow(statePerCell, 2);
        sum += south * statePerCell;
        ruleArray[sum += west] = (byte)next;
        return ruleArray;
    }

    private static byte[] setRuleArray(int[] home, int[] north, int[] east, int[] south, int[] west, int nextState, int statePerCell, byte[] ruleArray) {
        for (int i1 = 0; i1 < home.length; ++i1) {
            for (int i2 = 0; i2 < north.length; ++i2) {
                for (int i3 = 0; i3 < east.length; ++i3) {
                    for (int i4 = 0; i4 < south.length; ++i4) {
                        for (int i5 = 0; i5 < west.length; ++i5) {
                            ruleArray = VNRuleString.setRuleArray(home[i1], north[i2], east[i3], south[i4], west[i5], nextState, statePerCell, ruleArray);
                        }
                    }
                }
            }
        }
        return ruleArray;
    }

    private static byte[] setRuleArray(int home, int north, int east, int south, int west, String string, int statePerCell, byte[] ruleArray) {
        Random rand = new Random(System.currentTimeMillis());
        try {
            int next = Integer.parseInt(string);
            ruleArray = VNRuleString.setRuleArray(home, north, east, south, west, next, statePerCell, ruleArray);
        }
        catch (NumberFormatException nfe) {
            if (!string.regionMatches(true, 0, "rand", 0, 4)) {
                System.out.println("Rule description error: " + string);
                return ruleArray;
            }
            int next = RandOut.make(string, statePerCell, rand.nextDouble());
            if (next > statePerCell - 1 || next < 0) {
                System.out.println("Rule description error: " + string);
            }
            ruleArray = VNRuleString.setRuleArray(home, north, east, south, west, next, statePerCell, ruleArray);
        }
        return ruleArray;
    }
}

