/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CABatch;
import cambria.CAPhenotype;
import cambria.CARule;
import cambria.CASearch;
import cambria.EvolvingBlockVNRule;
import cambria.jgat.GeneticAlgorithm;
import cambria.jgat.Genotype;
import cambria.jgat.Phenotype;
import cambria.misc.MyFileWriter;
import cambria.misc.MyString;

public class SerialSampling {
    static String[] typeFileName = new String[]{"Check", "Stripe", "Aggre"};

    public static void main(String[] args) {
        try {
            System.out.println("% maxRun is " + args[0]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: >java SerialSampling <maxRun>");
            System.exit(-1);
        }
        int maxRun = MyString.convertIntParameter(args[0]);
        int populationSize = 20;
        int eliteSize = 6;
        double mutationRate = 0.05;
        double crossoverRate = 0.5;
        double finalHs = 0.57;
        double goalOfFitness = 1.0 / finalHs;
        CARule rule = CARule.createRule("EvolvingBlockVNRule");
        String RuleString = "2 5 r:c01010:c01001";
        String RuleFile = null;
        rule.setRule(RuleString, RuleFile);
        ((Genotype)((Object)rule)).randomizeChromosome();
        boolean torus = true;
        String InitType = "random_0.5";
        boolean synchronous = false;
        int x_max = 100;
        int y_max = 100;
        CAPhenotype caPhenotype = new CAPhenotype(rule, torus, InitType, synchronous, x_max, y_max);
        StringBuffer buff = new StringBuffer();
        CASearch.dataLog("% Population size is " + populationSize, buff);
        CASearch.dataLog("% Elite size is " + eliteSize, buff);
        CASearch.dataLog("% Goal of fitness is " + goalOfFitness, buff);
        CASearch.dataLog("% Mutation rate is " + mutationRate, buff);
        CASearch.dataLog("% Crossover rate is " + crossoverRate, buff);
        CASearch.dataLog("% Initial concentration is " + caPhenotype.getConcentration(), buff);
        CASearch.dataLog("% Cell Space Size is " + caPhenotype.getXMax() + " x " + caPhenotype.getYMax(), buff);
        Genotype[] rules = new EvolvingBlockVNRule[populationSize];
        Phenotype[] phenotype = new Phenotype[populationSize];
        for (int i = 0; i < populationSize; ++i) {
            rules[i] = (Genotype)((Object)CARule.createRule("EvolvingBlockVNRule"));
            ((CARule)((Object)rules[i])).setRule(((EvolvingBlockVNRule)rule).getRuleString(), null);
            rules[i].randomizeChromosome();
            phenotype[i] = new CAPhenotype((CARule)((Object)rules[i]), caPhenotype.isTorus(), caPhenotype.getInitType(), caPhenotype.isSynchronous(), caPhenotype.getXMax(), caPhenotype.getYMax());
            phenotype[i].setGoalOfFitness(goalOfFitness);
        }
        GeneticAlgorithm ga = new GeneticAlgorithm(rules, phenotype, eliteSize);
        ga.setMutationRate(mutationRate);
        ga.setCrossoverRate(crossoverRate);
        int i = -1;
        while (i + 1 < maxRun) {
            if (ga.isOptimized()) {
                throw new RuntimeException("Already Optimized");
            }
            ga.step();
            ga.report(buff);
            if (!SerialSampling.isThereOptimizedPhenotype(phenotype)) continue;
            CASearch.dataLog("    Optimized : " + ++i, buff);
            int bestIndividual = GeneticAlgorithm.getBestFitNumber(phenotype, populationSize);
            CASearch.dataLog("     " + bestIndividual + " : " + phenotype[bestIndividual].getFitness(), buff);
            String filename = SerialSampling.getFilename((CAPhenotype)phenotype[bestIndividual], i);
            CASearch.dataLog("     The chromosome best fit is " + bestIndividual + System.getProperty("line.separator"), buff);
            ((EvolvingBlockVNRule)rules[bestIndividual]).saveRuleFile(filename + ".par");
            rules[bestIndividual].randomizeChromosome();
            ga.setOptimized(false);
        }
        MyFileWriter.saveString("SerialSamping.log", buff.toString());
    }

    private static String getFilename(CAPhenotype caPhenotype, int serialNumber) {
        int type = CABatch.derivePatternType(caPhenotype);
        String fileStemName = typeFileName[type - 1];
        StringBuffer str = new StringBuffer().append(fileStemName).append(MyString.getDigits(serialNumber, 3));
        return str.toString();
    }

    private static boolean isThereOptimizedPhenotype(Phenotype[] phenotype) {
        for (int i = 0; i < phenotype.length; ++i) {
            if (!phenotype[i].isOptimized()) continue;
            return true;
        }
        return false;
    }
}

