/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.FrameLocation;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class RawData
extends Frame
implements ActionListener {
    private Button closeButton;
    private Panel p1;
    private Panel p2;
    private float[] xData;
    private float[][] yData;

    public RawData(float[] xData, float[][] yData) {
        super("Raw Data Window");
        if (xData.length != yData[0].length) {
            throw new IllegalArgumentException("X-Y data do not match");
        }
        this.xData = xData;
        this.yData = yData;
        this.middle_section();
        this.bottom_row();
        this.setVisible(true);
        this.pack();
        this.setLocation(FrameLocation.getPoint("right", this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RawData.this.setVisible(false);
            }
        });
    }

    void middle_section() {
        this.p1 = new Panel();
        TextArea infoTA = new TextArea("", 10, 40, 1);
        infoTA.setEditable(false);
        for (int i = 0; i < this.xData.length; ++i) {
            String xString = Float.toString(this.xData[i]);
            infoTA.append(xString);
            String yString = null;
            for (int j = 0; j < this.yData.length; ++j) {
                yString = Float.toString(this.yData[j][i]);
                infoTA.append(" " + yString);
            }
            infoTA.append(System.getProperty("line.separator"));
        }
        this.p1.add("Center", infoTA);
        this.add("Center", this.p1);
    }

    void bottom_row() {
        this.p2 = new Panel();
        this.p2.setLayout(new FlowLayout(2));
        this.closeButton = new Button("close");
        this.closeButton.addActionListener(this);
        this.p2.add(this.closeButton);
        this.add("South", this.p2);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.setVisible(false);
        }
    }
}

