/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Random;

public class Demon
implements AdjustmentListener,
ItemListener {
    private int[] energy;
    private Random rand;
    private int x_max;
    private int y_max;
    private TextArea ta;
    private TextField textField;
    private Checkbox fixedDemonCheckbox;
    private Panel panel;
    private Panel subPanel;
    private Scrollbar presetBetaSlider;
    private Label presetBetaLabel;
    private double presetBeta = 0.441;
    private double coldestBeta = 0.8;
    private double hottestBeta = 0.2;
    private int maxEnergy = 16;
    private int minEnergy = 0;
    private int unitEnergy = 4;
    private int maxEnergyLevel = 5;
    private boolean fixedDemon = true;

    public Demon(int x_max, int y_max) {
        this.x_max = x_max;
        this.y_max = y_max;
        this.energy = new int[x_max * y_max];
        for (int i = 0; i < x_max * y_max; ++i) {
            this.energy[i] = 0;
        }
        this.rand = new Random(System.currentTimeMillis());
        this.ta = new TextArea(5, 40);
        this.ta.setEditable(false);
    }

    public Demon(int x_max, int y_max, int minEnergy, int unitEnergy, int maxEnergyLevel) {
        this(x_max, y_max);
        this.minEnergy = minEnergy;
        this.unitEnergy = unitEnergy;
        this.maxEnergyLevel = maxEnergyLevel;
        this.maxEnergy = minEnergy + (maxEnergyLevel - 1) * unitEnergy;
    }

    public void setColdestBeta(double coldestBeta) {
        this.coldestBeta = coldestBeta;
    }

    public int getUnitxEnergy() {
        return this.unitEnergy;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getMinEnergy() {
        return this.minEnergy;
    }

    public int getEnergy(int x0, int y0) {
        int j = x0 * this.y_max + y0;
        return this.energy[j];
    }

    public void setEnergy(int x0, int y0, int demonEnergy) {
        int j = x0 * this.y_max + y0;
        this.energy[j] = demonEnergy;
    }

    public void addPanel(Container con) {
        if (this.panel == null) {
            this.panel = new Panel();
            this.panel.add(this.ta);
            Choice showChoice = new Choice();
            showChoice.addItem("show average");
            showChoice.addItem("Counts ground states");
            showChoice.addItem("Counts the first excited states");
            showChoice.addItem("Counts the second excited states");
            showChoice.addItem("Counts the third excited states");
            showChoice.addItem("Counts the fourth excited states");
            showChoice.addItemListener(this);
            this.presetBetaLabel = new Label("beta (critical=0.441)");
            int maxUnit = (int)((this.coldestBeta - this.hottestBeta) * 1000.0);
            this.presetBetaSlider = new Scrollbar(0, (int)(-(this.presetBeta - this.coldestBeta) * 1000.0), 10, 0, maxUnit);
            this.presetBetaSlider.addAdjustmentListener(this);
            this.textField = new TextField(Float.toString((float)this.presetBeta), 10);
            this.textField.setEditable(false);
            this.fixedDemonCheckbox = new Checkbox("heat bath", this.fixedDemon);
            this.fixedDemonCheckbox.addItemListener(this);
            this.subPanel = new Panel();
            this.subPanel.setLayout(new GridLayout(0, 1));
            this.subPanel.add(showChoice);
            this.subPanel.add(this.presetBetaLabel);
            this.subPanel.add(this.presetBetaSlider);
            this.subPanel.add(this.textField);
            this.subPanel.add(this.fixedDemonCheckbox);
            this.panel.add("East", this.subPanel);
            con.add(this.panel);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        double pb = this.coldestBeta - (double)e.getValue() / 1000.0;
        this.setPresetBeta(pb);
        this.textField.setText(String.valueOf((float)pb));
    }

    public void taAppend(String string) {
        this.ta.append(string + System.getProperty("line.separator"));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String command = e.getItem().toString();
        if (command.equals("heat bath")) {
            this.setFixedDemon(this.fixedDemonCheckbox.getState());
        } else if (command.equals("show average")) {
            this.ta.append("Average energy " + Double.toString(this.getAveEnergy()) + System.getProperty("line.separator"));
        } else if (command.equals("show 0 count")) {
            this.ta.append("Cell with 0 energy " + Double.toString(this.countDemon(0)) + System.getProperty("line.separator"));
        } else if (command.equals("show 4 count")) {
            this.ta.append("Cell with 4 energy " + Double.toString(this.countDemon(4)) + System.getProperty("line.separator"));
        } else if (command.equals("show 8 count")) {
            this.ta.append("Cell with 8 energy " + Double.toString(this.countDemon(8)) + System.getProperty("line.separator"));
        } else if (command.equals("show 12count")) {
            this.ta.append("Cell with 12 energy " + Double.toString(this.countDemon(12)) + System.getProperty("line.separator"));
        } else if (command.equals("show 16count")) {
            this.ta.append("Cell with 16 energy " + Double.toString(this.countDemon(16)) + System.getProperty("line.separator"));
        } else {
            System.out.println("Demon: No such item source.");
        }
    }

    private void setFixedDemon(boolean fixedDemon) {
        this.fixedDemon = fixedDemon;
    }

    public boolean isFixedDemon() {
        return this.fixedDemon;
    }

    private int countDemon(int e) {
        if (e % this.unitEnergy > 0) {
            System.out.println("Eorror in Demon: Energy not multiple of unit.");
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.x_max * this.y_max; ++i) {
            if (e != this.energy[i]) continue;
            ++sum;
        }
        return sum;
    }

    private double energy2beta(double energy) {
        return 0.25 * Math.log(-1.0 + 4.0 / energy);
    }

    private double beta2energy(double beta) {
        return 4.0 * Math.exp(-4.0 * beta) / (1.0 + Math.exp(-4.0 * beta));
    }

    public void setPresetBeta(double beta) {
        this.presetBeta = beta;
    }

    private double getAveEnergy() {
        int sum = 0;
        for (int i = 0; i < this.x_max * this.y_max; ++i) {
            sum += this.energy[i];
        }
        return (double)sum / (double)(this.x_max * this.y_max);
    }

    public void setAveEnergy() {
        this.heatBath(this.presetBeta);
    }

    public void setAveEnergy(double requestedAveEnergy) {
        double deviation;
        int totalChange;
        if (requestedAveEnergy > (double)this.maxEnergy) {
            System.out.println("Demon: Error in setAveEnergy().");
        }
        if ((totalChange = (int)((deviation = requestedAveEnergy - this.getAveEnergy()) * (double)this.x_max * (double)this.y_max)) >= 0) {
            this.increaseEnergy(totalChange);
        } else {
            totalChange = -totalChange;
            this.decreaseEnergy(totalChange);
        }
    }

    private void increaseEnergy(int sum) {
        while (sum > 0) {
            int i = (int)Math.floor(this.rand.nextDouble() * (double)(this.x_max * this.y_max));
            if (this.energy[i] >= this.maxEnergy) continue;
            int n = i;
            this.energy[n] = this.energy[n] + this.unitEnergy;
            sum -= this.unitEnergy;
        }
    }

    private void decreaseEnergy(int sum) {
        while (sum > 0) {
            int i = (int)Math.floor(this.rand.nextDouble() * (double)(this.x_max * this.y_max));
            if (this.energy[i] <= this.minEnergy) continue;
            int n = i;
            this.energy[n] = this.energy[n] - this.unitEnergy;
            sum -= this.unitEnergy;
        }
    }

    private void heatBath(double beta) {
        int i;
        double normalizedConstant = 0.0;
        double[] relativeProbability = new double[this.maxEnergyLevel];
        double[] normalizedProbability = new double[this.maxEnergyLevel];
        for (i = 0; i < this.maxEnergyLevel; ++i) {
            relativeProbability[i] = Math.exp(-((double)(this.unitEnergy * i)) * beta);
            normalizedConstant += relativeProbability[i];
        }
        for (i = 0; i < this.maxEnergyLevel; ++i) {
            double sum = 0.0;
            if (i > 0) {
                sum = normalizedProbability[i - 1];
            }
            normalizedProbability[i] = sum + relativeProbability[i] / normalizedConstant;
        }
        for (i = 0; i < this.x_max * this.y_max; ++i) {
            double rnd = this.rand.nextDouble();
            int j = -1;
            do {
                this.energy[i] = this.unitEnergy * ++j;
            } while (rnd > normalizedProbability[j] && j < this.maxEnergyLevel - 1);
        }
    }
}

