/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockVNRule;
import cambria.CABatch;
import cambria.CAConfig;
import cambria.CARule;
import cambria.jgat.FitnessLandscape;
import cambria.jgat.GA;
import cambria.jgat.Optimized;
import cambria.jgat.Phenotype;
import cambria.misc.MyFileWriter;
import cambria.misc.MyString;
import java.util.Date;

public class CASearch {
    private CAConfig caConfig;
    private int populationSize;
    private int eliteSize;
    private double mutationRate;
    private double crossoverRate;
    private int maxIter;
    private double finalHs;
    private String runNumber;
    private String defaultFileName = "lastRuleFile";
    private FitnessLandscape[] fitnessLandscape;
    private int fileNumber;
    private int bestIndividual;
    private StringBuffer buff = new StringBuffer();
    private boolean randomizeTransition = true;
    private BlockVNRule bestRule;
    private boolean classify = false;
    private int optimizedType = 0;
    private int[] lastSavedNumber;
    private String[] typeFileName;

    public CASearch(CAConfig caConfig, int populationSize, int eliteSize, double mutationRate, double crossoverRate, int maxIter, double finalHs) {
        this(caConfig, populationSize, eliteSize, mutationRate, crossoverRate, maxIter, finalHs, null);
    }

    public CASearch(CAConfig caConfig, int populationSize, int eliteSize, double mutationRate, double crossoverRate, int maxIter, double finalHs, String runNumber) {
        this.caConfig = caConfig;
        this.populationSize = populationSize;
        this.fitnessLandscape = new CAConfig[populationSize];
        this.eliteSize = eliteSize;
        this.mutationRate = mutationRate;
        this.crossoverRate = crossoverRate;
        this.maxIter = maxIter;
        this.finalHs = finalHs;
        this.runNumber = runNumber;
    }

    public void setRandomizeTransition(boolean randomizeTransition) {
        this.randomizeTransition = randomizeTransition;
    }

    public void setupClassify(boolean classify, int[] lastSavedNumber, String[] typeFileName) {
        this.classify = classify;
        this.lastSavedNumber = lastSavedNumber;
        this.typeFileName = typeFileName;
    }

    public void start() {
        this.bestRule = this.optimizePartitionRule();
        if (this.bestRule != null) {
            if (this.classify) {
                int type = this.getOptimizedType(this.bestRule);
                String fileStemName = this.typeFileName[type - 1];
                int n = type - 1;
                this.lastSavedNumber[n] = this.lastSavedNumber[n] + 1;
                StringBuffer str = new StringBuffer().append(fileStemName).append(MyString.getDigits(this.lastSavedNumber[type - 1], 3));
                this.saveRuleFile(this.bestRule, str.toString());
                this.saveLogFile(str.toString());
            } else {
                this.saveRuleFile(this.bestRule, this.defaultFileName);
                this.saveLogFile(this.defaultFileName);
            }
        }
    }

    public BlockVNRule getOptimizedRule() {
        return this.bestRule;
    }

    private void dataLog(String str) {
        System.out.println(str);
        this.buff.append(str + System.getProperty("line.separator"));
    }

    public static void dataLog(String str, StringBuffer buff) {
        System.out.println(str);
        buff.append(str + System.getProperty("line.separator"));
    }

    private BlockVNRule optimizePartitionRule() {
        BlockVNRule optimizedRule;
        this.dataLog("% Population size is " + this.populationSize);
        this.dataLog("% Elite size is " + this.eliteSize);
        this.dataLog("% Goal of Hs is " + this.finalHs);
        this.dataLog("% Mutation rate is " + this.mutationRate);
        this.dataLog("% Crossover rate is " + this.crossoverRate);
        this.dataLog("% Initial concentration is " + this.caConfig.getConcentration());
        this.dataLog("% Cell Space Size is " + this.caConfig.getXMax() + " x " + this.caConfig.getYMax());
        boolean optimized = false;
        CARule rule = this.caConfig.getCARule();
        if (!(rule instanceof Optimized)) {
            throw new IllegalArgumentException("Illegal rule selected.");
        }
        Optimized[] rules = new BlockVNRule[this.populationSize];
        for (int i = 0; i < this.populationSize; ++i) {
            rules[i] = (Optimized)((Object)CARule.createRule("BlockVNRule"));
            ((CARule)((Object)rules[i])).setRule(((BlockVNRule)rule).getRuleString(), null);
            if (this.randomizeTransition) {
                rules[i].randomizeChromosome();
            } else {
                ((BlockVNRule)rules[i]).copyRule((BlockVNRule)rule);
            }
            this.fitnessLandscape[i] = new CAConfig((CARule)((Object)rules[i]), this.caConfig.isTorus(), this.caConfig.getInitType(), this.caConfig.isSynchronous(), this.caConfig.getXMax(), this.caConfig.getYMax());
            ((CAConfig)this.fitnessLandscape[i]).setFinalHs(this.finalHs);
        }
        GA ga = new GA(rules, this.fitnessLandscape, this.eliteSize);
        ga.setMutationRate(this.mutationRate);
        ga.setCrossoverRate(this.crossoverRate);
        int iter = 0;
        Date date1 = new Date();
        do {
            ga.step();
            if (ga.isOptimized()) {
                optimized = true;
                this.buff.insert(0, "% The rule is optimized" + System.getProperty("line.separator"));
                System.out.println("% The rule is optimized.");
                iter = this.maxIter;
            }
            ga.report(this.buff);
        } while (++iter < this.maxIter);
        Date date2 = new Date();
        double numeric = (double)(date2.getTime() - date1.getTime()) / 60000.0;
        this.buff.insert(0, "% Elasped time to reach the result is " + numeric + " min." + System.getProperty("line.separator"));
        if (optimized) {
            double bestFitness = this.fitnessLandscape[0].getFitness();
            for (int i = 1; i < this.populationSize; ++i) {
                if (!(bestFitness < this.fitnessLandscape[i].getFitness())) continue;
                bestFitness = this.fitnessLandscape[i].getFitness();
                this.bestIndividual = i;
            }
            System.out.println("The chromosome best fit is " + this.bestIndividual);
            optimizedRule = (BlockVNRule)rules[this.bestIndividual];
        } else {
            optimizedRule = null;
        }
        return optimizedRule;
    }

    public int getOptimizedType(BlockVNRule bestRule) {
        if (bestRule.getStatePerCell() == 2 || bestRule.getMaxNeighbor() == 5) {
            return CABatch.derivePatternType((CAConfig)this.fitnessLandscape[this.bestIndividual], 100);
        }
        throw new RuntimeException("This method is not ready for the setting you chose.");
    }

    private void saveLogFile(String fileName) {
        MyFileWriter.saveString(fileName + ".txt", this.buff.toString());
    }

    private void saveRuleFile(BlockVNRule bestRule, String fileName) {
        bestRule.saveRuleFile(fileName + ".par");
    }

    public static boolean isThereOptimizedPhenotype(Phenotype[] phenotype) {
        for (int i = 0; i < phenotype.length; ++i) {
            if (!phenotype[i].isOptimized()) continue;
            return true;
        }
        return false;
    }
}

