/*
 * Decompiled with CFR 0.152.
 */
package tig.tree;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class UtilTree {
    private static final int VERTICTAL_LAYOUT = 1;
    private static final int HORIZONTAL_CENTERED_LAYOUT = 2;

    public static void JTree2Table(DefaultMutableTreeNode rootNode, File output) {
        try {
            FileWriter out = new FileWriter(output);
            Enumeration<TreeNode> enum1 = rootNode.preorderEnumeration();
            int totalCol = rootNode.getDepth() + 1;
            out.write("<TABLE CELLSPACING=\"0\" CELLPADDING=\"0\">\n");
            while (enum1.hasMoreElements()) {
                out.write("<TR>");
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)enum1.nextElement();
                TreeNode[] ancestorNodes = curNode.getPath();
                int l = ancestorNodes.length;
                for (int i = 0; i < l - 1; ++i) {
                    out.write("<TD VALIGN=\"middle\">");
                    DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)ancestorNodes[i];
                    if (i == l - 2) {
                        if (tempNode.getLastChild() == curNode) {
                            out.write("<IMG SRC=\"images_tree/lastnode.gif\" BORDER=\"0\">");
                        } else {
                            out.write("<IMG SRC=\"images_tree/node.gif\" BORDER=\"0\">");
                        }
                    } else {
                        DefaultMutableTreeNode tempNode2 = (DefaultMutableTreeNode)ancestorNodes[i + 1];
                        if (tempNode2 == tempNode.getLastChild()) {
                            out.write("<IMG SRC=\"images_tree/blank.gif\" BORDER=\"0\">");
                        } else {
                            out.write("<IMG SRC=\"images_tree/vertline.gif\" BORDER=\"0\">");
                        }
                    }
                    out.write("</TD>");
                }
                int colspan = totalCol - curNode.getLevel();
                out.write("<TD NOWRAP VALIGN=\"middle\" COLSPAN=\"" + colspan + "\">");
                if (curNode.isLeaf()) {
                    out.write("<IMG SRC=\"images_tree/dochtm.gif\" BORDER=\"0\" ALIGN=\"middle\">");
                } else {
                    out.write("<IMG SRC=\"images_tree/folderclosed.gif\" BORDER=\"0\" ALIGN=\"middle\">");
                }
                out.write("<FONT SIZE=\"2\">" + curNode.toString() + "</FONT>");
                out.write("</TD>");
                out.write("</TR>\n");
            }
            out.write("</TABLE>\n");
            out.close();
        }
        catch (IOException ioe) {
            System.out.println("IOException");
        }
    }
}

