/*
 * Decompiled with CFR 0.152.
 */
package tig.maths;

public abstract class Maths {
    public static final double TWOPI = Math.PI * 2;
    public static final double ln10 = 2.302585092994046;
    public static final double ARCSEC_TO_RAD = 4.84813681109536E-6;
    public static final double RAD_TO_ARCSEC = 206264.80624709636;

    public static double mod360(double nb) {
        while (nb > 360.0) {
            nb -= 360.0;
        }
        while (nb < 0.0) {
            nb += 360.0;
        }
        return nb;
    }

    public static int mod360(int nb) {
        return (int)Maths.mod360((double)nb);
    }

    public static double modX(double nb, double limit) {
        if (nb > 0.0) {
            return nb - Math.floor(nb / limit) * limit;
        }
        return nb + Math.ceil(nb / limit) * limit;
    }

    public static double atan3(double y, double x) {
        double alpha = Math.atan2(y, x);
        if (alpha >= 0.0) {
            return alpha;
        }
        return alpha + Math.PI * 2;
    }

    public static double log10(double x) {
        return Math.log(x) / 2.302585092994046;
    }

    public static int max(int[] a) {
        if (a == null) {
            throw new IllegalArgumentException("paramater 'a' can't be null");
        }
        int n = a.length;
        int max = a[0];
        for (int i = 1; i < n; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    public static double max(double[] a) {
        if (a == null) {
            throw new IllegalArgumentException("paramater 'a' can't be null");
        }
        int n = a.length;
        double max = a[0];
        for (int i = 1; i < n; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
        }
        return max;
    }

    public static double min(double[] a) {
        if (a == null) {
            throw new IllegalArgumentException("paramater 'a' can't be null");
        }
        int n = a.length;
        double min = a[0];
        for (int i = 1; i < n; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
        }
        return min;
    }
}

