/*
 * Decompiled with CFR 0.152.
 */
package tig;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import tig.GeneralConstants;

public class TigBundle
implements GeneralConstants {
    private Properties _data;
    private static final String SEP = "_";

    public TigBundle(Properties p, Locale locale) {
        this.fillData(p, locale);
    }

    public TigBundle(String pathName, Locale locale) throws IOException {
        if (locale == null || locale.getLanguage() == null || locale.getLanguage().equals("")) {
            throw new IllegalArgumentException("Incorrect 'locale' parameter");
        }
        Properties tmpData = new Properties();
        tmpData.load(new FileInputStream(new File(pathName)));
        this.fillData(tmpData, locale);
    }

    public String getString(String key) {
        String strRes = this._data.getProperty(key);
        if (strRes == null) {
            return "";
        }
        return strRes;
    }

    public Properties getData() {
        return this._data;
    }

    private void fillData(Properties tmpData, Locale locale) {
        this._data = new Properties();
        int NB_SUFFIX = 4;
        String[] suffix = new String[4];
        suffix[3] = "";
        if (!locale.getLanguage().equals("")) {
            suffix[2] = SEP + locale.getLanguage();
        }
        if (!locale.getCountry().equals("")) {
            suffix[1] = suffix[2] + SEP + locale.getCountry();
        }
        if (!locale.getVariant().equals("")) {
            suffix[0] = suffix[1] + SEP + locale.getVariant();
        }
        Object[] keys = tmpData.keySet().toArray();
        Arrays.sort(keys);
        int len = keys.length;
        int i = 0;
        block0: while (i < len) {
            String curKey = (String)keys[i];
            String curRoot = TigBundle.getRoot(curKey);
            int begin = i;
            while (i < len && TigBundle.getRoot((String)keys[i]).equals(curRoot)) {
                ++i;
            }
            String[] sameRoots = new String[i - begin];
            for (int j = 0; j < 4; ++j) {
                if (suffix[j] == null) continue;
                for (int k = 0; k < sameRoots.length; ++k) {
                    if (!((String)keys[begin + k]).equals(curRoot + suffix[j])) continue;
                    this._data.setProperty(curRoot, tmpData.getProperty((String)keys[begin + k]));
                    continue block0;
                }
            }
        }
    }

    private static String getRoot(String key) {
        int sepIdx = key.indexOf(SEP);
        String root = sepIdx == -1 ? key : key.substring(0, sepIdx);
        return root;
    }

    public static void main(String[] args) {
        try {
            Locale loc = new Locale("fr", "FR");
            TigBundle tb = new TigBundle("D:\\b_dvpt\\IF\\java\\tig\\test.lang", loc);
            tb.getData().list(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

