/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.util;

import java.io.Serializable;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTMetaData;
import sgtplot.util.Distance;
import sgtplot.util.Temperature;
import sgtplot.util.Velocity;

public class Units
implements Serializable {
    public static final int NONE = 0;
    public static final int TEMPERATURE = 1;
    public static final int VELOCITY = 2;
    public static final int DISTANCE = 3;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;

    public static int getBaseUnit(SGTMetaData meta) {
        if (Temperature.isBaseUnit(meta)) {
            return 1;
        }
        if (Velocity.isBaseUnit(meta)) {
            return 2;
        }
        if (Distance.isBaseUnit(meta)) {
            return 3;
        }
        return 0;
    }

    public static SGTData convertToBaseUnit(SGTData grid, int base, int comp) {
        switch (base) {
            case 1: {
                return Temperature.convertToBaseUnit(grid, comp);
            }
            case 2: {
                return Velocity.convertToBaseUnit(grid, comp);
            }
            case 3: {
                return Distance.convertToBaseUnit(grid, comp);
            }
        }
        return grid;
    }
}

