/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sgtplot.JPane;
import sgtplot.SGLabel;
import sgtplot.pmel.swing.MRJUtil;
import sgtplot.pmel.swing.ThreeDotsButton;
import sgtplot.swing.prop.ColorEntryPanel;
import sgtplot.swing.prop.FontDialog;
import sgtplot.swing.prop.GridBagConstraints;
import sgtplot.util.Point2D;

public class SGLabelDialog
extends JDialog
implements PropertyChangeListener {
    private SGLabel label_;
    private JPane pane_;
    private Font labelFont_;
    private String[] styleNames_ = new String[]{"plain", "bold", "italic", "bold-italic"};
    private boolean ignoreEvent_ = false;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JTabbedPane TabbedPane = new JTabbedPane();
    JPanel textPanel = new JPanel();
    JLabel JLabel9 = new JLabel();
    JTextField labelTextField = new JTextField();
    JLabel JLabel11 = new JLabel();
    ColorEntryPanel textColorPanel = new ColorEntryPanel();
    JLabel JLabel15 = new JLabel();
    JPanel fontPanel = new JPanel();
    JLabel fontLabel = new JLabel();
    ThreeDotsButton fontEditor = new ThreeDotsButton();
    JLabel JLabel16 = new JLabel();
    JTextField heightTextField = new JTextField();
    JLabel JLabel7 = new JLabel();
    JCheckBox labelVisibleCheckBox = new JCheckBox();
    JLabel JLabel6 = new JLabel();
    JCheckBox labelSelectableCheckBox = new JCheckBox();
    JPanel locationPanel = new JPanel();
    JPanel positionPanel = new JPanel();
    JLabel JLabel1 = new JLabel();
    JTextField xPosTextField = new JTextField();
    JLabel JLabel2 = new JLabel();
    JTextField yPosTextField = new JTextField();
    JPanel alignPanel = new JPanel();
    JLabel JLabel3 = new JLabel();
    JComboBox horizComboBox = new JComboBox();
    JLabel JLabel4 = new JLabel();
    JComboBox vertComboBox = new JComboBox();
    JPanel orientPanel = new JPanel();
    JRadioButton horizRadioButton = new JRadioButton();
    JRadioButton vertRadioButton = new JRadioButton();
    TitledBorder alignBorder = new TitledBorder("Alignment");
    TitledBorder positionBorder = new TitledBorder("Position");
    DefaultComboBoxModel horizCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel vertCBModel = new DefaultComboBoxModel();
    TitledBorder orientBorder = new TitledBorder("Orientation");
    private FlowLayout flowLayout1 = new FlowLayout();

    public SGLabelDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i;
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(457, 320);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.fontEditor.setAlignmentY(0.0f);
        this.fontLabel.setAlignmentY(0.0f);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.TabbedPane, "Center");
        this.textPanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.textPanel, "textPanel");
        this.textPanel.setBounds(2, 27, 452, 225);
        this.textPanel.setVisible(false);
        this.JLabel9.setText("Text:");
        this.textPanel.add((Component)this.JLabel9, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelTextField.setColumns(20);
        this.textPanel.add((Component)this.labelTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel11.setText("Color:");
        this.textPanel.add((Component)this.JLabel11, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.textColorPanel.setLayout(new FlowLayout(1, 5, 5));
        this.textPanel.add((Component)this.textColorPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.JLabel15.setText("Font:");
        this.textPanel.add((Component)this.JLabel15, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fontPanel.setLayout(this.flowLayout1);
        this.textPanel.add((Component)this.fontPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fontLabel.setText("Dialog, 12, Bold");
        this.fontPanel.add((Component)this.fontLabel, null);
        this.fontLabel.setForeground(Color.black);
        this.fontEditor.setToolTipText("Edit font.");
        this.fontEditor.setActionCommand("...");
        this.fontPanel.add((Component)this.fontEditor, null);
        this.JLabel16.setText("HeightP:");
        this.textPanel.add((Component)this.JLabel16, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.heightTextField.setColumns(10);
        this.textPanel.add((Component)this.heightTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel7.setText("Visible:");
        this.textPanel.add((Component)this.JLabel7, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelVisibleCheckBox.setSelected(true);
        this.textPanel.add((Component)this.labelVisibleCheckBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.JLabel6.setText("Selectable:");
        this.textPanel.add((Component)this.JLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelSelectableCheckBox.setSelected(true);
        this.textPanel.add((Component)this.labelSelectableCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.locationPanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.locationPanel, "locationPanel");
        this.locationPanel.setBounds(2, 27, 452, 225);
        this.locationPanel.setVisible(false);
        this.positionPanel.setBorder(this.positionBorder);
        this.positionPanel.setLayout(new GridBagLayout());
        this.locationPanel.add((Component)this.positionPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel1.setText("X Position:");
        this.positionPanel.add((Component)this.JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.xPosTextField.setColumns(20);
        this.positionPanel.add((Component)this.xPosTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel2.setText("Y Position:");
        this.positionPanel.add((Component)this.JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.yPosTextField.setColumns(20);
        this.positionPanel.add((Component)this.yPosTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.alignPanel.setBorder(this.alignBorder);
        this.alignPanel.setLayout(new GridBagLayout());
        this.locationPanel.add((Component)this.alignPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel3.setText("Horizontal:");
        this.alignPanel.add((Component)this.JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.horizComboBox.setModel(this.horizCBModel);
        this.alignPanel.add((Component)this.horizComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel4.setText("Vertical:");
        this.alignPanel.add((Component)this.JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.vertComboBox.setModel(this.vertCBModel);
        this.alignPanel.add((Component)this.vertComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.orientPanel.setBorder(this.orientBorder);
        this.orientPanel.setLayout(new GridBagLayout());
        this.locationPanel.add((Component)this.orientPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(5, 10, 5, 0), 20, 15));
        this.orientPanel.setBackground(new Color(204, 204, 204));
        this.horizRadioButton.setHorizontalAlignment(0);
        this.horizRadioButton.setText("Horizontal");
        this.horizRadioButton.setActionCommand("Horizontal");
        this.orientPanel.add((Component)this.horizRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.vertRadioButton.setHorizontalAlignment(0);
        this.vertRadioButton.setText("Vertical");
        this.vertRadioButton.setActionCommand("Vertical");
        this.orientPanel.add((Component)this.vertRadioButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.TabbedPane.setSelectedComponent(this.textPanel);
        this.TabbedPane.setSelectedIndex(0);
        this.TabbedPane.setTitleAt(0, "Text");
        this.TabbedPane.setTitleAt(1, "Position");
        String[] tempString = new String[]{"LEFT", "CENTER", "RIGHT"};
        for (i = 0; i < tempString.length; ++i) {
            this.horizCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"TOP", "MIDDLE", "BOTTOM"};
        for (i = 0; i < tempString.length; ++i) {
            this.vertCBModel.addElement(tempString[i]);
        }
        this.vertComboBox.setSelectedIndex(2);
        this.horizComboBox.setSelectedIndex(0);
        this.setTitle("SGLabel");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.fontEditor.addActionListener(lSymAction);
        this.applyButton.addActionListener(lSymAction);
        if (!MRJUtil.isAquaLookAndFeel()) {
            Insets pup = new Insets(0, 0, 0, 0);
            this.fontEditor.setMargin(pup);
        }
        ButtonGroup orientBG = new ButtonGroup();
        orientBG.add(this.horizRadioButton);
        orientBG.add(this.vertRadioButton);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public SGLabelDialog(String title) {
        this();
        this.setTitle(title);
    }

    public SGLabelDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void SGLabelDialog_WindowClosing(WindowEvent event) {
        this.finish();
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.finish();
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.finish();
        this.updateSGLabel();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateSGLabel();
    }

    public static void main(String[] args) {
        SGLabelDialog la = new SGLabelDialog();
        la.setFont(null);
        la.setTitle("Test SGLabel Dialog");
        la.setVisible(true);
    }

    public void setSGLabel(SGLabel label, JPane pane) {
        this.setJPane(pane);
        this.setSGLabel(label);
    }

    public void setSGLabel(SGLabel label) {
        this.label_ = label;
        this.label_.addPropertyChangeListener(this);
        this.ignoreEvent_ = false;
        this.setSGLabel();
    }

    public SGLabel getSGLabel() {
        return this.label_;
    }

    public void setJPane(JPane pane) {
        this.pane_ = pane;
    }

    public JPane getJPane() {
        return this.pane_;
    }

    private void setSGLabel() {
        this.setTitle("SGLabel - " + this.label_.getId());
        this.labelTextField.setText(this.label_.getText());
        Color col = this.label_.getColor();
        if (col == null && this.pane_ != null) {
            col = this.pane_.getComponent().getForeground();
        }
        this.textColorPanel.setColor(col);
        this.labelFont_ = this.label_.getFont();
        if (this.labelFont_ == null && this.pane_ != null) {
            this.labelFont_ = this.pane_.getComponent().getFont();
        }
        this.fontLabel.setText(this.fontString(this.labelFont_));
        this.heightTextField.setText(String.valueOf(this.label_.getHeightP()));
        this.labelVisibleCheckBox.setSelected(this.label_.isVisible());
        this.labelSelectableCheckBox.setSelected(this.label_.isSelectable());
        Point2D.Double locp = this.label_.getLocationP();
        this.xPosTextField.setText(String.valueOf(locp.x));
        this.yPosTextField.setText(String.valueOf(locp.y));
        this.horizComboBox.setSelectedIndex(this.label_.getHAlign());
        this.vertComboBox.setSelectedIndex(this.label_.getVAlign());
        if (this.label_.getOrientation() == 0) {
            this.horizRadioButton.setSelected(true);
        } else {
            this.vertRadioButton.setSelected(true);
        }
    }

    private void updateSGLabel() {
        this.ignoreEvent_ = true;
        if (this.pane_ != null) {
            this.pane_.setBatch(true, "SGLabelDialog");
        }
        this.label_.setText(this.labelTextField.getText());
        this.label_.setColor(this.textColorPanel.getColor());
        if (this.labelFont_ != null) {
            this.label_.setFont(this.labelFont_);
        }
        this.label_.setHeightP(Double.valueOf(this.heightTextField.getText()));
        this.label_.setVisible(this.labelVisibleCheckBox.isSelected());
        this.label_.setSelectable(this.labelSelectableCheckBox.isSelected());
        double x = Double.valueOf(this.xPosTextField.getText());
        double y = Double.valueOf(this.yPosTextField.getText());
        Point2D.Double locp = new Point2D.Double(x, y);
        this.label_.setLocationP(locp);
        this.label_.setHAlign(this.horizComboBox.getSelectedIndex());
        this.label_.setVAlign(this.vertComboBox.getSelectedIndex());
        boolean horiz = this.horizRadioButton.isSelected();
        if (horiz) {
            this.label_.setOrientation(0);
        } else {
            this.label_.setOrientation(1);
        }
        if (this.pane_ != null) {
            this.pane_.setBatch(false, "SGLabelDialog");
        }
        this.ignoreEvent_ = false;
    }

    void fontEditor_actionPerformed(ActionEvent event) {
        FontDialog fd = new FontDialog();
        int result = fd.showDialog(this.labelFont_);
        if (result == FontDialog.OK_RESPONSE) {
            this.labelFont_ = fd.getFont();
            this.fontLabel.setText(this.fontString(this.labelFont_));
            this.fontLabel.setFont(this.labelFont_);
        }
    }

    String fontString(Font font) {
        int style = (font.isBold() ? 1 : 0) + (font.isItalic() ? 2 : 0);
        return font.getName() + " " + this.styleNames_[style];
    }

    private void finish() {
        this.label_.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.ignoreEvent_) {
            return;
        }
        if (event.getPropertyName().equals("location")) {
            Point2D.Double locp = this.label_.getLocationP();
            this.xPosTextField.setText(String.valueOf(locp.x));
            this.yPosTextField.setText(String.valueOf(locp.y));
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == SGLabelDialog.this) {
                SGLabelDialog.this.SGLabelDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == SGLabelDialog.this.cancelButton) {
                SGLabelDialog.this.cancelButton_actionPerformed(event);
            } else if (object == SGLabelDialog.this.okButton) {
                SGLabelDialog.this.okButton_actionPerformed(event);
            } else if (object == SGLabelDialog.this.fontEditor) {
                SGLabelDialog.this.fontEditor_actionPerformed(event);
            } else if (object == SGLabelDialog.this.applyButton) {
                SGLabelDialog.this.applyButton_actionPerformed(event);
            }
        }
    }
}

