/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sgtplot.JPane;
import sgtplot.Ruler;
import sgtplot.pmel.swing.ThreeDotsButton;
import sgtplot.swing.prop.ColorEntryPanel;
import sgtplot.swing.prop.FontDialog;
import sgtplot.swing.prop.GridBagConstraints;
import sgtplot.util.Range2D;
import sgtplot.util.Rectangle2D;

public class RulerDialog
extends JDialog {
    private JPane pane_;
    private Ruler scale_;
    private Font labelFont_;
    private String[] styleNames_ = new String[]{"plain", "bold", "italic", "bold-italic"};
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JTabbedPane TabbedPane = new JTabbedPane();
    JPanel labelPanel = new JPanel();
    JLabel JLabel3 = new JLabel();
    JTextField intervalTextField = new JTextField();
    JLabel JLabel4 = new JLabel();
    JTextField sigDigitsTextField = new JTextField();
    JLabel JLabel5 = new JLabel();
    JTextField formatTextField = new JTextField();
    JLabel JLabel11 = new JLabel();
    ColorEntryPanel textColorPanel = new ColorEntryPanel();
    JLabel JLabel15 = new JLabel();
    JPanel fontPanel = new JPanel();
    JLabel fontLabel = new JLabel();
    ThreeDotsButton fontEditor = new ThreeDotsButton();
    JLabel JLabel16 = new JLabel();
    JTextField heightTextField = new JTextField();
    JLabel JLabel1 = new JLabel();
    JComboBox positionComboBox = new JComboBox();
    JPanel rangePanel = new JPanel();
    JPanel userPanel = new JPanel();
    JLabel JLabel8 = new JLabel();
    JTextField minUserTextField = new JTextField();
    JLabel JLabel9 = new JLabel();
    JTextField maxUserTextField = new JTextField();
    JLabel JLabel2 = new JLabel();
    JTextField incUserTextField = new JTextField();
    JPanel physicalPanel = new JPanel();
    JLabel JLabel10 = new JLabel();
    JTextField xPhysicalTextField = new JTextField();
    JLabel JLabel17 = new JLabel();
    JTextField yPhysicalTextField = new JTextField();
    JLabel originLabel = new JLabel();
    JTextField widthPhysicalTextField = new JTextField();
    JPanel ticsStylePanel = new JPanel();
    JPanel ticsPanel = new JPanel();
    JLabel JLabel18 = new JLabel();
    JTextField largeTicTextField = new JTextField();
    JLabel JLabel19 = new JLabel();
    JTextField smallTicTextField = new JTextField();
    JLabel JLabel20 = new JLabel();
    JTextField numSmallTicsTextField = new JTextField();
    JLabel JLabel21 = new JLabel();
    JComboBox ticPositionComboBox = new JComboBox();
    JPanel stylePanel = new JPanel();
    JLabel JLabel7 = new JLabel();
    JCheckBox axislVisibleCheckBox = new JCheckBox();
    JLabel JLabel6 = new JLabel();
    JCheckBox axisSelectableCheckBox = new JCheckBox();
    DefaultComboBoxModel horizCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel vertCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel positionCBModel = new DefaultComboBoxModel();
    TitledBorder userBorder = new TitledBorder("User Range");
    TitledBorder physicalBorder = new TitledBorder("Physical Range");
    TitledBorder ticsBorder = new TitledBorder("Tics");
    TitledBorder styleBorder = new TitledBorder("Axis Style");
    DefaultComboBoxModel ticPositionCBModel = new DefaultComboBoxModel();
    private ColorEntryPanel lineColorPanel = new ColorEntryPanel();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel5 = new JLabel();
    private JTextField heightPhysicalTextField = new JTextField();

    public RulerDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i;
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(new Dimension(531, 358));
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.jLabel1.setText("Line Color:");
        this.physicalBorder.setTitle("Physical Bounds");
        this.jLabel5.setText("Height:");
        this.heightPhysicalTextField.setColumns(10);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.TabbedPane, "Center");
        this.labelPanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.labelPanel, "labelPanel");
        this.labelPanel.setBounds(2, 27, 452, 275);
        this.labelPanel.setVisible(false);
        this.JLabel3.setText("Interval:");
        this.labelPanel.add((Component)this.JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.intervalTextField.setColumns(5);
        this.labelPanel.add((Component)this.intervalTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel4.setText("Sig Digits:");
        this.labelPanel.add((Component)this.JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.sigDigitsTextField.setColumns(5);
        this.labelPanel.add((Component)this.sigDigitsTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel5.setText("Format:");
        this.labelPanel.add((Component)this.JLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.formatTextField.setColumns(10);
        this.labelPanel.add((Component)this.formatTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel11.setText("Color:");
        this.labelPanel.add((Component)this.JLabel11, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.textColorPanel.setLayout(new FlowLayout(1, 5, 5));
        this.labelPanel.add((Component)this.textColorPanel, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.JLabel15.setText("Font:");
        this.labelPanel.add((Component)this.JLabel15, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fontPanel.setLayout(new FlowLayout(1, 5, 5));
        this.labelPanel.add((Component)this.fontPanel, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fontLabel.setText("Dialog, 12, Bold");
        this.fontPanel.add(this.fontLabel);
        this.fontLabel.setForeground(Color.black);
        this.fontEditor.setToolTipText("Edit font.");
        this.fontEditor.setActionCommand("...");
        this.fontPanel.add(this.fontEditor);
        this.JLabel16.setText("Height:");
        this.labelPanel.add((Component)this.JLabel16, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.heightTextField.setColumns(10);
        this.labelPanel.add((Component)this.heightTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.JLabel1.setText("Position:");
        this.labelPanel.add((Component)this.JLabel1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.positionComboBox.setModel(this.positionCBModel);
        this.labelPanel.add((Component)this.positionComboBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.rangePanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.rangePanel, "rangePanel");
        this.rangePanel.setBounds(2, 27, 452, 275);
        this.rangePanel.setVisible(false);
        this.userPanel.setBorder(this.userBorder);
        this.userPanel.setLayout(new GridBagLayout());
        this.rangePanel.add((Component)this.userPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel8.setText("Minimum:");
        this.userPanel.add((Component)this.JLabel8, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.minUserTextField.setColumns(25);
        this.userPanel.add((Component)this.minUserTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel9.setText("Maximum:");
        this.userPanel.add((Component)this.JLabel9, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.maxUserTextField.setColumns(25);
        this.userPanel.add((Component)this.maxUserTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel2.setText("Delta:");
        this.userPanel.add((Component)this.JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.incUserTextField.setColumns(25);
        this.userPanel.add((Component)this.incUserTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.physicalPanel.setBorder(this.physicalBorder);
        this.physicalPanel.setLayout(new GridBagLayout());
        this.rangePanel.add((Component)this.physicalPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel10.setText("X:");
        this.physicalPanel.add((Component)this.JLabel10, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.xPhysicalTextField.setColumns(10);
        this.physicalPanel.add((Component)this.xPhysicalTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel17.setText("Y:");
        this.physicalPanel.add((Component)this.JLabel17, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.yPhysicalTextField.setColumns(10);
        this.physicalPanel.add((Component)this.yPhysicalTextField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.originLabel.setText("Width:");
        this.physicalPanel.add((Component)this.originLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.widthPhysicalTextField.setColumns(10);
        this.physicalPanel.add((Component)this.widthPhysicalTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.physicalPanel.add((Component)this.jLabel5, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.physicalPanel.add((Component)this.heightPhysicalTextField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsStylePanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.ticsStylePanel, "ticsStylePanel");
        this.ticsStylePanel.setBounds(2, 27, 452, 275);
        this.ticsStylePanel.setVisible(false);
        this.ticsPanel.setBorder(this.ticsBorder);
        this.ticsPanel.setLayout(new GridBagLayout());
        this.ticsStylePanel.add((Component)this.ticsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 10, 10));
        this.JLabel18.setText("Large Tic Height:");
        this.ticsPanel.add((Component)this.JLabel18, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.largeTicTextField.setColumns(15);
        this.ticsPanel.add((Component)this.largeTicTextField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel19.setText("Small Tic Height:");
        this.ticsPanel.add((Component)this.JLabel19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.smallTicTextField.setColumns(15);
        this.ticsPanel.add((Component)this.smallTicTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel20.setText("Number of Small Tics:");
        this.ticsPanel.add((Component)this.JLabel20, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.numSmallTicsTextField.setColumns(5);
        this.ticsPanel.add((Component)this.numSmallTicsTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel21.setText("Tic Position:");
        this.ticsPanel.add((Component)this.JLabel21, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.ticPositionComboBox.setModel(this.ticPositionCBModel);
        this.ticsPanel.add((Component)this.ticPositionComboBox, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsPanel.add((Component)this.lineColorPanel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.stylePanel.setBorder(this.styleBorder);
        this.stylePanel.setLayout(new GridBagLayout());
        this.ticsStylePanel.add((Component)this.stylePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 20, 10));
        this.JLabel7.setText("Visible:");
        this.stylePanel.add((Component)this.JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.axislVisibleCheckBox.setSelected(true);
        this.stylePanel.add((Component)this.axislVisibleCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.JLabel6.setHorizontalAlignment(4);
        this.JLabel6.setText("Selectable:");
        this.stylePanel.add((Component)this.JLabel6, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 61, 0));
        this.axisSelectableCheckBox.setSelected(true);
        this.stylePanel.add((Component)this.axisSelectableCheckBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.TabbedPane.setSelectedComponent(this.labelPanel);
        this.TabbedPane.setSelectedIndex(0);
        this.TabbedPane.setTitleAt(0, "Label");
        this.TabbedPane.setTitleAt(1, "Range");
        this.TabbedPane.setTitleAt(2, "Tics/Style");
        this.TabbedPane.setTitleAt(3, "Attach");
        String[] tempString = new String[]{"LEFT", "CENTER", "RIGHT"};
        for (i = 0; i < tempString.length; ++i) {
            this.horizCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"TOP", "MIDDLE", "BOTTOM"};
        for (i = 0; i < tempString.length; ++i) {
            this.vertCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"POSITIVE_SIDE", "NEGATIVE_SIDE", "NO_LABEL"};
        for (i = 0; i < tempString.length; ++i) {
            this.positionCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"POSITIVE_SIDE", "NEGATIVE_SIDE", "BOTH_SIDES"};
        for (i = 0; i < tempString.length; ++i) {
            this.ticPositionCBModel.addElement(tempString[i]);
        }
        this.positionComboBox.setSelectedIndex(1);
        this.ticPositionComboBox.setSelectedIndex(1);
        this.setTitle("TimeAxis");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.fontEditor.addActionListener(lSymAction);
        this.applyButton.addActionListener(lSymAction);
        this.minUserTextField.addActionListener(lSymAction);
        this.maxUserTextField.addActionListener(lSymAction);
        this.widthPhysicalTextField.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public RulerDialog(String title) {
        this();
        this.setTitle(title);
    }

    public RulerDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void FontDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.updateRuler();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateRuler();
    }

    public static void main(String[] args) {
        RulerDialog la = new RulerDialog();
        la.setFont(null);
        la.setTitle("Test Ruler Dialog");
        la.setVisible(true);
    }

    public void setRuler(Ruler scale, JPane pane) {
        this.setJPane(pane);
        this.setRuler(scale);
    }

    public void setRuler(Ruler scale) {
        this.scale_ = scale;
        this.setRuler();
    }

    public Ruler getRuler() {
        return this.scale_;
    }

    public void setJPane(JPane pane) {
        this.pane_ = pane;
    }

    public JPane getJPane() {
        return this.pane_;
    }

    private void setRuler() {
        this.setTitle("Ruler - " + this.scale_.getId());
        this.intervalTextField.setText(Integer.toString(this.scale_.getLabelInterval()));
        this.sigDigitsTextField.setText(Integer.toString(this.scale_.getSignificantDigits()));
        this.formatTextField.setText(this.scale_.getLabelFormat());
        Color col = this.scale_.getLabelColor();
        if (col == null) {
            col = this.pane_.getComponent().getForeground();
        }
        this.textColorPanel.setColor(col);
        this.labelFont_ = this.scale_.getLabelFont();
        if (this.labelFont_ == null) {
            this.labelFont_ = this.pane_.getComponent().getFont();
        }
        this.fontLabel.setText(this.fontString(this.labelFont_));
        this.heightTextField.setText(String.valueOf(this.scale_.getLabelHeightP()));
        Range2D urange = this.scale_.getRangeU();
        this.minUserTextField.setText(String.valueOf(urange.start));
        this.maxUserTextField.setText(String.valueOf(urange.end));
        this.incUserTextField.setText(String.valueOf(urange.delta));
        Rectangle2D.Double bounds = this.scale_.getBoundsP();
        this.xPhysicalTextField.setText(String.valueOf(bounds.x));
        this.yPhysicalTextField.setText(String.valueOf(bounds.y));
        this.widthPhysicalTextField.setText(String.valueOf(bounds.width));
        this.heightPhysicalTextField.setText(String.valueOf(bounds.height));
        if (this.scale_.getOrientation() == 0) {
            this.originLabel.setText("Y Origin:");
        } else {
            this.originLabel.setText("X Origin:");
        }
        this.largeTicTextField.setText(String.valueOf(this.scale_.getLargeTicHeightP()));
        this.smallTicTextField.setText(String.valueOf(this.scale_.getSmallTicHeightP()));
        this.numSmallTicsTextField.setText(String.valueOf(this.scale_.getNumberSmallTics()));
        this.ticPositionComboBox.setSelectedIndex(this.scale_.getTicPosition());
        Color lcol = this.scale_.getLineColor();
        if (lcol == null) {
            col = this.pane_.getComponent().getForeground();
        }
        this.lineColorPanel.setColor(col);
        this.axislVisibleCheckBox.setSelected(this.scale_.isVisible());
        this.axisSelectableCheckBox.setSelected(this.scale_.isSelectable());
    }

    private void updateRuler() {
        this.pane_.setBatch(true, "RulerDialog");
        this.scale_.setLabelInterval(Integer.parseInt(this.intervalTextField.getText()));
        this.scale_.setSignificantDigits(Integer.parseInt(this.sigDigitsTextField.getText()));
        this.scale_.setLabelFormat(this.formatTextField.getText());
        this.scale_.setLabelColor(this.textColorPanel.getColor());
        if (this.labelFont_ != null) {
            this.scale_.setLabelFont(this.labelFont_);
        }
        this.scale_.setLabelHeightP(Double.valueOf(this.heightTextField.getText()));
        this.scale_.setLabelPosition(this.positionComboBox.getSelectedIndex());
        double min = Double.valueOf(this.minUserTextField.getText());
        double max = Double.valueOf(this.maxUserTextField.getText());
        double inc = Double.valueOf(this.incUserTextField.getText());
        this.scale_.setRangeU(new Range2D(min, max, inc));
        double x = Double.valueOf(this.xPhysicalTextField.getText());
        double y = Double.valueOf(this.yPhysicalTextField.getText());
        double width = Double.valueOf(this.widthPhysicalTextField.getText());
        double height = Double.valueOf(this.heightPhysicalTextField.getText());
        this.scale_.setBoundsP(new Rectangle2D.Double(x, y, width, height));
        this.scale_.setLargeTicHeightP(Double.valueOf(this.largeTicTextField.getText()));
        this.scale_.setSmallTicHeightP(Double.valueOf(this.smallTicTextField.getText()));
        this.scale_.setNumberSmallTics(Integer.parseInt(this.numSmallTicsTextField.getText()));
        this.scale_.setTicPosition(this.ticPositionComboBox.getSelectedIndex());
        this.scale_.setLineColor(this.lineColorPanel.getColor());
        this.scale_.setVisible(this.axislVisibleCheckBox.isSelected());
        this.scale_.setSelectable(this.axisSelectableCheckBox.isSelected());
        this.pane_.setBatch(false, "RulerDialog");
    }

    void fontEditor_actionPerformed(ActionEvent event) {
        FontDialog fd = new FontDialog();
        int result = fd.showDialog(this.labelFont_);
        if (result == FontDialog.OK_RESPONSE) {
            this.labelFont_ = fd.getFont();
            this.fontLabel.setText(this.fontString(this.labelFont_));
            this.fontLabel.setFont(this.labelFont_);
        }
    }

    String fontString(Font font) {
        int style = (font.isBold() ? 1 : 0) + (font.isItalic() ? 2 : 0);
        return font.getName() + " " + this.styleNames_[style];
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == RulerDialog.this) {
                RulerDialog.this.FontDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RulerDialog.this.cancelButton) {
                RulerDialog.this.cancelButton_actionPerformed(event);
            } else if (object == RulerDialog.this.okButton) {
                RulerDialog.this.okButton_actionPerformed(event);
            } else if (object == RulerDialog.this.fontEditor) {
                RulerDialog.this.fontEditor_actionPerformed(event);
            } else if (object == RulerDialog.this.applyButton) {
                RulerDialog.this.applyButton_actionPerformed(event);
            }
        }
    }
}

