/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import sgtplot.swing.PlotMarkIcon;

public class PlotMarkDialog
extends JDialog {
    private static final int numMarks = 51;
    private int result_;
    private int mark_;
    private JToggleButton[] buttons_ = new JToggleButton[51];
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();

    public PlotMarkDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(288, 201);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setBounds(0, 162, 288, 39);
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.okButton.setBounds(79, 7, 51, 25);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setBounds(135, 7, 73, 25);
        this.mainPanel.setLayout(new GridLayout(4, 11, 0, 0));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setBounds(0, 0, 288, 162);
        this.setTitle("Select a Mark");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public PlotMarkDialog(String title) {
        this();
        this.setTitle(title);
    }

    public PlotMarkDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void PlotMarkDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.result_ = OK_RESPONSE;
        for (int i = 0; i < 51; ++i) {
            if (!this.buttons_[i].isSelected()) continue;
            this.mark_ = i + 1;
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        PlotMarkDialog la = new PlotMarkDialog();
        la.setTitle("Test PlotMark Dialog");
        la.setVisible(true);
    }

    public int showDialog(int mark) {
        this.mark_ = mark;
        this.createButtons();
        this.result_ = CANCEL_RESPONSE;
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    public void setMark(int mark) {
        this.mark_ = mark;
    }

    public int getMark() {
        return this.mark_;
    }

    private void createButtons() {
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < 51; ++i) {
            PlotMarkIcon pmi = new PlotMarkIcon(i + 1);
            this.buttons_[i] = new JToggleButton(pmi);
            this.buttons_[i].setName(Integer.toString(i + 1));
            group.add(this.buttons_[i]);
            this.mainPanel.add(this.buttons_[i]);
        }
        this.buttons_[this.mark_ - 1].setSelected(true);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == PlotMarkDialog.this) {
                PlotMarkDialog.this.PlotMarkDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == PlotMarkDialog.this.cancelButton) {
                PlotMarkDialog.this.cancelButton_actionPerformed(event);
            } else if (object == PlotMarkDialog.this.okButton) {
                PlotMarkDialog.this.okButton_actionPerformed(event);
            }
        }
    }
}

