/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sgtplot.Graph;
import sgtplot.dm.SGTGrid;
import sgtplot.swing.prop.GridBagConstraints;
import sgtplot.util.Range2D;

public class NewLevelsDialog
extends JDialog {
    private int result_;
    private SGTGrid grid_ = null;
    private boolean useSpacing_ = false;
    private boolean rangeComputed_ = false;
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();
    JPanel JPanel1 = new JPanel();
    JLabel JLabel1 = new JLabel();
    JTextField minTextField = new JTextField();
    JLabel JLabel2 = new JLabel();
    JTextField maxTextField = new JTextField();
    JPanel JPanel3 = new JPanel();
    JLabel JLabel3 = new JLabel();
    JTextField nlevelsTextField = new JTextField();
    JLabel JLabel5 = new JLabel();
    JLabel JLabel4 = new JLabel();
    JTextField spacingTextField = new JTextField();
    JPanel JPanel4 = new JPanel();
    JButton computeButton = new JButton();
    JPanel JPanel2 = new JPanel();
    JLabel JLabel6 = new JLabel();
    JTextField minCompTextField = new JTextField();
    JLabel JLabel7 = new JLabel();
    JTextField maxCompTextField = new JTextField();
    TitledBorder titledBorder1 = new TitledBorder("Data Range");
    TitledBorder titledBorder3 = new TitledBorder("Select");
    TitledBorder titledBorder2 = new TitledBorder("Computed Range");

    public NewLevelsDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(282, 366);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setBackground(new Color(204, 204, 204));
        this.JPanel1.setBorder(this.titledBorder1);
        this.JPanel1.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.JPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.JLabel1.setText("Minimum:");
        this.JPanel1.add((Component)this.JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 2), 0, 0));
        this.minTextField.setColumns(15);
        this.JPanel1.add((Component)this.minTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.JLabel2.setText("Maximum:");
        this.JPanel1.add((Component)this.JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 2), 0, 0));
        this.maxTextField.setColumns(15);
        this.JPanel1.add((Component)this.maxTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.JPanel3.setBorder(this.titledBorder3);
        this.JPanel3.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.JPanel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.JLabel3.setText("Number:");
        this.JPanel3.add((Component)this.JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 0, 2), 0, 0));
        this.nlevelsTextField.setColumns(5);
        this.JPanel3.add((Component)this.nlevelsTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.JLabel5.setText("or");
        this.JPanel3.add((Component)this.JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.JLabel5.setBackground(new Color(204, 204, 204));
        this.JLabel5.setForeground(new Color(102, 102, 153));
        this.JLabel4.setText("Spacing:");
        this.JPanel3.add((Component)this.JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 5, 2), 0, 0));
        this.spacingTextField.setColumns(15);
        this.JPanel3.add((Component)this.spacingTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
        this.JPanel4.setLayout(new FlowLayout(1, 5, 5));
        this.mainPanel.add((Component)this.JPanel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.computeButton.setText("Compute \"nice\" Range");
        this.JPanel4.add(this.computeButton);
        this.JPanel2.setBorder(this.titledBorder2);
        this.JPanel2.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.JPanel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.JLabel6.setText("Minimum:");
        this.JPanel2.add((Component)this.JLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 2), 0, 0));
        this.minCompTextField.setEditable(false);
        this.minCompTextField.setColumns(15);
        this.minCompTextField.setEnabled(false);
        this.JPanel2.add((Component)this.minCompTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.JLabel7.setText("Minimum:");
        this.JPanel2.add((Component)this.JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 2), 0, 0));
        this.maxCompTextField.setEditable(false);
        this.maxCompTextField.setColumns(15);
        this.maxCompTextField.setEnabled(false);
        this.JPanel2.add((Component)this.maxCompTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.minTextField.addActionListener(lSymAction);
        this.maxTextField.addActionListener(lSymAction);
        this.nlevelsTextField.addActionListener(lSymAction);
        this.spacingTextField.addActionListener(lSymAction);
        SymPropertyChange lSymPropertyChange = new SymPropertyChange();
        this.computeButton.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public NewLevelsDialog(String title) {
        this();
        this.setTitle(title);
    }

    public NewLevelsDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void NewLevelsDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.result_ = OK_RESPONSE;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        NewLevelsDialog la = new NewLevelsDialog();
        la.setTitle("Test New Levels Dialog");
        la.setVisible(true);
    }

    public int showDialog(SGTGrid grid) {
        this.setGrid(grid);
        this.result_ = CANCEL_RESPONSE;
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    public Range2D getRange() {
        double max;
        double min;
        if (this.rangeComputed_) {
            min = new Double(this.minCompTextField.getText());
            max = new Double(this.maxCompTextField.getText());
        } else {
            min = new Double(this.minTextField.getText());
            max = new Double(this.maxTextField.getText());
        }
        double delta = new Double(this.spacingTextField.getText());
        Range2D range = new Range2D(min, max, delta);
        return range;
    }

    public void setGrid(SGTGrid grid) {
        double zmax;
        double zmin;
        this.grid_ = grid;
        if (this.grid_ == null) {
            this.titledBorder1.setTitle("Enter Range");
            zmin = 0.0;
            zmax = 10.0;
        } else {
            zmin = Double.MAX_VALUE;
            zmax = -1.7976931348623157E308;
            double[] z = this.grid_.getZArray();
            for (int i = 0; i < z.length; ++i) {
                if (Double.isNaN(z[i])) continue;
                zmin = Math.min(zmin, z[i]);
                zmax = Math.max(zmax, z[i]);
            }
        }
        this.minTextField.setText(Double.toString(zmin));
        this.maxTextField.setText(Double.toString(zmax));
        this.useSpacing_ = false;
        this.nlevelsTextField.setText("10");
        this.updateLevSpac();
    }

    private void updateLevSpac() {
        double delta = new Double(this.maxTextField.getText()) - new Double(this.minTextField.getText());
        if (this.useSpacing_) {
            int levels = (int)(delta / new Double(this.spacingTextField.getText()));
            this.nlevelsTextField.setText(Integer.toString(levels));
        } else {
            double spacing = delta / (double)new Integer(this.nlevelsTextField.getText()).intValue();
            this.spacingTextField.setText(Double.toString(spacing));
        }
    }

    void minTextField_actionPerformed(ActionEvent event) {
        this.updateLevSpac();
    }

    void maxTextField_actionPerformed(ActionEvent event) {
        this.updateLevSpac();
    }

    void nlevelsTextField_actionPerformed(ActionEvent event) {
        this.useSpacing_ = false;
        this.updateLevSpac();
    }

    void spacingTextField_actionPerformed(ActionEvent event) {
        this.useSpacing_ = true;
        this.updateLevSpac();
    }

    void computeButton_actionPerformed(ActionEvent event) {
        this.rangeComputed_ = true;
        this.minCompTextField.setEnabled(true);
        this.maxCompTextField.setEnabled(true);
        double min = new Double(this.minTextField.getText());
        double max = new Double(this.maxTextField.getText());
        Range2D range = new Range2D(min, max);
        int levels = Integer.parseInt(this.nlevelsTextField.getText());
        Range2D newRange = Graph.computeRange(range, levels);
        this.spacingTextField.setText(Double.toString(newRange.delta));
        this.minCompTextField.setText(Double.toString(newRange.start));
        this.maxCompTextField.setText(Double.toString(newRange.end));
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == NewLevelsDialog.this) {
                NewLevelsDialog.this.NewLevelsDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == NewLevelsDialog.this.cancelButton) {
                NewLevelsDialog.this.cancelButton_actionPerformed(event);
            } else if (object == NewLevelsDialog.this.okButton) {
                NewLevelsDialog.this.okButton_actionPerformed(event);
            } else if (object == NewLevelsDialog.this.minTextField) {
                NewLevelsDialog.this.minTextField_actionPerformed(event);
            } else if (object == NewLevelsDialog.this.maxTextField) {
                NewLevelsDialog.this.maxTextField_actionPerformed(event);
            } else if (object == NewLevelsDialog.this.nlevelsTextField) {
                NewLevelsDialog.this.nlevelsTextField_actionPerformed(event);
            } else if (object == NewLevelsDialog.this.spacingTextField) {
                NewLevelsDialog.this.spacingTextField_actionPerformed(event);
            } else if (object == NewLevelsDialog.this.computeButton) {
                NewLevelsDialog.this.computeButton_actionPerformed(event);
            }
        }
    }

    class SymPropertyChange
    implements PropertyChangeListener {
        SymPropertyChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
        }
    }
}

