/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sgtplot.JPane;
import sgtplot.LineAttribute;
import sgtplot.pmel.swing.ThreeDotsButton;
import sgtplot.swing.PlotMarkIcon;
import sgtplot.swing.prop.ArrayEditDialog;
import sgtplot.swing.prop.ColorEntryPanel;
import sgtplot.swing.prop.GridBagConstraints;
import sgtplot.swing.prop.LineAttributeDialog_lineStyleComboBox_actionAdapter;
import sgtplot.swing.prop.PlotMarkDialog;

public class LineAttributeDialog
extends JDialog {
    private LineAttribute attr_;
    private PlotMarkIcon pmIcon_;
    private int mark_;
    private JPane[] paneList_ = null;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();
    JLabel JLabel1 = new JLabel();
    ColorEntryPanel colorPanel = new ColorEntryPanel();
    JLabel JLabel5 = new JLabel();
    JComboBox lineStyleComboBox = new JComboBox();
    JLabel JLabel6 = new JLabel();
    JPanel markPanel = new JPanel();
    JLabel plotMarkIconLabel = new JLabel();
    ThreeDotsButton markEditor = new ThreeDotsButton();
    JLabel JLabel7 = new JLabel();
    JTextField markHeightTextField = new JTextField();
    DefaultComboBoxModel lineStyleCBM = new DefaultComboBoxModel();
    DefaultComboBoxModel capStyleCBM = new DefaultComboBoxModel();
    DefaultComboBoxModel miterStyleCBM = new DefaultComboBoxModel();
    JPanel strokePanel = new JPanel();
    TitledBorder strokeBorder;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel JLabel10 = new JLabel();
    JTextField widthTextField = new JTextField();
    JLabel JLabel8 = new JLabel();
    JTextField dashArrayTextField = new JTextField();
    JPanel dashArrayPanel = new JPanel();
    ThreeDotsButton arrayEditor = new ThreeDotsButton();
    JLabel JLabel9 = new JLabel();
    JTextField dashPhaseTextField = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JComboBox capStyleComboBox = new JComboBox();
    JComboBox miterStyleComboBox = new JComboBox();
    JLabel jLabel3 = new JLabel();
    JTextField miterLimitTextField = new JTextField();
    private FlowLayout flowLayout1 = new FlowLayout();
    private FlowLayout flowLayout2 = new FlowLayout();

    public LineAttributeDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i;
        String[] tempString = new String[]{"SOLID", "DASHED", "HEAVY", "HIGHLIGHT", "MARK", "MARK & SOLID", "STROKE"};
        for (i = 0; i < tempString.length; ++i) {
            this.lineStyleCBM.addElement(tempString[i]);
        }
        tempString = new String[]{"BUTT", "ROUND", "SQUARE"};
        for (i = 0; i < tempString.length; ++i) {
            this.capStyleCBM.addElement(tempString[i]);
        }
        tempString = new String[]{"MITER", "ROUND", "BEVEL"};
        for (i = 0; i < tempString.length; ++i) {
            this.miterStyleCBM.addElement(tempString[i]);
        }
        this.strokeBorder = new TitledBorder("");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(500, 490);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.strokePanel.setBorder(this.strokeBorder);
        this.strokePanel.setLayout(this.gridBagLayout1);
        this.strokeBorder.setTitle("Stroke Line Attributes");
        this.JLabel10.setText(" Width:");
        this.widthTextField.setColumns(10);
        this.JLabel8.setText("Dash Array:");
        this.dashArrayPanel.setLayout(this.flowLayout1);
        this.arrayEditor.setActionCommand("...");
        this.JLabel9.setText("Dash Phase:");
        this.dashPhaseTextField.setColumns(10);
        this.jLabel1.setText("Cap Style:");
        this.jLabel2.setText("Miter Style:");
        this.jLabel3.setText("Miter Limit:");
        this.miterLimitTextField.setColumns(10);
        this.capStyleComboBox.setModel(this.capStyleCBM);
        this.miterStyleComboBox.setModel(this.miterStyleCBM);
        this.lineStyleComboBox.addActionListener(new LineAttributeDialog_lineStyleComboBox_actionAdapter(this));
        this.dashArrayTextField.setColumns(28);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setBounds(0, 263, 430, 39);
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.okButton.setBounds(115, 7, 51, 25);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.applyButton.setBounds(171, 7, 65, 25);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setBounds(241, 7, 73, 25);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setBounds(0, 0, 430, 263);
        this.JLabel1.setText("Color:");
        this.mainPanel.add((Component)this.JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 15, 5, 5), 0, 0));
        this.JLabel1.setBounds(65, 43, 33, 15);
        this.colorPanel.setBorder(this.etchedBorder1);
        this.mainPanel.add((Component)this.colorPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 5, 15), 0, 0));
        this.colorPanel.setBounds(108, 29, 295, 39);
        this.JLabel5.setText("Line Style:");
        this.mainPanel.add((Component)this.JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 5, 5), 0, 0));
        this.JLabel5.setBounds(40, 80, 58, 15);
        this.lineStyleComboBox.setModel(this.lineStyleCBM);
        this.mainPanel.add((Component)this.lineStyleComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 15), 0, 0));
        this.lineStyleComboBox.setBounds(108, 73, 92, 24);
        this.JLabel6.setText("Mark:");
        this.mainPanel.add((Component)this.JLabel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 5, 5), 0, 0));
        this.JLabel6.setBounds(66, 133, 32, 15);
        this.markPanel.setLayout(this.flowLayout2);
        this.mainPanel.add((Component)this.markPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 15), 0, 0));
        this.markPanel.setBounds(108, 126, 48, 25);
        this.markPanel.add((Component)this.plotMarkIconLabel, null);
        this.plotMarkIconLabel.setForeground(Color.black);
        this.plotMarkIconLabel.setBounds(0, 0, 0, 0);
        this.markEditor.setActionCommand("...");
        this.markPanel.add((Component)this.markEditor, null);
        this.JLabel7.setText("MarkHeight:");
        this.mainPanel.add((Component)this.JLabel7, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 22, 5, 5), 0, 0));
        this.JLabel7.setBounds(30, 160, 68, 15);
        this.markHeightTextField.setColumns(10);
        this.mainPanel.add((Component)this.markHeightTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 5, 15), 0, 0));
        this.markHeightTextField.setBounds(108, 156, 110, 19);
        this.mainPanel.add((Component)this.strokePanel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 15, 10), 0, 0));
        this.strokePanel.add((Component)this.JLabel10, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.widthTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.JLabel8, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.dashArrayPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.dashArrayPanel.add((Component)this.dashArrayTextField, null);
        this.dashArrayPanel.add((Component)this.arrayEditor, null);
        this.strokePanel.add((Component)this.JLabel9, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.dashPhaseTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.jLabel2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.capStyleComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.miterStyleComboBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.strokePanel.add((Component)this.jLabel3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.strokePanel.add((Component)this.miterLimitTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.lineStyleComboBox.setSelectedIndex(0);
        this.setTitle("LineAttribute Properties");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.applyButton.addActionListener(lSymAction);
        this.markEditor.addActionListener(lSymAction);
        this.arrayEditor.addActionListener(lSymAction);
        this.pmIcon_ = new PlotMarkIcon(1);
        this.plotMarkIconLabel.setIcon(this.pmIcon_);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public LineAttributeDialog(String title) {
        this();
        this.setTitle(title);
    }

    public LineAttributeDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void LineAttributeDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.updateLineAttribute();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateLineAttribute();
    }

    public void setLineAttribute(LineAttribute attr) {
        this.attr_ = attr;
        this.colorPanel.setColor(this.attr_.getColor());
        this.lineStyleComboBox.setSelectedIndex(this.attr_.getStyle());
        int mark = this.attr_.getMark();
        this.changeMark(mark);
        this.markHeightTextField.setText(Double.toString(this.attr_.getMarkHeightP()));
        this.widthTextField.setText(Float.toString(this.attr_.getWidth()));
        float[] da = this.attr_.getDashArray();
        this.dashArrayTextField.setText(this.dashArrayString(da));
        this.dashPhaseTextField.setText(Float.toString(this.attr_.getDashPhase()));
        this.capStyleComboBox.setSelectedIndex(this.attr_.getCapStyle());
        this.miterStyleComboBox.setSelectedIndex(this.attr_.getMiterStyle());
        this.miterLimitTextField.setText(Float.toString(this.attr_.getMiterLimit()));
        this.strokePanelEnabled(this.lineStyleComboBox.getSelectedIndex() == 6);
    }

    private String dashArrayString(float[] da) {
        if (da == null) {
            return "null";
        }
        StringBuffer sbuf = new StringBuffer("{");
        for (int i = 0; i < da.length; ++i) {
            sbuf.append(Float.toString(da[i]) + ", ");
        }
        sbuf.setLength(sbuf.length() - 2);
        sbuf.append("}");
        return sbuf.toString();
    }

    private float[] dashArray() {
        String arrayString = this.dashArrayTextField.getText();
        int start = arrayString.indexOf("{");
        int stop = arrayString.indexOf("}");
        String sub = arrayString.substring(start + 1, stop);
        StringTokenizer token = new StringTokenizer(sub, ",");
        int index = 0;
        float[] array = new float[token.countTokens()];
        while (token.hasMoreTokens()) {
            array[index] = new Float(token.nextToken()).floatValue();
            ++index;
        }
        return array;
    }

    void updateLineAttribute() {
        int i;
        if (this.paneList_ != null) {
            for (i = 0; i < this.paneList_.length; ++i) {
                this.paneList_[i].setBatch(true, "LineAttributeDialog");
            }
        }
        this.attr_.setBatch(true);
        this.attr_.setColor(this.colorPanel.getColor());
        this.attr_.setStyle(this.lineStyleComboBox.getSelectedIndex());
        this.attr_.setMark(this.mark_);
        this.attr_.setMarkHeightP(new Double(this.markHeightTextField.getText()));
        this.attr_.setWidth(new Float(this.widthTextField.getText()).floatValue());
        this.attr_.setDashArray(this.dashArray());
        this.attr_.setDashPhase(new Float(this.dashPhaseTextField.getText()).floatValue());
        this.attr_.setCapStyle(this.capStyleComboBox.getSelectedIndex());
        this.attr_.setMiterStyle(this.miterStyleComboBox.getSelectedIndex());
        this.attr_.setMiterLimit(new Float(this.miterLimitTextField.getText()).floatValue());
        this.attr_.setBatch(false);
        if (this.paneList_ != null) {
            for (i = 0; i < this.paneList_.length; ++i) {
                this.paneList_[i].setBatch(false, "LineAttributeDialog");
            }
        }
    }

    public static void main(String[] args) {
        LineAttribute attr = new LineAttribute();
        LineAttributeDialog la = new LineAttributeDialog();
        la.setLineAttribute(attr);
        la.setTitle("Test LineAttribute Dialog");
        la.setVisible(true);
    }

    void markEditor_actionPerformed(ActionEvent event) {
        PlotMarkDialog pmd = new PlotMarkDialog();
        Point loc = this.markEditor.getLocationOnScreen();
        pmd.setLocation(loc.x, loc.y);
        int result = pmd.showDialog(this.mark_);
        if (result == PlotMarkDialog.OK_RESPONSE) {
            this.changeMark(pmd.getMark());
        }
    }

    private void changeMark(int mark) {
        this.mark_ = mark;
        this.pmIcon_.setMark(mark);
        this.plotMarkIconLabel.repaint();
    }

    void arrayEditor_actionPerformed(ActionEvent event) {
        ArrayEditDialog aed = new ArrayEditDialog();
        Point loc = this.arrayEditor.getLocationOnScreen();
        aed.setLocation(loc.x, loc.y);
        aed.setArray(this.dashArray());
        int result = aed.showDialog();
        if (result == ArrayEditDialog.OK_RESPONSE) {
            this.dashArrayTextField.setText(this.dashArrayString(aed.getFloatArray()));
        }
    }

    void lineStyleComboBox_actionPerformed(ActionEvent e) {
        this.strokePanelEnabled(this.lineStyleComboBox.getSelectedIndex() == 6);
    }

    void strokePanelEnabled(boolean enabled) {
        this.widthTextField.setEnabled(enabled);
        this.dashArrayTextField.setEnabled(enabled);
        this.arrayEditor.setEnabled(enabled);
        this.dashPhaseTextField.setEnabled(enabled);
        this.capStyleComboBox.setEnabled(enabled);
        this.miterStyleComboBox.setEnabled(enabled);
        this.miterLimitTextField.setEnabled(enabled);
    }

    public void setJPane(JPane pane) {
        this.paneList_ = new JPane[1];
        this.paneList_[0] = pane;
    }

    public JPane getJPane() {
        if (this.paneList_ != null) {
            return this.paneList_[0];
        }
        return null;
    }

    public void setJPaneList(JPane[] list) {
        this.paneList_ = list;
    }

    public JPane[] getJPaneList() {
        return this.paneList_;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == LineAttributeDialog.this) {
                LineAttributeDialog.this.LineAttributeDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == LineAttributeDialog.this.cancelButton) {
                LineAttributeDialog.this.cancelButton_actionPerformed(event);
            } else if (object == LineAttributeDialog.this.okButton) {
                LineAttributeDialog.this.okButton_actionPerformed(event);
            } else if (object == LineAttributeDialog.this.applyButton) {
                LineAttributeDialog.this.applyButton_actionPerformed(event);
            } else if (object == LineAttributeDialog.this.markEditor) {
                LineAttributeDialog.this.markEditor_actionPerformed(event);
            } else if (object == LineAttributeDialog.this.arrayEditor) {
                LineAttributeDialog.this.arrayEditor_actionPerformed(event);
            }
        }
    }
}

