/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import sgtplot.ColorMap;
import sgtplot.IndexedColor;

public class ColorSwatchIcon
implements Icon,
PropertyChangeListener {
    private int width_;
    private int height_;
    private IndexedColor cmap_;
    private int index_;
    private Color color_ = null;

    public ColorSwatchIcon(IndexedColor cmap, int index, int size) {
        this.setSize(size);
        this.cmap_ = cmap;
        this.index_ = index;
        ((ColorMap)((Object)this.cmap_)).addPropertyChangeListener(this);
        this.color_ = this.cmap_.getColorByIndex(this.index_);
    }

    public ColorSwatchIcon(Color color, int width, int height) {
        this.index_ = -1;
        this.cmap_ = null;
        this.color_ = color;
        this.width_ = width;
        this.height_ = height;
    }

    public int getIndex() {
        return this.index_;
    }

    public Color getColor() {
        return this.color_;
    }

    public void setSize(int size) {
        this.width_ = size;
        this.height_ = size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color_);
        g.fillRect(x, y, this.width_, this.height_);
    }

    @Override
    public int getIconWidth() {
        return this.width_;
    }

    @Override
    public int getIconHeight() {
        return this.height_;
    }

    public String toString() {
        return "ColorSwatchIcon: ";
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Color ncolor;
        if (event.getPropertyName().equals("color") && !(ncolor = this.cmap_.getColorByIndex(this.index_)).equals(this.color_)) {
            this.color_ = ncolor;
        }
    }
}

