/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.pmel.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.EtchedBorder;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.pmel.swing.beans.SliderHandle;
import sgtplot.util.Range;

public class JSlider2
extends JComponent
implements Serializable {
    protected Range rawRange_;
    protected int handleSize_;
    protected Dimension size_;
    protected int yval_;
    boolean showBorder_;
    boolean twoHandles_;
    boolean alwaysPost_;
    SliderHandle minHandle_;
    SliderHandle maxHandle_;
    int min_;
    int max_;
    double scale_;
    double minValue_;
    double maxValue_;
    double minOld_;
    double maxOld_;
    String minLabel_;
    String maxLabel_;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    boolean indexed_ = false;
    double[] values_;
    int[] pixels_;
    private EtchedBorder eBorder_ = null;

    public JSlider2() {
        this(true);
        this.setSize(40, 40);
    }

    public JSlider2(boolean twoHandles) {
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
        MyComponent aMyComponent = new MyComponent();
        this.addComponentListener(aMyComponent);
        this.twoHandles_ = twoHandles;
        this.showBorder_ = true;
        this.eBorder_ = new EtchedBorder();
        this.setBorder(this.eBorder_);
        this.handleSize_ = 6;
        this.alwaysPost_ = false;
        this.size_ = new Dimension(175, 50);
        this.rawRange_ = new Range(this.handleSize_ + 1, this.size_.width - this.handleSize_ - 1);
        this.reset();
        this.minLabel_ = Double.toString(this.minValue_);
        this.maxLabel_ = Double.toString(this.maxValue_);
        this.minHandle_ = new SliderHandle(this.handleSize_, Color.green, SliderHandle.LEFT);
        this.maxHandle_ = new SliderHandle(this.handleSize_, Color.red, SliderHandle.RIGHT);
        if (!this.twoHandles_) {
            this.minHandle_.setStyle(SliderHandle.SINGLE);
        }
    }

    public void setMinValue(double min) {
        this.minValue_ = Math.max(min, 0.0);
        if (this.minOld_ != this.minValue_) {
            Double tempOld = new Double(this.minOld_);
            this.minOld_ = this.minValue_;
            this.changes.firePropertyChange("minValue", tempOld, new Double(this.minValue_));
        }
        this.repaint();
    }

    public double getMinValue() {
        return this.minValue_;
    }

    public void setMaxValue(double max) {
        this.maxValue_ = Math.min(max, 1.0);
        if (this.maxOld_ != this.maxValue_) {
            Double tempOld = new Double(this.maxOld_);
            this.maxOld_ = this.maxValue_;
            this.changes.firePropertyChange("maxValue", tempOld, new Double(this.maxValue_));
        }
        this.repaint();
    }

    public double getMaxValue() {
        return this.maxValue_;
    }

    public void reset() {
        this.maxValue_ = 1.0;
        this.minValue_ = 0.0;
        this.maxOld_ = 1.0;
        this.minOld_ = 0.0;
    }

    public void setMinLabel(String lab) {
        this.minLabel_ = lab;
        this.repaint();
    }

    public String getMinLabel() {
        return this.minLabel_;
    }

    public void setMaxLabel(String lab) {
        this.maxLabel_ = lab;
        this.repaint();
    }

    public String getMaxLabel() {
        return this.maxLabel_;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public void setTwoHandles(boolean th) {
        this.twoHandles_ = th;
        if (this.twoHandles_) {
            this.minHandle_.setStyle(SliderHandle.LEFT);
        } else {
            this.minHandle_.setStyle(SliderHandle.SINGLE);
        }
        this.repaint();
    }

    public boolean isTwoHandles() {
        return this.twoHandles_;
    }

    public boolean getTwoHandles() {
        return this.twoHandles_;
    }

    public void setShowBorder(boolean sb) {
        this.showBorder_ = sb;
        if (!this.showBorder_) {
            this.setBorder(null);
        }
        this.repaint();
    }

    public boolean isShowBorder() {
        return this.showBorder_;
    }

    public boolean getShowBorder() {
        return this.showBorder_;
    }

    public void setHandleSize(int sz) {
        if (this.handleSize_ != sz) {
            this.handleSize_ = sz;
            this.minHandle_ = new SliderHandle(this.handleSize_, Color.green);
            this.maxHandle_ = new SliderHandle(this.handleSize_, Color.red);
            this.repaint();
        }
    }

    public int getHandleSize() {
        return this.handleSize_;
    }

    public void setAlwaysPost(boolean ap) {
        this.alwaysPost_ = ap;
    }

    public boolean isAlwaysPost() {
        return this.alwaysPost_;
    }

    public boolean getAlwaysPost() {
        return this.alwaysPost_;
    }

    public Range getRawRange() {
        return this.rawRange_;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.invalidate();
        this.doCompute();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.invalidate();
        this.doCompute();
    }

    @Override
    public void setSize(Dimension size) {
        super.setSize(size);
        this.invalidate();
        this.doCompute();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.invalidate();
        this.doCompute();
    }

    public void setIndexed(boolean ind) {
        this.indexed_ = ind;
    }

    public boolean isIndexed() {
        return this.indexed_;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.min_ = this.rawRange_.start + (int)(this.minValue_ * this.scale_);
        this.max_ = this.rawRange_.start + (int)(this.maxValue_ * this.scale_);
        VectorGraphics g2 = VectorGraphics.create((Graphics)g);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.size_.width, this.size_.height);
        g2.setColor(Color.black);
        g2.setColor(Color.black);
        g2.drawLine(this.rawRange_.start, this.yval_ - 3, this.rawRange_.end, this.yval_ - 3);
        g2.setColor(Color.gray);
        g2.drawLine(this.rawRange_.start, this.yval_ - 2, this.rawRange_.end, this.yval_ - 2);
        g2.setColor(Color.black);
        FontMetrics fmet = g.getFontMetrics();
        int ys = this.yval_ - 8;
        int xs = this.rawRange_.start;
        g2.drawString(this.minLabel_, xs, ys);
        int swidth = fmet.stringWidth(this.maxLabel_);
        xs = this.rawRange_.end - swidth;
        g2.drawString(this.maxLabel_, xs, ys);
        this.minHandle_.draw(g, this.min_, this.yval_);
        if (this.twoHandles_) {
            this.maxHandle_.draw((Graphics)g2, this.max_, this.yval_);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(96, 57);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 57);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MIN_VALUE);
    }

    public void setIndexValues(double[] array) {
        this.values_ = array;
        this.indexed_ = true;
        this.pixels_ = new int[this.values_.length];
        this.doCompute();
    }

    void doCompute() {
        this.size_ = this.getSize();
        this.rawRange_.start = 2 * this.handleSize_ + 1;
        this.rawRange_.end = this.size_.width - 2 * this.handleSize_ - 1;
        this.yval_ = this.size_.height - 3 * this.handleSize_ - 10;
        this.scale_ = this.rawRange_.end - this.rawRange_.start;
        if (this.indexed_) {
            for (int i = 0; i < this.values_.length; ++i) {
                this.pixels_[i] = this.rawRange_.start + (int)(this.values_[i] * this.scale_);
            }
        }
    }

    void doMove(int xpos, boolean forcePost) {
        double value;
        if (xpos > this.rawRange_.end) {
            xpos = this.rawRange_.end;
        }
        if (xpos < this.rawRange_.start) {
            xpos = this.rawRange_.start;
        }
        if (this.indexed_ && forcePost) {
            int ind = 0;
            if (xpos <= this.pixels_[0]) {
                ind = 0;
            } else if (xpos >= this.pixels_[this.pixels_.length - 1]) {
                ind = this.pixels_.length - 1;
            } else {
                for (int i = 0; i < this.pixels_.length - 1; ++i) {
                    if (xpos < this.pixels_[i] || xpos >= this.pixels_[i + 1]) continue;
                    if (xpos - this.pixels_[i] < this.pixels_[i + 1] - xpos) {
                        ind = i;
                        break;
                    }
                    ind = i + 1;
                    break;
                }
            }
            value = this.values_[ind];
            xpos = this.pixels_[ind];
        } else {
            value = (double)(xpos - this.rawRange_.start) / this.scale_;
        }
        if (this.twoHandles_) {
            int toMin = xpos - this.min_;
            int toMax = xpos - this.max_;
            if (toMin < 0) {
                this.minValue_ = value;
            } else if (toMax > 0) {
                this.maxValue_ = value;
            } else if (toMin < -toMax) {
                this.minValue_ = value;
            } else {
                this.maxValue_ = value;
            }
        } else {
            this.minValue_ = value;
        }
        if (forcePost || this.alwaysPost_) {
            if (this.minOld_ != this.minValue_) {
                Double tempOld = new Double(this.minOld_);
                this.minOld_ = this.minValue_;
                this.changes.firePropertyChange("minValue", tempOld, new Double(this.minValue_));
            }
            if (this.maxOld_ != this.maxValue_) {
                Double tempOld = new Double(this.maxOld_);
                this.maxOld_ = this.maxValue_;
                this.changes.firePropertyChange("maxValue", tempOld, new Double(this.maxValue_));
            }
        }
        this.paint(this.getGraphics());
    }

    void JSlider2_MouseClick(MouseEvent event) {
        this.doMove(event.getX(), true);
    }

    void JSlider2_resized(ComponentEvent event) {
        this.doCompute();
    }

    void JSlider2_MouseDrag(MouseEvent event) {
        this.doMove(event.getX(), false);
    }

    void JSlider2_MouseRelease(MouseEvent event) {
        this.doMove(event.getX(), true);
    }

    public static void main(String[] args) {
        double[] values = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        JFrame jf = new JFrame("JSlider2 Test");
        jf.setSize(400, 100);
        jf.getContentPane().setLayout(new BorderLayout());
        JSlider2 js2 = new JSlider2();
        js2.setDoubleBuffered(true);
        js2.setMinValue(0.2);
        js2.setMaxValue(0.8);
        js2.setIndexValues(values);
        js2.setMinLabel("-20 stuff");
        js2.setMaxLabel("20 stuff");
        jf.getContentPane().add((Component)js2, "Center");
        jf.setVisible(true);
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_MouseRelease(event);
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object object = event.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_MouseClick(event);
            }
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_MouseDrag(event);
            }
        }
    }

    class MyComponent
    extends ComponentAdapter {
        MyComponent() {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_resized(event);
            }
        }
    }
}

