/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.dm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import sgtplot.SGLabel;
import sgtplot.dm.Cartesian;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTMetaData;
import sgtplot.dm.SGTTuple;
import sgtplot.util.GeoDate;
import sgtplot.util.GeoDateArray;
import sgtplot.util.Range2D;
import sgtplot.util.SoTRange;

public class SimpleTuple
implements Cloneable,
SGTTuple,
Cartesian,
Serializable {
    private boolean xTime_ = false;
    private boolean yTime_ = false;
    private String title_ = null;
    private SGLabel keyTitle_ = null;
    private String id_ = null;
    private double[] xArray_ = null;
    private double[] yArray_ = null;
    private GeoDateArray tArray_ = null;
    private double[] zArray_ = null;
    private double[] assocArray_ = null;
    protected SGTMetaData xMetaData_ = null;
    protected SGTMetaData yMetaData_ = null;
    protected SGTMetaData zMetaData_ = null;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private Range2D zRange_ = null;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public SimpleTuple(double[] xArray, double[] yArray, String title) {
        this.xArray_ = xArray;
        this.yArray_ = yArray;
        this.xTime_ = false;
        this.yTime_ = false;
        this.title_ = title;
        this.xRange_ = this.computeSoTRange(xArray);
        this.yRange_ = this.computeSoTRange(yArray);
    }

    public SimpleTuple(GeoDate[] xArray, double[] yArray, String title) {
        this.tArray_ = new GeoDateArray(xArray);
        this.yArray_ = yArray;
        this.xTime_ = true;
        this.yTime_ = false;
        this.title_ = title;
        this.xRange_ = this.computeSoTRange(this.tArray_);
        this.yRange_ = this.computeSoTRange(yArray);
    }

    public SimpleTuple(double[] xArray, GeoDate[] yArray, String title) {
        this.xArray_ = xArray;
        this.tArray_ = new GeoDateArray(yArray);
        this.xTime_ = false;
        this.yTime_ = true;
        this.title_ = title;
        this.xRange_ = this.computeSoTRange(xArray);
        this.yRange_ = this.computeSoTRange(this.tArray_);
    }

    public SimpleTuple(double[] xArray, double[] yArray, double[] zArray, String title) {
        this.xArray_ = xArray;
        this.yArray_ = yArray;
        this.zArray_ = zArray;
        this.xTime_ = false;
        this.yTime_ = false;
        this.title_ = title;
        this.xRange_ = this.computeSoTRange(xArray);
        this.yRange_ = this.computeSoTRange(yArray);
        this.zRange_ = this.computeRange2D(zArray);
    }

    public SimpleTuple(GeoDate[] xArray, double[] yArray, double[] zArray, String title) {
        this.tArray_ = new GeoDateArray(xArray);
        this.yArray_ = yArray;
        this.zArray_ = zArray;
        this.xTime_ = true;
        this.yTime_ = false;
        this.title_ = title;
        this.xRange_ = this.computeSoTRange(this.tArray_);
        this.yRange_ = this.computeSoTRange(yArray);
        this.zRange_ = this.computeRange2D(zArray);
    }

    public SimpleTuple(double[] xArray, GeoDate[] yArray, double[] zArray, String title) {
        this.xArray_ = xArray;
        this.tArray_ = new GeoDateArray(yArray);
        this.zArray_ = zArray;
        this.xTime_ = false;
        this.yTime_ = true;
        this.title_ = title;
        this.xRange_ = this.computeSoTRange(xArray);
        this.yRange_ = this.computeSoTRange(this.tArray_);
        this.zRange_ = this.computeRange2D(zArray);
    }

    public SimpleTuple() {
        this.xTime_ = false;
        this.yTime_ = false;
    }

    @Override
    public double[] getXArray() {
        return this.xArray_;
    }

    public void setXArray(double[] xArray) {
        this.xArray_ = xArray;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(xArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(xArray.length));
    }

    public void setXArray(GeoDate[] tArray) {
        this.setXArray(new GeoDateArray(tArray));
    }

    public void setXArray(GeoDateArray tArray) {
        this.tArray_ = tArray;
        this.xTime_ = true;
        this.xArray_ = null;
        this.xRange_ = this.computeSoTRange(tArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(tArray.getLength()));
    }

    @Override
    public double[] getYArray() {
        return this.yArray_;
    }

    public void setYArray(double[] yArray) {
        this.yArray_ = yArray;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(yArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(yArray.length));
    }

    public void setYArray(GeoDate[] tArray) {
        this.setYArray(new GeoDateArray(tArray));
    }

    public void setYArray(GeoDateArray tArray) {
        this.tArray_ = tArray;
        this.yTime_ = true;
        this.yArray_ = null;
        this.yRange_ = this.computeSoTRange(tArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(tArray.getLength()));
    }

    @Override
    public double[] getZArray() {
        return this.zArray_;
    }

    public void setZArray(double[] zArray) {
        this.zArray_ = zArray;
        this.zRange_ = this.computeRange2D(zArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(zArray.length));
    }

    @Override
    public int getSize() {
        if (this.xTime_) {
            return this.tArray_.getLength();
        }
        return this.xArray_.length;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return this.tArray_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return this.tArray_;
    }

    @Override
    public double[] getAssociatedData() {
        return this.assocArray_;
    }

    public void setAssociatedData(double[] assocArray) {
        this.assocArray_ = assocArray;
    }

    @Override
    public boolean hasAssociatedData() {
        return this.assocArray_ != null;
    }

    @Override
    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    public void setZMetaData(SGTMetaData zMeta) {
        this.zMetaData_ = zMeta;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    @Override
    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public void setKeyTitle(SGLabel title) {
        this.keyTitle_ = title;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public SGTData copy() {
        SGTTuple newTuple;
        try {
            newTuple = (SGTTuple)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newTuple = new SimpleTuple();
        }
        return newTuple;
    }

    @Override
    public boolean isXTime() {
        return this.xTime_;
    }

    @Override
    public boolean isYTime() {
        return this.yTime_;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public void setXMetaData(SGTMetaData xMeta) {
        this.xMetaData_ = xMeta;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public void setYMetaData(SGTMetaData yMeta) {
        this.yMetaData_ = yMeta;
    }

    @Override
    public SoTRange getXRange() {
        return this.xRange_;
    }

    @Override
    public SoTRange getYRange() {
        return this.yRange_;
    }

    @Override
    public Range2D getZRange() {
        return this.zRange_;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    private SoTRange computeSoTRange(double[] array) {
        Range2D range = this.computeRange2D(array);
        return new SoTRange.Double(range.start, range.end);
    }

    private SoTRange computeSoTRange(GeoDateArray tarray) {
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        long[] tar = tarray.getTime();
        int count = 0;
        for (int i = 0; i < tar.length; ++i) {
            if (tar[i] == Long.MAX_VALUE) continue;
            start = Math.min(start, tar[i]);
            end = Math.max(end, tar[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(start, end);
    }

    private Range2D computeRange2D(double[] array) {
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            start = Math.min(start, array[i]);
            end = Math.max(end, array[i]);
            ++count;
        }
        if (count == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(start, end);
    }
}

