/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.dm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import sgtplot.SGLabel;
import sgtplot.dm.Cartesian;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTLine;
import sgtplot.dm.SGTMetaData;
import sgtplot.util.GeoDate;
import sgtplot.util.GeoDateArray;
import sgtplot.util.SoTRange;

public class SimpleLine
implements SGTLine,
Cartesian,
Serializable,
Cloneable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected GeoDateArray tloc_;
    protected boolean xTime_;
    protected boolean yTime_;
    protected String title_;
    protected SGLabel keyTitle_ = null;
    protected String id_ = null;
    protected SGTMetaData xMetaData_ = null;
    protected SGTMetaData yMetaData_ = null;
    protected SGTLine associatedData_ = null;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public SimpleLine() {
        this((double[])null, (double[])null, "");
    }

    public SimpleLine(double[] xloc, double[] yloc, String title) {
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
    }

    public SimpleLine(GeoDate[] tloc, double[] yloc, String title) {
        this.tloc_ = new GeoDateArray(tloc);
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
    }

    public SimpleLine(GeoDateArray tloc, double[] yloc, String title) {
        this.tloc_ = tloc;
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
    }

    public SimpleLine(double[] xloc, GeoDateArray tloc, String title) {
        this.xloc_ = xloc;
        this.tloc_ = tloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
    }

    public SimpleLine(double[] xloc, GeoDate[] tloc, String title) {
        this.xloc_ = xloc;
        this.tloc_ = new GeoDateArray(tloc);
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
    }

    @Override
    public SGTData copy() {
        SGTLine newLine;
        try {
            newLine = (SGTLine)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newLine = new SimpleLine();
        }
        return newLine;
    }

    @Override
    public double[] getXArray() {
        return this.xloc_;
    }

    @Override
    public double[] getYArray() {
        return this.yloc_;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    @Override
    public boolean isXTime() {
        return this.xTime_;
    }

    @Override
    public boolean isYTime() {
        return this.yTime_;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    public void setId(String ident) {
        this.id_ = ident;
    }

    public void setAssociatedData(SGTLine assoc) {
        this.associatedData_ = assoc;
        this.changes_.firePropertyChange("associatedDataModified", null, assoc);
    }

    @Override
    public SGTLine getAssociatedData() {
        return this.associatedData_;
    }

    @Override
    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    public void setXMetaData(SGTMetaData md) {
        this.xMetaData_ = md;
    }

    public void setYMetaData(SGTMetaData md) {
        this.yMetaData_ = md;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    @Override
    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public void setKeyTitle(SGLabel title) {
        this.keyTitle_ = title;
    }

    public void setXArray(double[] xloc) {
        this.xloc_ = xloc;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(xloc.length));
    }

    public void setYArray(double[] yloc) {
        this.yloc_ = yloc;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(yloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(yloc.length));
    }

    public void setTimeArray(GeoDate[] tloc) {
        this.setTimeArray(new GeoDateArray(tloc));
    }

    public void setTimeArray(GeoDateArray tarray) {
        this.tloc_ = tarray;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(tarray);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(tarray);
        }
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(tarray.getLength()));
    }

    @Override
    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    @Override
    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    private SoTRange computeSoTRange(double[] array) {
        double dstart = Double.POSITIVE_INFINITY;
        double dend = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            dstart = Math.min(dstart, array[i]);
            dend = Math.max(dend, array[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        return new SoTRange.Double(dstart, dend);
    }

    private SoTRange computeSoTRange(GeoDateArray tarray) {
        long tstart = Long.MAX_VALUE;
        long tend = Long.MIN_VALUE;
        long[] tar = tarray.getTime();
        int count = 0;
        for (int i = 0; i < tar.length; ++i) {
            if (tar[i] == Long.MAX_VALUE) continue;
            tstart = Math.min(tstart, tar[i]);
            tend = Math.max(tend, tar[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(tstart, tend);
    }
}

