/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import sgtplot.SGLabel;
import sgtplot.beans.DesignListener;
import sgtplot.beans.PanelHolder;
import sgtplot.swing.ColorSwatchIcon;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.Point2D;
import sgtplot.util.Range2D;
import sgtplot.util.Rectangle2D;
import sgtplot.util.SoTPoint;
import sgtplot.util.SoTRange;

abstract class PropertyPanel
extends JComponent
implements DesignListener {
    private PanelHolder pHolder_ = null;
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Font hdrFont_ = new Font("Dialog", 1, 9);
    private Font textFont_ = new Font("Dialog", 0, 9);
    private Insets lInset = new Insets(2, 1, 1, 3);
    private Insets rInset = new Insets(2, 3, 1, 1);
    private static DecimalFormat numberFormat_ = new DecimalFormat("#.##");
    private String dateFormat_ = "yyyy-MM-dd hh:mm";

    public PropertyPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1.setText("Property");
        this.jLabel1.setFont(this.hdrFont_);
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setHorizontalAlignment(4);
        this.setLayout(this.gridBagLayout1);
        this.jLabel3.setText("Value");
        this.jLabel3.setFont(this.hdrFont_);
        this.jLabel3.setForeground(Color.black);
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, this.lInset, 5, 5));
        this.add((Component)this.jLabel3, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, this.rInset, 10, 5));
    }

    abstract void resetFields();

    public void reset() {
        this.removeAll();
        this.resetFields();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.create();
        this.revalidate();
    }

    protected void addProperty(int row, String propertyName, JComponent component, boolean last) {
        int right;
        int left;
        double weighty;
        JLabel label = new JLabel(propertyName);
        label.setHorizontalAlignment(4);
        label.setFont(this.textFont_);
        component.setFont(this.textFont_);
        if (last) {
            weighty = 1.0;
            left = 12;
            right = 18;
        } else {
            weighty = 0.0;
            left = 13;
            right = 17;
        }
        this.add((Component)label, new GridBagConstraints(0, row, 1, 1, 0.0, weighty, left, 1, this.lInset, 5, 5));
        this.add((Component)component, new GridBagConstraints(1, row, 1, 1, 1.0, weighty, right, 2, this.rInset, 5, 5));
    }

    abstract void update();

    abstract void create();

    protected JTextField createTextField(String text, String action, EventListener listen, boolean edit) {
        JTextField tf = new JTextField(text);
        tf.setActionCommand(action);
        tf.setName(action);
        tf.setEditable(edit);
        if (listen != null) {
            if (listen instanceof ActionListener) {
                tf.addActionListener((ActionListener)listen);
            }
            if (listen instanceof FocusListener) {
                tf.addFocusListener((FocusListener)listen);
            }
        }
        return tf;
    }

    protected JLabel createLabel(String text) {
        JLabel jl = new JLabel(text);
        return jl;
    }

    protected JLabel createLabel(int value) {
        return new JLabel(Integer.toString(value));
    }

    protected JCheckBox createCheckBox(boolean value, String action, ActionListener listen) {
        JCheckBox cb = new JCheckBox("", value);
        cb.setHorizontalTextPosition(2);
        cb.setActionCommand(action);
        if (listen != null) {
            cb.addActionListener(listen);
        }
        return cb;
    }

    protected JComboBox createComboBox(Vector list, int item, String action, ActionListener listen, boolean edit) {
        return this.createComboBox(list.toArray(), item, action, listen, edit);
    }

    protected JComboBox createComboBox(Object[] list, int item, String action, ActionListener listen, boolean edit) {
        JComboBox<Object> cb = new JComboBox<Object>(list);
        cb.setSelectedIndex(item);
        cb.setActionCommand(action);
        cb.setEditable(edit);
        cb.setEnabled(edit);
        if (listen != null) {
            cb.addActionListener(listen);
        }
        return cb;
    }

    protected JButton createSGLabel(SGLabel value, String action, ActionListener listen) {
        if (value == null) {
            return new JButton("null");
        }
        JButton jb = new JButton(value.getText());
        jb.setFont(value.getFont());
        jb.setForeground(value.getColor());
        jb.setActionCommand(action);
        if (listen != null) {
            jb.addActionListener(listen);
        }
        return jb;
    }

    protected Point2D.Double parsePoint2D(String value) {
        StringTokenizer tok = new StringTokenizer(value, ",\t\n\r\f");
        if (tok.countTokens() != 2) {
            JOptionPane.showMessageDialog(this, "Four values required", "Illegal Response", 0);
            return null;
        }
        double x = Double.parseDouble(tok.nextToken().trim());
        double y = Double.parseDouble(tok.nextToken().trim());
        return new Point2D.Double(x, y);
    }

    protected Point parsePoint(String value) {
        StringTokenizer tok = new StringTokenizer(value, ",\t\n\r\f");
        if (tok.countTokens() != 2) {
            JOptionPane.showMessageDialog(this, "Two values required", "Illegal Response", 0);
            return null;
        }
        int x = Integer.parseInt(tok.nextToken().trim());
        int y = Integer.parseInt(tok.nextToken().trim());
        return new Point(x, y);
    }

    protected Dimension parseDimension(String value) {
        StringTokenizer tok = new StringTokenizer(value, ",\t\n\r\f");
        if (tok.countTokens() != 2) {
            JOptionPane.showMessageDialog(this, "Two values required", "Illegal Response", 0);
            return null;
        }
        int width = Integer.parseInt(tok.nextToken().trim());
        int height = Integer.parseInt(tok.nextToken().trim());
        return new Dimension(width, height);
    }

    protected Rectangle2D parseBounds(String value) {
        StringTokenizer tok = new StringTokenizer(value, ",\t\n\r\f");
        if (tok.countTokens() != 4) {
            JOptionPane.showMessageDialog(this, "Four values required", "Illegal Response", 0);
            return null;
        }
        double x = Double.parseDouble(tok.nextToken().trim());
        double y = Double.parseDouble(tok.nextToken().trim());
        double width = Double.parseDouble(tok.nextToken().trim());
        double height = Double.parseDouble(tok.nextToken().trim());
        return new Rectangle2D.Double(x, y, width, height);
    }

    protected SoTRange parseRange(String value, boolean isTime) {
        StringTokenizer tok = new StringTokenizer(value, ",\t\n\r\f");
        if (tok.countTokens() != 3) {
            JOptionPane.showMessageDialog(this, "Three values required", "Illegal Response", 0);
            return null;
        }
        SoTRange range = null;
        if (isTime) {
            try {
                GeoDate start = new GeoDate(tok.nextToken().trim(), this.dateFormat_);
                GeoDate end = new GeoDate(tok.nextToken().trim(), this.dateFormat_);
                long dlta = Long.parseLong(tok.nextToken().trim()) * 86400000L;
                GeoDate delta = new GeoDate(dlta);
                range = new SoTRange.Time(start, end, delta);
            }
            catch (IllegalTimeValue itv) {
                JOptionPane.showMessageDialog(this, "Illegal Time Value", "Illegal Response", 0);
                return null;
            }
        } else {
            double start = Double.parseDouble(tok.nextToken().trim());
            double end = Double.parseDouble(tok.nextToken().trim());
            double delta = Double.parseDouble(tok.nextToken().trim());
            range = new SoTRange.Double(start, end, delta);
        }
        return range;
    }

    protected String colorString(Color value) {
        StringBuffer sbuf = new StringBuffer("[");
        sbuf.append(value.getRed()).append(", ");
        sbuf.append(value.getGreen()).append(", ");
        sbuf.append(value.getRed());
        if (value.getAlpha() == 255) {
            sbuf.append("]");
        } else {
            sbuf.append(", ").append(value.getAlpha()).append("]");
        }
        return sbuf.toString();
    }

    protected JButton createColor(Color value, String action, ActionListener listen) {
        ColorSwatchIcon icon = new ColorSwatchIcon(value, 32, 20);
        JButton jb = new JButton(this.colorString(value), icon);
        jb.setActionCommand(action);
        if (listen != null) {
            jb.addActionListener(listen);
        }
        return jb;
    }

    protected void updateColor(JButton comp, Color value) {
        comp.setText(this.colorString(value));
        ColorSwatchIcon icon = new ColorSwatchIcon(value, 32, 20);
        comp.setIcon(icon);
    }

    protected JButton createFont(Font value, String action, ActionListener listen) {
        JButton jb = new JButton(value.getName());
        jb.setFont(value);
        jb.setActionCommand(action);
        if (listen != null) {
            jb.addActionListener(listen);
        }
        return jb;
    }

    protected void updateFont(JButton comp, Font value) {
        comp.setText(value.getName());
        comp.setFont(value);
    }

    protected void updateSGLabel(JButton comp, SGLabel value) {
        comp.setFont(value.getFont());
        comp.setText(value.getText());
        comp.setForeground(value.getColor());
    }

    protected String format(Point val, boolean brackets) {
        StringBuffer buf = new StringBuffer();
        if (brackets) {
            buf.append("[");
        }
        buf.append(this.format(val.x)).append(", ");
        buf.append(this.format(val.y));
        if (brackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    protected String format(Dimension val, boolean brackets) {
        StringBuffer buf = new StringBuffer();
        if (brackets) {
            buf.append("[");
        }
        buf.append(this.format(val.width)).append(", ");
        buf.append(this.format(val.height));
        if (brackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    protected String format(Rectangle2D.Double val, boolean brackets) {
        StringBuffer buf = new StringBuffer();
        if (brackets) {
            buf.append("[");
        }
        buf.append(this.format(val.x)).append(", ");
        buf.append(this.format(val.y)).append(", ");
        buf.append(this.format(val.width)).append(", ");
        buf.append(this.format(val.height));
        if (brackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    protected String format(Point2D.Double val, boolean brackets) {
        StringBuffer buf = new StringBuffer();
        if (brackets) {
            buf.append("[");
        }
        buf.append(this.format(val.x)).append(", ");
        buf.append(this.format(val.y));
        if (brackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    protected String format(Range2D val, boolean brackets) {
        StringBuffer buf = new StringBuffer();
        if (brackets) {
            buf.append("[");
        }
        buf.append(this.format(val.start)).append(", ");
        buf.append(this.format(val.end)).append(", ");
        buf.append(this.format(val.delta));
        if (brackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    protected String format(SoTRange.Double val, boolean brackets) {
        StringBuffer buf = new StringBuffer();
        if (brackets) {
            buf.append("[");
        }
        buf.append(this.format(val.start)).append(", ");
        buf.append(this.format(val.end)).append(", ");
        buf.append(this.format(val.delta));
        if (brackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    protected String format(SoTRange.Time val, boolean brackets) {
        StringBuffer buf = new StringBuffer();
        if (brackets) {
            buf.append("[");
        }
        buf.append(val.getStart().toString()).append(", ");
        buf.append(val.getEnd().toString()).append(", ");
        buf.append(Long.toString(val.getDelta().getLongTime() / 86400000L));
        if (brackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    protected String format(SoTRange val, boolean brackets) {
        if (val instanceof SoTRange.Float) {
            return this.format((SoTRange.Float)val, brackets);
        }
        if (val instanceof SoTRange.Double) {
            return this.format((SoTRange.Double)val, brackets);
        }
        if (val instanceof SoTRange.Time) {
            return this.format((SoTRange.Time)val, brackets);
        }
        return "";
    }

    protected String format(SoTPoint val, boolean brackets) {
        if (val == null) {
            return "null";
        }
        return val.toString();
    }

    protected String format(float value) {
        return numberFormat_.format(value);
    }

    protected String format(float value, DecimalFormat format) {
        return format.format(value);
    }

    protected String format(double value, DecimalFormat format) {
        return format.format(value);
    }

    protected String format(double value) {
        DecimalFormat format = new DecimalFormat("#.##");
        return format.format(value);
    }

    @Override
    protected void paintBorder(Graphics g) {
        int x0 = 0;
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y0 = 0;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; i += 2) {
            if (i == 0) {
                x0 = comps[0].getBounds().x - this.lInset.left;
                x1 = comps[0].getBounds().x + comps[0].getBounds().width + this.lInset.right;
                x2 = comps[1].getBounds().x + comps[1].getBounds().width;
                y0 = comps[0].getBounds().y - this.lInset.top;
            }
            int y = comps[i].getBounds().y - this.lInset.top;
            if (i >= comps.length - 2) {
                y1 = y;
            }
            g.drawLine(0, y, x2, y);
        }
        g.drawLine(x0, y0, x0, y1);
        g.drawLine(x1, y0, x1, y1);
        g.drawLine(x2, y0, x2, y1);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }

    Frame getFrame() {
        Window fr = SwingUtilities.getWindowAncestor(this);
        if (fr != null && fr instanceof Frame) {
            return (Frame)fr;
        }
        return null;
    }

    public abstract void setExpert(boolean var1);

    public abstract boolean isExpert();
}

