/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import sgtplot.beans.PanelModel;
import sgtplot.beans.PropertyPanel;
import sgtplot.swing.prop.ColorDialog;

class PanelModelPropertyPanel
extends PropertyPanel
implements PropertyChangeListener,
ActionListener {
    private boolean expert_ = false;
    private PanelModel pModel_ = null;
    private String[] pNames_ = new String[]{"DPI", "Page Color", "Page Size", "Panels", "Print Borders", "Print HAlign", "Print Origin", "Print Scale Mode", "Print VAlign", "Print White"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private String[] vAlignItems = new String[]{"Top", "Middle", "Bottom", "Specified Location"};
    private String[] hAlignItems = new String[]{"Left", "Center", "Right", "Specified Location"};
    private String[] sModeItems = new String[]{"Default", "To Fit", "Shrink To Fit"};

    public PanelModelPropertyPanel(PanelModel pm) {
        this.pModel_ = pm;
        this.pModel_.addPropertyChangeListener(this);
        this.create();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    @Override
    void create() {
        int i = -1;
        int item = -1;
        this.comps_[++i] = this.createLabel(Float.toString(this.pModel_.getDpi()));
        this.comps_[++i] = this.createColor(this.pModel_.getPageBackgroundColor(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.format(this.pModel_.getPageSize(), false), this.pNames_[i], this, true);
        this.comps_[++i] = this.createLabel(this.pModel_.getPanelCount());
        this.comps_[++i] = this.createCheckBox(this.pModel_.isPrintBorders(), this.pNames_[i], this);
        switch (this.pModel_.getPrintHAlign()) {
            case 0: {
                item = 0;
                break;
            }
            default: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
                break;
            }
            case -1: {
                item = 3;
            }
        }
        this.comps_[++i] = this.createComboBox(this.hAlignItems, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createTextField(this.format(this.pModel_.getPrintOrigin(), false), this.pNames_[i], this, true);
        switch (this.pModel_.getPrintScaleMode()) {
            default: {
                item = 0;
                break;
            }
            case 0: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
            }
        }
        this.comps_[++i] = this.createComboBox(this.sModeItems, item, this.pNames_[i], (ActionListener)this, true);
        switch (this.pModel_.getPrintVAlign()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
                break;
            }
            case -1: {
                item = 3;
            }
        }
        this.comps_[++i] = this.createComboBox(this.vAlignItems, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createCheckBox(this.pModel_.isPrintWhitePage(), this.pNames_[i], this);
        for (i = 0; i < this.comps_.length; ++i) {
            this.addProperty(i + 1, this.pNames_[i], this.comps_[i], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    @Override
    void update() {
        int i = -1;
        int item = -1;
        ((JLabel)this.comps_[++i]).setText(Float.toString(this.pModel_.getDpi()));
        this.updateColor((JButton)this.comps_[++i], this.pModel_.getPageBackgroundColor());
        ((JTextField)this.comps_[++i]).setText(this.format(this.pModel_.getPageSize(), false));
        ((JLabel)this.comps_[++i]).setText(Integer.toString(this.pModel_.getPanelCount()));
        ((JCheckBox)this.comps_[++i]).setSelected(this.pModel_.isPrintBorders());
        switch (this.pModel_.getPrintHAlign()) {
            case 0: {
                item = 0;
                break;
            }
            default: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
                break;
            }
            case -1: {
                item = 3;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JTextField)this.comps_[++i]).setText(this.format(this.pModel_.getPrintOrigin(), false));
        switch (this.pModel_.getPrintScaleMode()) {
            default: {
                item = 0;
                break;
            }
            case 0: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        switch (this.pModel_.getPrintVAlign()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
                break;
            }
            case -1: {
                item = 3;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JCheckBox)this.comps_[++i]).setSelected(this.pModel_.isPrintWhitePage());
    }

    private void processEvent(Object obj, String command) {
        int item = -1;
        if (command.equals("Page Size")) {
            Dimension size = this.parseDimension(((JTextField)obj).getText());
            this.pModel_.setPageSize(size);
            if (this.pModel_.getPage() != null) {
                this.pModel_.getPage().setSize(size);
            }
        } else if (command.equals("Page Color")) {
            ColorDialog cd = new ColorDialog(this.getFrame(), "Select Axis Color", true);
            cd.setColor(this.pModel_.getPageBackgroundColor());
            cd.setVisible(true);
            Color newcolor = cd.getColor();
            if (newcolor != null) {
                this.pModel_.setPageBackgroundColor(newcolor);
                this.updateColor((JButton)obj, newcolor);
            }
        } else if (command.equals("Print Borders")) {
            this.pModel_.setPrintBorders(((JCheckBox)obj).isSelected());
        } else if (command.equals("Print HAlign")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            item = -1;
            if (str.equals("Left")) {
                item = 0;
            } else if (str.equals("Center")) {
                item = 1;
            } else if (str.equals("Right")) {
                item = 2;
            } else if (str.equals("Specified Location")) {
                item = -1;
            }
            this.pModel_.setPrintHAlign(item);
        } else if (command.equals("Print Origin")) {
            Point pt = this.parsePoint(((JTextField)obj).getText());
            if (pt != null) {
                this.pModel_.setPrintOrigin(pt);
            }
        } else if (command.equals("Print Scale Mode")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            item = -1;
            if (str.equals("Default")) {
                item = 1;
            } else if (str.equals("To Fit")) {
                item = 0;
            } else if (str.equals("Shrink To Fit")) {
                item = 2;
            }
            this.pModel_.setPrintScaleMode(item);
        } else if (command.equals("Print VAlign")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            item = -1;
            if (str.equals("Top")) {
                item = 0;
            } else if (str.equals("Middle")) {
                item = 1;
            } else if (str.equals("Bottom")) {
                item = 2;
            } else if (str.equals("Specified Location")) {
                item = -1;
            }
            this.pModel_.setPrintVAlign(item);
        } else if (command.equals("Print White")) {
            this.pModel_.setPrintWhitePage(((JCheckBox)obj).isSelected());
        }
    }

    @Override
    void resetFields() {
    }

    @Override
    public void setExpert(boolean expert) {
        this.expert_ = expert;
    }

    @Override
    public boolean isExpert() {
        return this.expert_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        String command = e.getActionCommand();
        this.processEvent(obj, command);
    }
}

