/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.border.Border;
import sgtplot.JPane;
import sgtplot.beans.DataHolder;
import sgtplot.beans.DataModel;
import sgtplot.beans.DataTargetMismatchException;
import sgtplot.beans.Panel;
import sgtplot.beans.PanelHolder;
import sgtplot.beans.PanelModel;

public class Page
extends JComponent
implements PropertyChangeListener,
Serializable,
Printable {
    public static final boolean DEBUG = false;
    private DataModel dataModel;
    private PanelModel panelModel;
    private JPane pane_;
    private String name;
    private transient boolean isDesignTime_ = Beans.isDesignTime();

    public Page() {
        this.pane_ = new JPane("SGT Bean Pane", new Dimension(200, 200));
        this.pane_.addPropertyChangeListener(this);
        this.pane_.setBackground(Color.white);
        this.pane_.setOpaque(true);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.add((Component)this.pane_, "Center");
        this.pane_.addMouseListener(new PageMouse());
    }

    public JPane getJPane() {
        return this.pane_;
    }

    public Dimension getJPaneSize() {
        return this.pane_.getSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        DataModel saved = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removePropertyChangeListener(this);
        }
        if (dataModel != null) {
            dataModel.addPropertyChangeListener(this);
        }
        this.dataModel = dataModel;
        this.dataModel.setPage(this);
        if (this.isDesignTime_) {
            this.repaint();
        }
        this.firePropertyChange("dataModel", saved, this.dataModel);
    }

    public PanelModel getPanelModel() {
        return this.panelModel;
    }

    public void setPanelModel(PanelModel panelModel) {
        PanelModel saved = this.panelModel;
        this.setSize(panelModel.getPageSize());
        this.setBackground(panelModel.getPageBackgroundColor());
        this.setPreferredSize(panelModel.getPageSize());
        this.panelModel = panelModel;
        this.panelModel.setPage(this);
        this.updatePanels();
        if (this.isDesignTime_) {
            this.repaint();
        }
        this.firePropertyChange("panelModel", saved, this.panelModel);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.pane_.setBackground(color);
    }

    @Override
    public void setName(String name) {
        this.firePropertyChange("name", this.name, name);
        this.name = name;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String property = evt.getPropertyName();
        if (source instanceof PanelModel) {
            this.updatePanels();
        } else if (source instanceof DataModel) {
            Object obj = evt.getNewValue();
            if (obj instanceof DataHolder) {
                try {
                    this.pane_.setBatch(true);
                    ((DataHolder)obj).notifyPanel();
                    this.pane_.setModified(true, "Page");
                    this.pane_.setBatch(false);
                }
                catch (DataTargetMismatchException dtme) {
                    dtme.printStackTrace();
                }
            }
        } else if (source != this.pane_ || property.equals("objectSelected") || property.equals("zoomRectangle")) {
            // empty if block
        }
    }

    private void updatePanels() {
        this.setSize(this.panelModel.getPageSize());
        this.setBackground(this.panelModel.getPageBackgroundColor());
        this.setPrintHAlign(this.panelModel.getPrintHAlign());
        this.setPrintVAlign(this.panelModel.getPrintVAlign());
        this.setPrintOrigin(this.panelModel.getPrintOrigin());
        this.setPrintScaleMode(this.panelModel.getPrintScaleMode());
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Panel pnl;
            if (!(comps[i] instanceof Panel) || this.panelModel.hasPanelHolder((pnl = (Panel)comps[i]).getName())) continue;
            this.pane_.remove(pnl);
        }
        Panel panel = null;
        Iterator phIter = this.panelModel.panelIterator();
        while (phIter.hasNext()) {
            PanelHolder ph = (PanelHolder)phIter.next();
            panel = this.findPanel(ph);
            if (panel == null) {
                panel = new Panel(ph);
                ph.setInstantiated(true);
                this.pane_.add(panel);
                continue;
            }
            panel.update();
        }
        this.validate();
        this.pane_.setModified(true, "Page");
        this.pane_.setBatch(false);
    }

    public Panel findPanel(PanelHolder pHolder) {
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel) || !((Panel)comps[i]).getName().equals(pHolder.getId())) continue;
            return (Panel)comps[i];
        }
        return null;
    }

    private void pageMousePressed(MouseEvent event) {
        if (!event.isControlDown()) {
            return;
        }
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel)) continue;
            Panel pnl = (Panel)comps[i];
            pnl.resetZoom(event.getX(), event.getY());
        }
        this.pane_.setBatch(false);
    }

    public void resetZoom() {
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel)) continue;
            Panel pnl = (Panel)comps[i];
            pnl.resetZoom();
        }
        this.pane_.setBatch(false);
    }

    private void pageMouseClicked(MouseEvent event) {
        if (event.isControlDown()) {
            return;
        }
        if (event.isPopupTrigger()) {
            System.out.println("Page.pageMouseClicked(): isPopupTrigger()");
        }
        Object obj = this.pane_.getSelectedObject();
        if ((event.getModifiers() & 4) != 0) {
            System.out.println("Page.pageMouseClicked(): Button3!");
        }
    }

    private void pageMouseReleased(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        Rectangle zm = this.pane_.getZoomBounds();
        Point zmStart = this.pane_.getZoomStart();
        if (zm.width <= 1 || zm.height <= 1) {
            return;
        }
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel)) continue;
            Panel pnl = (Panel)comps[i];
            pnl.zoomTo(zmStart, zm);
        }
        this.pane_.setBatch(false);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int result = 1;
        Color saveColor = this.getBackground();
        if (this.panelModel.isPrintWhitePage()) {
            this.setBackground(Color.white);
        }
        if ((result = this.pane_.print(g, pf, pageIndex)) == 0 && this.panelModel.isPrintBorders()) {
            Component[] comps = this.pane_.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof Panel)) continue;
                Panel pnl = (Panel)comps[i];
                Rectangle r = pnl.getBounds();
                Border bdr = pnl.getBorder();
                bdr.paintBorder(pnl, g, r.x, r.y, r.width, r.height);
            }
        }
        this.setBackground(saveColor);
        return result;
    }

    public void setPrintScaleMode(int mode) {
        this.pane_.setPageScaleMode(mode);
    }

    public int getPrintScaleMode() {
        return this.pane_.getPageScaleMode();
    }

    public void setPrintVAlign(int vert) {
        this.pane_.setPageVAlign(vert);
    }

    public void setPrintHAlign(int horz) {
        this.pane_.setPageHAlign(horz);
    }

    public int getPrintVAlign() {
        return this.pane_.getPageVAlign();
    }

    public int getPrintHAlign() {
        return this.pane_.getPageHAlign();
    }

    public void setPrintOrigin(Point pt) {
        this.pane_.setPageOrigin(pt);
    }

    public Point getPrintOrigin() {
        return this.pane_.getPageOrigin();
    }

    class PageMouse
    extends MouseAdapter {
        PageMouse() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!Page.this.pane_.isMouseEventsEnabled()) {
                return;
            }
            Page.this.pageMousePressed(event);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!Page.this.pane_.isMouseEventsEnabled()) {
                return;
            }
            Page.this.pageMouseClicked(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!Page.this.pane_.isMouseEventsEnabled()) {
                return;
            }
            Page.this.pageMouseReleased(event);
        }
    }
}

