/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.beans.DragBox;
import sgtplot.beans.Legend;
import sgtplot.beans.PanelHolder;

class LegendDragBox
extends DragBox
implements ChangeListener {
    private Legend legend_ = null;
    private Rectangle boundsD_ = null;

    public LegendDragBox(Legend legend, PanelHolder pHolder) {
        super(pHolder);
        this.legend_ = legend;
        this.legend_.addChangeListener(this);
        this.boundsD_ = this.toRectangle(this.legend_.getBoundsP());
        for (int i = 0; i < this.handles_.length; ++i) {
            this.handles_[i] = new Rectangle(0, 0, 0, 0);
        }
        this.computeHandles();
    }

    public Legend getLegend() {
        return this.legend_;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.boundsD_ = bounds;
        this.legend_.setBoundsP(this.toRectangle(this.boundsD_));
        this.computeHandles();
    }

    @Override
    public void draw(Graphics g) {
        Rectangle bounds = this.getBounds();
        VectorGraphics g2 = VectorGraphics.create((Graphics)g);
        Color saved = g2.getColor();
        g2.setColor(Color.darkGray);
        g2.drawString(this.getId(), bounds.x + 5, bounds.y + 12);
        g2.setColor(this.color_);
        if (this.legend_.isVisible()) {
            g2.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
        if (this.selected_) {
            for (int i = 0; i < this.handles_.length; ++i) {
                Rectangle r = this.handles_[i];
                g2.fillRect(r.x, r.y, r.width - 1, r.height - 1);
            }
        }
        g2.setColor(saved);
    }

    @Override
    public void setLocation(Point pt) {
        this.boundsD_.x = pt.x;
        this.boundsD_.y = pt.y;
        this.legend_.setBoundsP(this.toRectangle(this.boundsD_));
        this.computeHandles();
    }

    @Override
    public Point getLocation() {
        return new Point(this.boundsD_.x, this.boundsD_.y);
    }

    @Override
    public Rectangle getBounds() {
        return this.boundsD_;
    }

    @Override
    public String getId() {
        return this.legend_.getId();
    }

    @Override
    public void update(String message) {
        this.boundsD_ = this.toRectangle(this.legend_.getBoundsP());
        this.computeHandles();
    }

    @Override
    public void setId(String id) {
        this.legend_.setId(id);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update("LegendDragBox.stateChanged()");
    }
}

